/*
 * Decompiled with CFR 0.152.
 */
package com.rtmpx.library.utils;

import android.annotation.SuppressLint;
import androidx.camera.core.ImageProxy;
import com.rtmpx.library.yuv.YuvFrame;
import com.rtmpx.library.yuv.YuvHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ConvertUtils {
    private static final String TAG = "ConvertUtils";
    private static byte[] mPortraitYUV;
    private static byte[] mLandscapeYUV;

    public static byte[] YUV_420_888toNV12(ImageProxy image, int rotation) {
        if (0 == rotation) {
            return ConvertUtils.YUV_420_888toPortraitNV12(image, rotation);
        }
        return ConvertUtils.YUV_420_888toLandscapeNV12(image, rotation);
    }

    @SuppressLint(value={"UnsafeOptInUsageError"})
    public static byte[] YUV_420_888toLandscapeNV12(ImageProxy image, int rotation) {
        byte[] bytes = YuvHelper.convertToI420(image.getImage()).asArray();
        if (null == mLandscapeYUV || mLandscapeYUV.length != bytes.length) {
            mLandscapeYUV = new byte[bytes.length];
        }
        YuvHelper.I420ToNV12(bytes, image.getWidth(), image.getHeight(), mLandscapeYUV);
        return mLandscapeYUV;
    }

    @SuppressLint(value={"UnsafeOptInUsageError"})
    public static byte[] YUV_420_888toPortraitNV12(ImageProxy image, int rotation) {
        YuvFrame yuvFrame = YuvHelper.convertToI420(image.getImage());
        byte[] bytes = YuvHelper.rotate(yuvFrame, image.getImageInfo().getRotationDegrees()).asArray();
        if (null == mPortraitYUV || mPortraitYUV.length != bytes.length) {
            mPortraitYUV = new byte[bytes.length];
        }
        YuvHelper.I420ToNV12(bytes, image.getWidth(), image.getHeight(), mPortraitYUV);
        return mPortraitYUV;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeFile(ImageProxy mImage, String path) {
        File file = new File(path);
        FileOutputStream output = null;
        ByteBuffer prebuffer = ByteBuffer.allocate(16);
        prebuffer.putInt(mImage.getWidth()).putInt(mImage.getHeight()).putInt(mImage.getPlanes()[1].getPixelStride()).putInt(mImage.getPlanes()[1].getRowStride());
        try {
            output = new FileOutputStream(file);
            output.write(prebuffer.array());
            for (int i = 0; i < 3; ++i) {
                ByteBuffer buffer = mImage.getPlanes()[i].getBuffer();
                byte[] bytes = new byte[buffer.remaining()];
                buffer.get(bytes);
                output.write(bytes);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (null != output) {
                try {
                    output.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

