/*
 * Decompiled with CFR 0.152.
 */
package com.rtmpx.library.record.video;

import android.media.MediaFormat;
import android.media.MediaMuxer;
import android.text.TextUtils;
import android.util.Log;
import com.rtmpx.library.config.Config;
import com.rtmpx.library.rtmp.RTMPFrame;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;

public class VideoRecorder {
    private static final String TAG = "VideoRecorder";
    private MediaMuxer mediaMuxer;
    private Config mConfig;
    private ByteBuffer sps;
    private ByteBuffer pps;
    private ByteBuffer adts;
    private int mAudioTrackIndex;
    private int mVideoTrackIndex;
    private AtomicBoolean muxerStarted = new AtomicBoolean(false);

    public VideoRecorder(Config mVrConfig, ByteBuffer sps, ByteBuffer pps, ByteBuffer adts) {
        this.mConfig = mVrConfig;
        this.sps = sps;
        this.pps = pps;
        this.adts = adts;
    }

    public void startRecord(String targetPath) throws Exception {
        if (TextUtils.isEmpty((CharSequence)targetPath)) {
            Log.d((String)TAG, (String)"record path is null");
            return;
        }
        this.startRecord(new File(targetPath));
    }

    public void startRecord(File targetFile) throws Exception {
        File dir = targetFile.getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (!targetFile.exists()) {
            targetFile.createNewFile();
        }
        if (null == this.mediaMuxer) {
            this.createMuxer(targetFile);
        }
        this.mediaMuxer.start();
        this.muxerStarted.set(true);
    }

    public void stopRecord() {
        if (null != this.mediaMuxer) {
            this.mediaMuxer.stop();
        }
    }

    public void release() {
        if (null != this.mediaMuxer) {
            this.mediaMuxer.release();
        }
        this.muxerStarted.set(false);
    }

    public boolean isStart() {
        return this.muxerStarted.get();
    }

    private void createMuxer(File target) throws Exception {
        this.mediaMuxer = new MediaMuxer(target.getAbsolutePath(), 0);
        MediaFormat videoFormat = MediaFormat.createVideoFormat((String)"video/avc", (int)this.mConfig.getVideoWidth(), (int)this.mConfig.getVideoHeight());
        videoFormat.setByteBuffer("csd-0", this.sps);
        videoFormat.setByteBuffer("csd-1", this.pps);
        videoFormat.setInteger("color-format", 19);
        videoFormat.setInteger("capture-rate", this.mConfig.getFrameRate());
        MediaFormat audioFormat = MediaFormat.createAudioFormat((String)"audio/mp4a-latm", (int)44100, (int)1);
        audioFormat.setByteBuffer("csd-0", this.adts);
        this.mAudioTrackIndex = this.mediaMuxer.addTrack(audioFormat);
        this.mVideoTrackIndex = this.mediaMuxer.addTrack(videoFormat);
    }

    public void writeVideo(RTMPFrame rtmpFrame) {
        if (null == this.mediaMuxer || !this.muxerStarted.get()) {
            return;
        }
        this.mediaMuxer.writeSampleData(this.mVideoTrackIndex, ByteBuffer.wrap(rtmpFrame.getData()), rtmpFrame.getBufferInfo());
    }

    public void writeAudio(RTMPFrame rtmpFrame) {
        if (null == this.mediaMuxer || !this.muxerStarted.get()) {
            return;
        }
        this.mediaMuxer.writeSampleData(this.mAudioTrackIndex, ByteBuffer.wrap(rtmpFrame.getData()), rtmpFrame.getBufferInfo());
    }
}

