/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.scanner.AnnotationInfo;
import io.github.lukehutch.fastclasspathscanner.scanner.ClassInfoUnlinked;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathElement;
import io.github.lukehutch.fastclasspathscanner.scanner.FieldInfo;
import io.github.lukehutch.fastclasspathscanner.scanner.MethodInfo;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import io.github.lukehutch.fastclasspathscanner.utils.MultiMapKeyToSet;
import io.github.lukehutch.fastclasspathscanner.utils.ReflectionUtils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

class ClassfileBinaryParser
implements AutoCloseable {
    private InputStream inputStream;
    private String className;
    private static final int INITIAL_BUFFER_CHUNK_SIZE = 16384;
    private static final int SUBSEQUENT_BUFFER_CHUNK_SIZE = 4096;
    private byte[] buf = new byte[16384];
    private int curr = 0;
    private int used = 0;
    private int[] offset;
    private int[] tag;
    private int[] indirectStringRefs;

    ClassfileBinaryParser() {
    }

    @Override
    public void close() {
    }

    private void readMore(int bytesRequired) throws IOException, InterruptedException {
        int bytesRead;
        int extraBytesNeeded = bytesRequired - (this.used - this.curr);
        int bytesToRequest = extraBytesNeeded + 4096;
        int maxNewUsed = this.used + bytesToRequest;
        if (maxNewUsed > this.buf.length) {
            int newBufLen = this.buf.length;
            while (newBufLen < maxNewUsed) {
                if ((newBufLen <<= 1) > 0) continue;
                throw new IOException("Classfile is bigger than 2GB, cannot read it");
            }
            this.buf = Arrays.copyOf(this.buf, newBufLen);
        }
        for (int extraBytesStillNotRead = extraBytesNeeded; extraBytesStillNotRead > 0; extraBytesStillNotRead -= bytesRead) {
            bytesRead = this.inputStream.read(this.buf, this.used, bytesToRequest);
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            if (bytesRead > 0) {
                this.used += bytesRead;
                bytesToRequest -= bytesRead;
                continue;
            }
            if (extraBytesStillNotRead <= 0) break;
            throw new IOException("Premature EOF while reading classfile");
        }
    }

    private int readUnsignedByte() throws IOException, InterruptedException {
        if (this.curr > this.used - 1) {
            this.readMore(1);
        }
        return this.buf[this.curr++] & 0xFF;
    }

    private int readUnsignedByte(int offset) {
        return this.buf[offset] & 0xFF;
    }

    private int readUnsignedShort() throws IOException, InterruptedException {
        if (this.curr > this.used - 2) {
            this.readMore(2);
        }
        int val = (this.buf[this.curr] & 0xFF) << 8 | this.buf[this.curr + 1] & 0xFF;
        this.curr += 2;
        return val;
    }

    private int readUnsignedShort(int offset) {
        return (this.buf[offset] & 0xFF) << 8 | this.buf[offset + 1] & 0xFF;
    }

    private int readInt() throws IOException, InterruptedException {
        if (this.curr > this.used - 4) {
            this.readMore(4);
        }
        int val = (this.buf[this.curr] & 0xFF) << 24 | (this.buf[this.curr + 1] & 0xFF) << 16 | (this.buf[this.curr + 2] & 0xFF) << 8 | this.buf[this.curr + 3] & 0xFF;
        this.curr += 4;
        return val;
    }

    private int readInt(int offset) throws IOException {
        return (this.buf[offset] & 0xFF) << 24 | (this.buf[offset + 1] & 0xFF) << 16 | (this.buf[offset + 2] & 0xFF) << 8 | this.buf[offset + 3] & 0xFF;
    }

    private long readLong() throws IOException, InterruptedException {
        if (this.curr > this.used - 8) {
            this.readMore(8);
        }
        long val = (long)((this.buf[this.curr] & 0xFF) << 24 | (this.buf[this.curr + 1] & 0xFF) << 16 | (this.buf[this.curr + 2] & 0xFF) << 8 | this.buf[this.curr + 3] & 0xFF) << 32 | (long)((this.buf[this.curr + 4] & 0xFF) << 24) | (long)((this.buf[this.curr + 5] & 0xFF) << 16) | (long)((this.buf[this.curr + 6] & 0xFF) << 8) | (long)(this.buf[this.curr + 7] & 0xFF);
        this.curr += 8;
        return val;
    }

    private long readLong(int offset) throws IOException {
        return (long)((this.buf[offset] & 0xFF) << 24 | (this.buf[offset + 1] & 0xFF) << 16 | (this.buf[offset + 2] & 0xFF) << 8 | this.buf[offset + 3] & 0xFF) << 32 | (long)((this.buf[offset + 4] & 0xFF) << 24) | (long)((this.buf[offset + 5] & 0xFF) << 16) | (long)((this.buf[offset + 6] & 0xFF) << 8) | (long)(this.buf[offset + 7] & 0xFF);
    }

    private void skip(int bytesToSkip) throws IOException, InterruptedException {
        if (this.curr > this.used - bytesToSkip) {
            this.readMore(bytesToSkip);
        }
        this.curr += bytesToSkip;
    }

    private String readString(int strStart, boolean replaceSlashWithDot, boolean stripLSemicolon) {
        int c;
        int byteIdx;
        int utfLen = this.readUnsignedShort(strStart);
        int utfStart = strStart + 2;
        char[] chars = new char[utfLen];
        int charIdx = 0;
        for (byteIdx = 0; byteIdx < utfLen && (c = this.buf[utfStart + byteIdx] & 0xFF) <= 127; ++byteIdx) {
            chars[charIdx++] = (char)(replaceSlashWithDot && c == 47 ? 46 : c);
        }
        block6: while (byteIdx < utfLen) {
            c = this.buf[utfStart + byteIdx] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++byteIdx;
                    chars[charIdx++] = (char)(replaceSlashWithDot && c == 47 ? 46 : c);
                    continue block6;
                }
                case 12: 
                case 13: {
                    if ((byteIdx += 2) > utfLen) {
                        throw new RuntimeException("Bad modified UTF8");
                    }
                    byte c2 = this.buf[utfStart + byteIdx - 1];
                    if ((c2 & 0xC0) != 128) {
                        throw new RuntimeException("Bad modified UTF8");
                    }
                    int c4 = (c & 0x1F) << 6 | c2 & 0x3F;
                    chars[charIdx++] = (char)(replaceSlashWithDot && c4 == 47 ? 46 : c4);
                    continue block6;
                }
                case 14: {
                    if ((byteIdx += 3) > utfLen) {
                        throw new RuntimeException("Bad modified UTF8");
                    }
                    byte c2 = this.buf[utfStart + byteIdx - 2];
                    byte c3 = this.buf[utfStart + byteIdx - 1];
                    if ((c2 & 0xC0) != 128 || (c3 & 0xC0) != 128) {
                        throw new RuntimeException("Bad modified UTF8");
                    }
                    int c4 = (c & 0xF) << 12 | (c2 & 0x3F) << 6 | (c3 & 0x3F) << 0;
                    chars[charIdx++] = (char)(replaceSlashWithDot && c4 == 47 ? 46 : c4);
                    continue block6;
                }
            }
            throw new RuntimeException("Bad modified UTF8");
        }
        if (charIdx == utfLen && !stripLSemicolon) {
            return new String(chars);
        }
        if (stripLSemicolon) {
            if (charIdx < 2 || chars[0] != 'L' || chars[charIdx - 1] != ';') {
                throw new RuntimeException("Expected string to start with 'L' and end with ';', got \"" + new String(chars) + "\"");
            }
            return new String(chars, 1, charIdx - 2);
        }
        return new String(chars, 0, charIdx);
    }

    private int getConstantPoolStringOffset(int cpIdx, int subFieldIdx) {
        int cpIdxToUse;
        int t = this.tag[cpIdx];
        if (t != 12 && subFieldIdx != 0 || t == 12 && subFieldIdx != 0 && subFieldIdx != 1) {
            throw new RuntimeException("Bad subfield index " + subFieldIdx + " for tag " + t + ", cannot continue reading class. Please report this at https://github.com/lukehutch/fast-classpath-scanner/issues");
        }
        if (t == 1) {
            cpIdxToUse = cpIdx;
        } else if (t == 7 || t == 8) {
            int indirIdx = this.indirectStringRefs[cpIdx];
            if (indirIdx == -1) {
                throw new RuntimeException("Bad string indirection index, cannot continue reading class. Please report this at https://github.com/lukehutch/fast-classpath-scanner/issues");
            }
            if (indirIdx == 0) {
                return 0;
            }
            cpIdxToUse = indirIdx;
        } else if (t == 12) {
            int compoundIndirIdx = this.indirectStringRefs[cpIdx];
            int indirIdx = (subFieldIdx == 0 ? compoundIndirIdx >> 16 : compoundIndirIdx) & 0xFFFF;
            if (indirIdx == 0 || indirIdx == -1) {
                throw new RuntimeException("Bad string indirection index, cannot continue reading class. Please report this at https://github.com/lukehutch/fast-classpath-scanner/issues");
            }
            cpIdxToUse = indirIdx;
        } else {
            throw new RuntimeException("Wrong tag number " + t + " at constant pool index " + cpIdx + ", cannot continue reading class. Please report this at https://github.com/lukehutch/fast-classpath-scanner/issues");
        }
        return this.offset[cpIdxToUse];
    }

    private String getConstantPoolString(int cpIdx, boolean replaceSlashWithDot, boolean stripLSemicolon) {
        int constantPoolStringOffset = this.getConstantPoolStringOffset(cpIdx, 0);
        return constantPoolStringOffset == 0 ? null : this.readString(constantPoolStringOffset, replaceSlashWithDot, stripLSemicolon);
    }

    private String getConstantPoolString(int cpIdx, int subFieldIdx) {
        int constantPoolStringOffset = this.getConstantPoolStringOffset(cpIdx, subFieldIdx);
        return constantPoolStringOffset == 0 ? null : this.readString(constantPoolStringOffset, false, false);
    }

    private String getConstantPoolString(int cpIdx) {
        return this.getConstantPoolString(cpIdx, 0);
    }

    private byte getConstantPoolStringFirstByte(int cpIdx) {
        int constantPoolStringOffset = this.getConstantPoolStringOffset(cpIdx, 0);
        if (constantPoolStringOffset == 0) {
            return 0;
        }
        int utfLen = this.readUnsignedShort(constantPoolStringOffset);
        if (utfLen == 0) {
            return 0;
        }
        return this.buf[constantPoolStringOffset + 2];
    }

    private String getConstantPoolClassName(int CpIdx) {
        return this.getConstantPoolString(CpIdx, true, false);
    }

    private String getConstantPoolClassDescriptor(int CpIdx) {
        return this.getConstantPoolString(CpIdx, true, true);
    }

    private boolean constantPoolStringEquals(int cpIdx, String otherString) {
        int otherLen;
        int strOffset = this.getConstantPoolStringOffset(cpIdx, 0);
        if (strOffset == 0) {
            return otherString == null;
        }
        int strLen = this.readUnsignedShort(strOffset);
        if (strLen != (otherLen = otherString.length())) {
            return false;
        }
        int strStart = strOffset + 2;
        for (int i = 0; i < strLen; ++i) {
            if ((char)(this.buf[strStart + i] & 0xFF) == otherString.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private Object getConstantPoolValue(int tag, char fieldTypeDescriptorFirstChar, int cpIdx) throws IOException {
        switch (tag) {
            case 1: 
            case 7: 
            case 8: {
                return this.getConstantPoolString(cpIdx, 0);
            }
            case 3: {
                int intVal = this.readInt(this.offset[cpIdx]);
                switch (fieldTypeDescriptorFirstChar) {
                    case 'I': {
                        return new Integer(intVal);
                    }
                    case 'S': {
                        return new Short((short)intVal);
                    }
                    case 'C': {
                        return new Character((char)intVal);
                    }
                    case 'B': {
                        return new Byte((byte)intVal);
                    }
                    case 'Z': {
                        return new Boolean(intVal != 0);
                    }
                }
                throw new RuntimeException("Unknown Constant_INTEGER type " + fieldTypeDescriptorFirstChar + ", cannot continue reading class. Please report this at https://github.com/lukehutch/fast-classpath-scanner/issues");
            }
            case 4: {
                return new Float(Float.intBitsToFloat(this.readInt(this.offset[cpIdx])));
            }
            case 5: {
                return new Long(this.readLong(this.offset[cpIdx]));
            }
            case 6: {
                return new Double(Double.longBitsToDouble(this.readLong(this.offset[cpIdx])));
            }
        }
        throw new RuntimeException("Unknown constant pool tag " + tag + ", cannot continue reading class. Please report this at https://github.com/lukehutch/fast-classpath-scanner/issues");
    }

    private AnnotationInfo readAnnotation() throws IOException, InterruptedException {
        String annotationClassName = this.getConstantPoolClassDescriptor(this.readUnsignedShort());
        int numElementValuePairs = this.readUnsignedShort();
        ArrayList<AnnotationInfo.AnnotationParamValue> paramVals = null;
        if (numElementValuePairs > 0) {
            paramVals = new ArrayList<AnnotationInfo.AnnotationParamValue>();
        }
        for (int i = 0; i < numElementValuePairs; ++i) {
            String paramName = this.getConstantPoolString(this.readUnsignedShort());
            Object paramValue = this.readAnnotationElementValue();
            paramVals.add(new AnnotationInfo.AnnotationParamValue(paramName, paramValue));
        }
        return new AnnotationInfo(annotationClassName, paramVals);
    }

    private Object readAnnotationElementValue() throws IOException, InterruptedException {
        char tag = (char)this.readUnsignedByte();
        switch (tag) {
            case 'B': {
                return new Byte((byte)this.readInt(this.offset[this.readUnsignedShort()]));
            }
            case 'C': {
                return new Character((char)this.readInt(this.offset[this.readUnsignedShort()]));
            }
            case 'D': {
                return new Double(Double.longBitsToDouble(this.readLong(this.offset[this.readUnsignedShort()])));
            }
            case 'F': {
                return new Float(Float.intBitsToFloat(this.readInt(this.offset[this.readUnsignedShort()])));
            }
            case 'I': {
                return new Integer(this.readInt(this.offset[this.readUnsignedShort()]));
            }
            case 'J': {
                return new Long(this.readLong(this.offset[this.readUnsignedShort()]));
            }
            case 'S': {
                return new Short((short)this.readInt(this.offset[this.readUnsignedShort()]));
            }
            case 'Z': {
                return new Boolean(this.readInt(this.offset[this.readUnsignedShort()]) != 0);
            }
            case 's': {
                return this.getConstantPoolString(this.readUnsignedShort());
            }
            case 'e': {
                String className = this.getConstantPoolClassDescriptor(this.readUnsignedShort());
                String constName = this.getConstantPoolString(this.readUnsignedShort());
                return new AnnotationInfo.AnnotationEnumValue(className, constName);
            }
            case 'c': {
                String classRefTypeDescriptor = this.getConstantPoolString(this.readUnsignedShort());
                String classRefTypeStr = ReflectionUtils.parseSimpleTypeDescriptor(classRefTypeDescriptor);
                return new AnnotationInfo.AnnotationClassRef(classRefTypeStr);
            }
            case '@': {
                return this.readAnnotation();
            }
            case '[': {
                int count = this.readUnsignedShort();
                Object[] arr = new Object[count];
                for (int i = 0; i < count; ++i) {
                    arr[i] = this.readAnnotationElementValue();
                }
                return arr;
            }
        }
        throw new RuntimeException("Class " + this.className + " has unknown annotation element type tag '" + (char)tag + "': element size unknown, cannot continue reading class. Please report this at https://github.com/lukehutch/fast-classpath-scanner/issues");
    }

    private void addFieldTypeDescriptorParts(ClassInfoUnlinked classInfoUnlinked, String typeDescriptor) {
        for (int i = 0; i < typeDescriptor.length(); ++i) {
            char c = typeDescriptor.charAt(i);
            if (c != 'L') continue;
            int typeNameStart = ++i;
            while (i < typeDescriptor.length() && (c = typeDescriptor.charAt(i)) != '<' && c != ';') {
                ++i;
            }
            char[] typeNameChars = new char[i - typeNameStart];
            for (int j = typeNameStart; j < i; ++j) {
                char chr = typeDescriptor.charAt(j);
                typeNameChars[j - typeNameStart] = chr == '/' ? 46 : (int)chr;
            }
            String typeName = new String(typeNameChars);
            classInfoUnlinked.addFieldType(typeName);
        }
    }

    ClassInfoUnlinked readClassInfoFromClassfileHeader(ClasspathElement classpathElement, String relativePath, InputStream inputStream, ScanSpec scanSpec, ConcurrentHashMap<String, String> stringInternMap, LogNode log) throws IOException, InterruptedException {
        boolean isModule;
        int bytesRead;
        this.inputStream = inputStream;
        this.className = null;
        this.curr = 0;
        this.used = 0;
        while (this.used < 16384 && (bytesRead = inputStream.read(this.buf, this.used, 16384 - this.used)) != -1) {
            this.used += bytesRead;
        }
        if (this.used == 0) {
            throw new IOException("Classfile " + relativePath + " is empty");
        }
        if (this.readInt() != -889275714) {
            throw new IOException("Classfile " + relativePath + " does not have correct classfile magic number");
        }
        this.readUnsignedShort();
        this.readUnsignedShort();
        int cpCount = this.readUnsignedShort();
        if (this.offset == null || this.offset.length < cpCount) {
            this.offset = new int[cpCount];
            this.tag = new int[cpCount];
            this.indirectStringRefs = new int[cpCount];
        }
        Arrays.fill(this.indirectStringRefs, 0, cpCount, -1);
        block14: for (int i = 1; i < cpCount; ++i) {
            this.tag[i] = this.readUnsignedByte();
            this.offset[i] = this.curr;
            switch (this.tag[i]) {
                case 1: {
                    int strLen = this.readUnsignedShort();
                    this.skip(strLen);
                    continue block14;
                }
                case 3: 
                case 4: {
                    this.skip(4);
                    continue block14;
                }
                case 5: 
                case 6: {
                    this.skip(8);
                    ++i;
                    continue block14;
                }
                case 7: 
                case 8: {
                    this.indirectStringRefs[i] = this.readUnsignedShort();
                    continue block14;
                }
                case 9: 
                case 10: 
                case 11: {
                    this.skip(4);
                    continue block14;
                }
                case 12: {
                    int nameRef = this.readUnsignedShort();
                    int typeRef = this.readUnsignedShort();
                    this.indirectStringRefs[i] = nameRef << 16 | typeRef;
                    continue block14;
                }
                case 15: {
                    this.skip(3);
                    continue block14;
                }
                case 16: {
                    this.skip(2);
                    continue block14;
                }
                case 18: {
                    this.skip(4);
                    continue block14;
                }
                case 19: {
                    this.skip(2);
                    continue block14;
                }
                case 20: {
                    this.skip(2);
                    continue block14;
                }
                default: {
                    throw new RuntimeException("Unknown constant pool tag " + this.tag[i] + " in classfile " + relativePath + " (element size unknown, cannot continue reading class. Please report this on the FastClasspathScanner GitHub page.");
                }
            }
        }
        int classModifierFlags = this.readUnsignedShort();
        boolean isInterface = (classModifierFlags & 0x200) != 0;
        boolean isAnnotation = (classModifierFlags & 0x2000) != 0;
        boolean bl = isModule = (classModifierFlags & 0x8000) != 0;
        if (isModule) {
            return null;
        }
        String classNamePath = this.getConstantPoolString(this.readUnsignedShort());
        String className = classNamePath.replace('/', '.');
        if ("java.lang.Object".equals(className)) {
            return null;
        }
        if (!relativePath.endsWith(".class")) {
            if (log != null) {
                log.log("File " + relativePath + " does not end in \".class\"");
            }
            return null;
        }
        int len = classNamePath.length();
        if (relativePath.length() != len + 6 || !classNamePath.regionMatches(0, relativePath, 0, len)) {
            if (log != null) {
                log.log("Class " + className + " is at incorrect relative path " + relativePath + " -- ignoring");
            }
            return null;
        }
        String superclassName = this.getConstantPoolClassName(this.readUnsignedShort());
        ClassInfoUnlinked classInfoUnlinked = new ClassInfoUnlinked(className, classModifierFlags, isInterface, isAnnotation, stringInternMap, classpathElement);
        classInfoUnlinked.addSuperclass(superclassName);
        int interfaceCount = this.readUnsignedShort();
        for (int i = 0; i < interfaceCount; ++i) {
            String interfaceName = this.getConstantPoolClassName(this.readUnsignedShort());
            classInfoUnlinked.addImplementedInterface(interfaceName);
        }
        MultiMapKeyToSet<String, String> classNameToStaticFinalFieldsToMatch = scanSpec.getClassNameToStaticFinalFieldsToMatch();
        Set<String> staticFinalFieldsToMatch = classNameToStaticFinalFieldsToMatch == null ? null : classNameToStaticFinalFieldsToMatch.get(className);
        boolean matchStaticFinalFields = staticFinalFieldsToMatch != null;
        int fieldCount = this.readUnsignedShort();
        for (int i = 0; i < fieldCount; ++i) {
            boolean matchThisStaticFinalField;
            int fieldModifierFlags = this.readUnsignedShort();
            boolean isPublicField = (fieldModifierFlags & 1) == 1;
            boolean isStaticFinalField = (fieldModifierFlags & 0x18) == 24;
            boolean fieldIsVisible = isPublicField || scanSpec.ignoreFieldVisibility;
            boolean bl2 = matchThisStaticFinalField = matchStaticFinalFields && isStaticFinalField && fieldIsVisible;
            if (!(fieldIsVisible && (scanSpec.enableFieldInfo || scanSpec.enableFieldTypeIndexing || matchThisStaticFinalField || scanSpec.enableFieldAnnotationIndexing))) {
                this.readUnsignedShort();
                this.readUnsignedShort();
                int attributesCount = this.readUnsignedShort();
                for (int j = 0; j < attributesCount; ++j) {
                    this.readUnsignedShort();
                    int attributeLength = this.readInt();
                    this.skip(attributeLength);
                }
                continue;
            }
            int fieldNameCpIdx = this.readUnsignedShort();
            String fieldName = null;
            boolean isMatchedFieldName = false;
            if (matchThisStaticFinalField || scanSpec.enableFieldInfo) {
                fieldName = this.getConstantPoolString(fieldNameCpIdx);
                if (matchThisStaticFinalField && staticFinalFieldsToMatch.contains(fieldName)) {
                    isMatchedFieldName = true;
                }
            }
            int fieldTypeDescriptorCpIdx = this.readUnsignedShort();
            char fieldTypeDescriptorFirstChar = (char)this.getConstantPoolStringFirstByte(fieldTypeDescriptorCpIdx);
            String fieldTypeDescriptor = null;
            if (scanSpec.enableFieldInfo) {
                fieldTypeDescriptor = this.getConstantPoolString(fieldTypeDescriptorCpIdx);
            }
            if (scanSpec.enableFieldTypeIndexing && fieldIsVisible) {
                this.addFieldTypeDescriptorParts(classInfoUnlinked, this.getConstantPoolString(fieldTypeDescriptorCpIdx));
            }
            Object fieldConstValue = null;
            boolean foundFieldConstValue = false;
            ArrayList<AnnotationInfo> fieldAnnotationInfo = null;
            if (scanSpec.enableFieldInfo && fieldIsVisible) {
                fieldAnnotationInfo = new ArrayList<AnnotationInfo>(1);
            }
            int attributesCount = this.readUnsignedShort();
            for (int j = 0; j < attributesCount; ++j) {
                int attributeNameCpIdx = this.readUnsignedShort();
                int attributeLength = this.readInt();
                if ((isMatchedFieldName || scanSpec.enableFieldInfo) && this.constantPoolStringEquals(attributeNameCpIdx, "ConstantValue")) {
                    int cpIdx = this.readUnsignedShort();
                    fieldConstValue = this.getConstantPoolValue(this.tag[cpIdx], fieldTypeDescriptorFirstChar, cpIdx);
                    if (isMatchedFieldName) {
                        classInfoUnlinked.addFieldConstantValue(fieldName, fieldConstValue);
                    }
                    foundFieldConstValue = true;
                } else if ((scanSpec.enableFieldTypeIndexing || scanSpec.enableFieldInfo) && fieldIsVisible && this.constantPoolStringEquals(attributeNameCpIdx, "Signature")) {
                    String fieldTypeSignature;
                    fieldTypeDescriptor = fieldTypeSignature = this.getConstantPoolString(this.readUnsignedShort());
                    if (scanSpec.enableFieldTypeIndexing) {
                        this.addFieldTypeDescriptorParts(classInfoUnlinked, fieldTypeSignature);
                    }
                } else if ((scanSpec.enableFieldInfo || scanSpec.enableFieldAnnotationIndexing) && (this.constantPoolStringEquals(attributeNameCpIdx, "RuntimeVisibleAnnotations") || scanSpec.annotationVisibility == RetentionPolicy.CLASS && this.constantPoolStringEquals(attributeNameCpIdx, "RuntimeInvisibleAnnotations"))) {
                    int annotationCount = this.readUnsignedShort();
                    for (int k = 0; k < annotationCount; ++k) {
                        AnnotationInfo fieldAnnotation = this.readAnnotation();
                        if (scanSpec.enableFieldAnnotationIndexing) {
                            classInfoUnlinked.addFieldAnnotation(fieldAnnotation);
                        }
                        if (fieldAnnotationInfo == null) continue;
                        fieldAnnotationInfo.add(fieldAnnotation);
                    }
                } else {
                    this.skip(attributeLength);
                }
                if (!isMatchedFieldName || foundFieldConstValue || log == null) continue;
                boolean reasonFound = false;
                if (!isStaticFinalField) {
                    log.log("Requested static final field match " + classInfoUnlinked.className + "." + this.getConstantPoolString(fieldNameCpIdx) + " is not declared as static final");
                    reasonFound = true;
                }
                if (!isPublicField && !scanSpec.ignoreFieldVisibility) {
                    log.log("Requested static final field match " + classInfoUnlinked.className + "." + this.getConstantPoolString(fieldNameCpIdx) + " is not declared as public, and ignoreFieldVisibility was not set to true before scan");
                    reasonFound = true;
                }
                if (reasonFound) continue;
                log.log("Requested static final field match " + classInfoUnlinked.className + "." + this.getConstantPoolString(fieldNameCpIdx) + " does not have a constant literal initializer value");
            }
            if (!scanSpec.enableFieldInfo || !fieldIsVisible) continue;
            classInfoUnlinked.addFieldInfo(new FieldInfo(className, fieldName, fieldModifierFlags, fieldTypeDescriptor, fieldConstValue, fieldAnnotationInfo));
        }
        int methodCount = this.readUnsignedShort();
        for (int i = 0; i < methodCount; ++i) {
            int j;
            int methodModifierFlags = this.readUnsignedShort();
            boolean isPublicMethod = (methodModifierFlags & 1) == 1;
            boolean methodIsVisible = isPublicMethod || scanSpec.ignoreMethodVisibility;
            String methodName = null;
            String methodTypeDescriptor = null;
            if (scanSpec.enableMethodInfo || isAnnotation) {
                int methodNameCpIdx = this.readUnsignedShort();
                methodName = this.getConstantPoolString(methodNameCpIdx);
                int methodTypeDescriptorCpIdx = this.readUnsignedShort();
                methodTypeDescriptor = this.getConstantPoolString(methodTypeDescriptorCpIdx);
            } else {
                this.skip(4);
            }
            int attributesCount = this.readUnsignedShort();
            String[] methodParameterNames = null;
            int[] methodParameterAccessFlags = null;
            AnnotationInfo[][] methodParameterAnnotations = null;
            ArrayList<AnnotationInfo.AnnotationParamValue> annotationParamDefaultValues = null;
            ArrayList<AnnotationInfo> methodAnnotationInfo = null;
            if (scanSpec.enableMethodInfo && methodIsVisible) {
                methodAnnotationInfo = new ArrayList<AnnotationInfo>(1);
            }
            if (!methodIsVisible || !scanSpec.enableMethodInfo && !isAnnotation && !scanSpec.enableMethodAnnotationIndexing) {
                for (j = 0; j < attributesCount; ++j) {
                    this.skip(2);
                    int attributeLength = this.readInt();
                    this.skip(attributeLength);
                }
            } else {
                for (j = 0; j < attributesCount; ++j) {
                    int k;
                    int attributeNameCpIdx = this.readUnsignedShort();
                    int attributeLength = this.readInt();
                    if (this.constantPoolStringEquals(attributeNameCpIdx, "RuntimeVisibleAnnotations") || scanSpec.annotationVisibility == RetentionPolicy.CLASS && this.constantPoolStringEquals(attributeNameCpIdx, "RuntimeInvisibleAnnotations")) {
                        int annotationCount = this.readUnsignedShort();
                        for (k = 0; k < annotationCount; ++k) {
                            AnnotationInfo annotationInfo = this.readAnnotation();
                            if (scanSpec.enableMethodAnnotationIndexing) {
                                classInfoUnlinked.addMethodAnnotation(annotationInfo);
                            }
                            if (methodAnnotationInfo == null) continue;
                            methodAnnotationInfo.add(annotationInfo);
                        }
                        continue;
                    }
                    if (this.constantPoolStringEquals(attributeNameCpIdx, "RuntimeVisibleParameterAnnotations") || scanSpec.annotationVisibility == RetentionPolicy.CLASS && this.constantPoolStringEquals(attributeNameCpIdx, "RuntimeInvisibleParameterAnnotations")) {
                        int paramCount = this.readUnsignedByte();
                        methodParameterAnnotations = new AnnotationInfo[paramCount][];
                        for (k = 0; k < paramCount; ++k) {
                            int numAnnotations = this.readUnsignedShort();
                            methodParameterAnnotations[k] = new AnnotationInfo[numAnnotations];
                            for (int l = 0; l < numAnnotations; ++l) {
                                methodParameterAnnotations[k][l] = this.readAnnotation();
                            }
                        }
                        continue;
                    }
                    if (this.constantPoolStringEquals(attributeNameCpIdx, "MethodParameters")) {
                        int paramCount = this.readUnsignedByte();
                        methodParameterNames = new String[paramCount];
                        methodParameterAccessFlags = new int[paramCount];
                        for (k = 0; k < paramCount; ++k) {
                            int cpIdx = this.readUnsignedShort();
                            methodParameterNames[k] = cpIdx == 0 ? null : this.getConstantPoolString(cpIdx);
                            methodParameterAccessFlags[k] = this.readUnsignedShort();
                        }
                        continue;
                    }
                    if (this.constantPoolStringEquals(attributeNameCpIdx, "Signature")) {
                        String methodTypeSignature;
                        methodTypeDescriptor = methodTypeSignature = this.getConstantPoolString(this.readUnsignedShort());
                        continue;
                    }
                    if (this.constantPoolStringEquals(attributeNameCpIdx, "AnnotationDefault")) {
                        if (annotationParamDefaultValues == null) {
                            annotationParamDefaultValues = new ArrayList<AnnotationInfo.AnnotationParamValue>();
                        }
                        Object annotationParamDefaultValue = this.readAnnotationElementValue();
                        annotationParamDefaultValues.add(new AnnotationInfo.AnnotationParamValue(methodName, annotationParamDefaultValue));
                        continue;
                    }
                    this.skip(attributeLength);
                }
            }
            if (!methodIsVisible) continue;
            if (isAnnotation && annotationParamDefaultValues != null) {
                classInfoUnlinked.addAnnotationParamDefaultValues(annotationParamDefaultValues);
            }
            if (!scanSpec.enableMethodInfo) continue;
            classInfoUnlinked.addMethodInfo(new MethodInfo(className, methodName, methodModifierFlags, methodTypeDescriptor, methodParameterNames, methodParameterAccessFlags, methodAnnotationInfo, methodParameterAnnotations));
        }
        int attributesCount = this.readUnsignedShort();
        for (int i = 0; i < attributesCount; ++i) {
            int attributeNameCpIdx = this.readUnsignedShort();
            int attributeLength = this.readInt();
            if (this.constantPoolStringEquals(attributeNameCpIdx, "RuntimeVisibleAnnotations") || scanSpec.annotationVisibility == RetentionPolicy.CLASS && this.constantPoolStringEquals(attributeNameCpIdx, "RuntimeInvisibleAnnotations")) {
                int annotationCount = this.readUnsignedShort();
                for (int m = 0; m < annotationCount; ++m) {
                    AnnotationInfo classAnnotation = this.readAnnotation();
                    classInfoUnlinked.addClassAnnotation(classAnnotation);
                }
                continue;
            }
            if (this.constantPoolStringEquals(attributeNameCpIdx, "InnerClasses")) {
                int numInnerClasses = this.readUnsignedShort();
                for (int j = 0; j < numInnerClasses; ++j) {
                    int innerClassInfoCpIdx = this.readUnsignedShort();
                    int outerClassInfoCpIdx = this.readUnsignedShort();
                    if (innerClassInfoCpIdx != 0 && outerClassInfoCpIdx != 0) {
                        classInfoUnlinked.addClassContainment(this.getConstantPoolClassName(innerClassInfoCpIdx), this.getConstantPoolClassName(outerClassInfoCpIdx));
                    }
                    this.skip(2);
                    this.skip(2);
                }
                continue;
            }
            if (this.constantPoolStringEquals(attributeNameCpIdx, "EnclosingMethod")) {
                String innermostEnclosingClassName = this.getConstantPoolClassName(this.readUnsignedShort());
                int enclosingMethodCpIdx = this.readUnsignedShort();
                String enclosingMethodName = enclosingMethodCpIdx == 0 ? "<clinit>" : this.getConstantPoolString(enclosingMethodCpIdx, 0);
                classInfoUnlinked.addClassContainment(className, innermostEnclosingClassName);
                classInfoUnlinked.addEnclosingMethod(innermostEnclosingClassName + "." + enclosingMethodName);
                continue;
            }
            this.skip(attributeLength);
        }
        return classInfoUnlinked;
    }
}

