/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.classloaderhandler;

import io.github.lukehutch.fastclasspathscanner.classloaderhandler.ClassLoaderHandler;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathFinder;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import io.github.lukehutch.fastclasspathscanner.utils.ReflectionUtils;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class FelixClassLoaderHandler
implements ClassLoaderHandler {
    public static final String[] HANDLED_CLASSLOADERS = new String[]{"org.apache.felix.framework.BundleWiringImpl$BundleClassLoaderJava5", "org.apache.felix.framework.BundleWiringImpl$BundleClassLoader"};
    final Set<Object> bundles = new HashSet<Object>();

    @Override
    public ClassLoaderHandler.DelegationOrder getDelegationOrder(ClassLoader classLoaderInstance) {
        return ClassLoaderHandler.DelegationOrder.PARENT_FIRST;
    }

    @Override
    public void handle(ClassLoader classLoader, ClasspathFinder classpathFinder, ScanSpec scanSpec, LogNode log) throws Exception {
        Object bundleWiring = ReflectionUtils.getFieldVal(classLoader, "m_wiring");
        this.addBundle(bundleWiring, classLoader, classpathFinder, log);
        List requiredWires = (List)ReflectionUtils.invokeMethod(bundleWiring, "getRequiredWires", String.class, null);
        if (requiredWires != null) {
            for (Object wire : requiredWires) {
                Object provider = ReflectionUtils.invokeMethod(wire, "getProviderWiring");
                if (this.bundles.contains(provider)) continue;
                this.addBundle(provider, classLoader, classpathFinder, log);
            }
        }
    }

    private void addBundle(Object bundleWiring, ClassLoader classLoader, ClasspathFinder classpathFinder, LogNode log) throws Exception {
        String location;
        this.bundles.add(bundleWiring);
        Object revision = ReflectionUtils.invokeMethod(bundleWiring, "getRevision");
        Object content = ReflectionUtils.invokeMethod(revision, "getContent");
        String string = location = content != null ? this.getContentLocation(content) : null;
        if (location != null) {
            classpathFinder.addClasspathElement(location, classLoader, log);
            List embeddedContent = (List)ReflectionUtils.invokeMethod(revision, "getContentPath");
            if (embeddedContent != null) {
                for (Object embedded : embeddedContent) {
                    String embeddedLocation;
                    if (embedded == content || (embeddedLocation = embedded != null ? this.getContentLocation(embedded) : null) == null) continue;
                    classpathFinder.addClasspathElement(embeddedLocation, classLoader, log);
                }
            }
        }
    }

    private String getContentLocation(Object content) throws Exception {
        File file = (File)ReflectionUtils.invokeMethod(content, "getFile");
        return file != null ? file.toURI().toString() : null;
    }
}

