/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.scanner.ClassGraphBuilder;
import io.github.lukehutch.fastclasspathscanner.scanner.ClassInfo;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathElement;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import io.github.lukehutch.fastclasspathscanner.utils.InterruptionChecker;
import io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import io.github.lukehutch.fastclasspathscanner.utils.NestedJarHandler;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ScanResult {
    private final ScanSpec scanSpec;
    final List<ClasspathElement> classpathOrder;
    private final List<File> classpathElementOrderFiles;
    private final List<URL> classpathElementOrderURLs;
    private final NestedJarHandler nestedJarHandler;
    private final Map<File, Long> fileToLastModified;
    final ClassGraphBuilder classGraphBuilder;
    private final List<Throwable> matchProcessorExceptions = new ArrayList<Throwable>();
    final InterruptionChecker interruptionChecker;
    final LogNode log;

    ScanResult(ScanSpec scanSpec, List<ClasspathElement> classpathOrder, ClassGraphBuilder classGraphBuilder, Map<File, Long> fileToLastModified, NestedJarHandler nestedJarHandler, InterruptionChecker interruptionChecker, LogNode log) {
        this.scanSpec = scanSpec;
        this.classpathOrder = classpathOrder;
        this.classpathElementOrderFiles = new ArrayList<File>();
        this.classpathElementOrderURLs = new ArrayList<URL>();
        for (ClasspathElement classpathElement : classpathOrder) {
            this.classpathElementOrderFiles.add(classpathElement.getClasspathElementFile());
            this.classpathElementOrderURLs.add(classpathElement.getClasspathElementURL());
        }
        this.fileToLastModified = fileToLastModified;
        this.classGraphBuilder = classGraphBuilder;
        this.nestedJarHandler = nestedJarHandler;
        this.interruptionChecker = interruptionChecker;
        this.log = log;
    }

    public List<ClassLoader> getClassLoadersForClass(String className) {
        List<ClassLoader> classLoaders = this.classGraphBuilder.getClassNameToClassLoaders().get(className);
        if (classLoaders != null) {
            return classLoaders;
        }
        return this.scanSpec.contextClassLoaders;
    }

    void addMatchProcessorException(Throwable e) {
        this.matchProcessorExceptions.add(e);
    }

    public List<Throwable> getMatchProcessorExceptions() {
        return this.matchProcessorExceptions;
    }

    public List<File> getUniqueClasspathElements() {
        return this.classpathElementOrderFiles;
    }

    public String getUniqueClasspathElementsAsPathStr() {
        StringBuilder buf = new StringBuilder();
        for (File f : this.getUniqueClasspathElements()) {
            if (buf.length() > 0) {
                buf.append(File.pathSeparatorChar);
            }
            buf.append(f.toString());
        }
        return buf.toString();
    }

    public boolean classpathContentsModifiedSinceScan() {
        if (this.fileToLastModified == null) {
            return true;
        }
        for (Map.Entry<File, Long> ent : this.fileToLastModified.entrySet()) {
            if (ent.getKey().lastModified() == ent.getValue().longValue()) continue;
            return true;
        }
        return false;
    }

    public long classpathContentsLastModifiedTime() {
        long maxLastModifiedTime = 0L;
        if (this.fileToLastModified != null) {
            long currTime = System.currentTimeMillis();
            for (long timestamp : this.fileToLastModified.values()) {
                if (timestamp <= maxLastModifiedTime || timestamp >= currTime) continue;
                maxLastModifiedTime = timestamp;
            }
        }
        return maxLastModifiedTime;
    }

    public Map<String, ClassInfo> getClassNameToClassInfo() {
        return this.classGraphBuilder.getClassNameToClassInfo();
    }

    public List<String> getNamesOfAllClasses() {
        return this.classGraphBuilder.getNamesOfAllClasses();
    }

    public List<String> getNamesOfAllStandardClasses() {
        return this.classGraphBuilder.getNamesOfAllStandardClasses();
    }

    public List<String> getNamesOfSubclassesOf(String superclassName) {
        this.scanSpec.checkClassIsNotBlacklisted(superclassName);
        return this.classGraphBuilder.getNamesOfSubclassesOf(superclassName);
    }

    public List<String> getNamesOfSubclassesOf(Class<?> superclass) {
        return this.classGraphBuilder.getNamesOfSubclassesOf(this.scanSpec.getStandardClassName(superclass));
    }

    public List<String> getNamesOfSuperclassesOf(String subclassName) {
        this.scanSpec.checkClassIsNotBlacklisted(subclassName);
        return this.classGraphBuilder.getNamesOfSuperclassesOf(subclassName);
    }

    public List<String> getNamesOfSuperclassesOf(Class<?> subclass) {
        return this.getNamesOfSuperclassesOf(this.scanSpec.getStandardClassName(subclass));
    }

    public List<String> getNamesOfClassesWithFieldOfType(String fieldTypeName) {
        this.scanSpec.checkClassIsNotBlacklisted(fieldTypeName);
        if (!this.scanSpec.enableFieldTypeIndexing) {
            throw new IllegalArgumentException("Please call FastClasspathScanner#enableFieldTypeIndexing() before calling scan() -- field type indexing is disabled by default for efficiency");
        }
        return this.classGraphBuilder.getNamesOfClassesWithFieldOfType(fieldTypeName);
    }

    public List<String> getNamesOfClassesWithFieldOfType(Class<?> fieldType) {
        String fieldTypeName = fieldType.getName();
        return this.getNamesOfClassesWithFieldOfType(fieldTypeName);
    }

    public List<String> getNamesOfClassesWithMethodAnnotation(String annotationName) {
        this.scanSpec.checkClassIsNotBlacklisted(annotationName);
        if (!this.scanSpec.enableMethodAnnotationIndexing) {
            throw new IllegalArgumentException("Please call FastClasspathScanner#enableMethodAnnotationIndexing() before calling scan() -- method annotation indexing is disabled by default for efficiency");
        }
        return this.classGraphBuilder.getNamesOfClassesWithMethodAnnotation(annotationName);
    }

    public List<String> getNamesOfClassesWithMethodAnnotation(Class<?> annotation) {
        return this.getNamesOfClassesWithMethodAnnotation(this.scanSpec.getAnnotationName(annotation));
    }

    public List<String> getNamesOfClassesWithFieldAnnotation(String annotationName) {
        this.scanSpec.checkClassIsNotBlacklisted(annotationName);
        if (!this.scanSpec.enableFieldAnnotationIndexing) {
            throw new IllegalArgumentException("Please call FastClasspathScanner#enableFieldAnnotationIndexing() before calling scan() -- field annotation indexing is disabled by default for efficiency");
        }
        return this.classGraphBuilder.getNamesOfClassesWithFieldAnnotation(annotationName);
    }

    public List<String> getNamesOfClassesWithFieldAnnotation(Class<?> annotation) {
        return this.getNamesOfClassesWithFieldAnnotation(this.scanSpec.getAnnotationName(annotation));
    }

    public List<String> getNamesOfAllInterfaceClasses() {
        return this.classGraphBuilder.getNamesOfAllInterfaceClasses();
    }

    public List<String> getNamesOfSubinterfacesOf(String interfaceName) {
        this.scanSpec.checkClassIsNotBlacklisted(interfaceName);
        return this.classGraphBuilder.getNamesOfSubinterfacesOf(interfaceName);
    }

    public List<String> getNamesOfSubinterfacesOf(Class<?> superInterface) {
        return this.getNamesOfSubinterfacesOf(this.scanSpec.getInterfaceName(superInterface));
    }

    public List<String> getNamesOfSuperinterfacesOf(String subInterfaceName) {
        this.scanSpec.checkClassIsNotBlacklisted(subInterfaceName);
        return this.classGraphBuilder.getNamesOfSuperinterfacesOf(subInterfaceName);
    }

    public List<String> getNamesOfSuperinterfacesOf(Class<?> subInterface) {
        return this.getNamesOfSuperinterfacesOf(this.scanSpec.getInterfaceName(subInterface));
    }

    public List<String> getNamesOfClassesImplementing(String interfaceName) {
        this.scanSpec.checkClassIsNotBlacklisted(interfaceName);
        return this.classGraphBuilder.getNamesOfClassesImplementing(interfaceName);
    }

    public List<String> getNamesOfClassesImplementing(Class<?> implementedInterface) {
        return this.getNamesOfClassesImplementing(this.scanSpec.getInterfaceName(implementedInterface));
    }

    public List<String> getNamesOfClassesImplementingAllOf(String ... implementedInterfaceNames) {
        HashSet<String> classNames = new HashSet<String>();
        for (int i = 0; i < implementedInterfaceNames.length; ++i) {
            String implementedInterfaceName = implementedInterfaceNames[i];
            List<String> namesOfImplementingClasses = this.getNamesOfClassesImplementing(implementedInterfaceName);
            if (i == 0) {
                classNames.addAll(namesOfImplementingClasses);
                continue;
            }
            classNames.retainAll(namesOfImplementingClasses);
        }
        return new ArrayList<String>(classNames);
    }

    public List<String> getNamesOfClassesImplementingAllOf(Class<?> ... implementedInterfaces) {
        return this.getNamesOfClassesImplementingAllOf(this.scanSpec.getInterfaceNames(implementedInterfaces));
    }

    public List<String> getNamesOfAllAnnotationClasses() {
        return this.classGraphBuilder.getNamesOfAllAnnotationClasses();
    }

    public List<String> getNamesOfClassesWithAnnotation(String annotationName) {
        this.scanSpec.checkClassIsNotBlacklisted(annotationName);
        return this.classGraphBuilder.getNamesOfClassesWithAnnotation(annotationName);
    }

    public List<String> getNamesOfClassesWithAnnotation(Class<?> annotation) {
        return this.getNamesOfClassesWithAnnotation(this.scanSpec.getAnnotationName(annotation));
    }

    public List<String> getNamesOfClassesWithAnnotationsAllOf(String ... annotationNames) {
        HashSet<String> classNames = new HashSet<String>();
        for (int i = 0; i < annotationNames.length; ++i) {
            String annotationName = annotationNames[i];
            List<String> namesOfClassesWithMetaAnnotation = this.getNamesOfClassesWithAnnotation(annotationName);
            if (i == 0) {
                classNames.addAll(namesOfClassesWithMetaAnnotation);
                continue;
            }
            classNames.retainAll(namesOfClassesWithMetaAnnotation);
        }
        return new ArrayList<String>(classNames);
    }

    public List<String> getNamesOfClassesWithAnnotationsAllOf(Class<?> ... annotations) {
        return this.getNamesOfClassesWithAnnotationsAllOf(this.scanSpec.getAnnotationNames(annotations));
    }

    public List<String> getNamesOfClassesWithAnnotationsAnyOf(String ... annotationNames) {
        HashSet<String> classNames = new HashSet<String>();
        for (String annotationName : annotationNames) {
            classNames.addAll(this.getNamesOfClassesWithAnnotation(annotationName));
        }
        return new ArrayList<String>(classNames);
    }

    public List<String> getNamesOfClassesWithAnnotationsAnyOf(Class<?> ... annotations) {
        return this.getNamesOfClassesWithAnnotationsAnyOf(this.scanSpec.getAnnotationNames(annotations));
    }

    public List<String> getNamesOfAnnotationsOnClass(String className) {
        this.scanSpec.checkClassIsNotBlacklisted(className);
        return this.classGraphBuilder.getNamesOfAnnotationsOnClass(className);
    }

    public List<String> getNamesOfAnnotationsOnClass(Class<?> klass) {
        return this.getNamesOfAnnotationsOnClass(this.scanSpec.getClassOrInterfaceName(klass));
    }

    public List<String> getNamesOfAnnotationsWithMetaAnnotation(String metaAnnotationName) {
        this.scanSpec.checkClassIsNotBlacklisted(metaAnnotationName);
        return this.classGraphBuilder.getNamesOfAnnotationsWithMetaAnnotation(metaAnnotationName);
    }

    public List<String> getNamesOfAnnotationsWithMetaAnnotation(Class<?> metaAnnotation) {
        return this.getNamesOfAnnotationsWithMetaAnnotation(this.scanSpec.getAnnotationName(metaAnnotation));
    }

    public String generateClassGraphDotFile(float sizeX, float sizeY) {
        return this.classGraphBuilder.generateClassGraphDotFile(sizeX, sizeY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Class<?>> classNamesToClassRefs(List<String> classNames, boolean ignoreExceptions) throws IllegalArgumentException {
        try {
            if (classNames.isEmpty()) {
                List<Class<?>> list = Collections.emptyList();
                return list;
            }
            ArrayList classRefs = new ArrayList();
            for (String className : classNames) {
                Class<?> classRef = this.classNameToClassRef(className);
                if (classRef == null) continue;
                classRefs.add(classRef);
            }
            List list = classRefs.isEmpty() ? Collections.emptyList() : classRefs;
            return list;
        }
        finally {
            if (this.log != null) {
                this.log.flush();
            }
        }
    }

    public List<Class<?>> classNamesToClassRefs(List<String> classNames) throws IllegalArgumentException {
        return this.classNamesToClassRefs(classNames, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Class<?> classNameToClassRef(String className, boolean ignoreExceptions) throws IllegalArgumentException {
        try {
            if (className == null || className.isEmpty()) {
                if (!ignoreExceptions) {
                    throw new IllegalArgumentException("Class names cannot be null or empty");
                }
                Class<?> clazz = null;
                return clazz;
            }
            if (ignoreExceptions) {
                try {
                    Class<?> clazz = this.scanSpec.loadClass(className, this, this.log);
                    return clazz;
                }
                catch (IllegalArgumentException e) {
                    Class<?> clazz = null;
                    if (this.log != null) {
                        this.log.flush();
                    }
                    return clazz;
                }
            }
            Class<?> clazz = this.scanSpec.loadClass(className, this, this.log);
            return clazz;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (this.log != null) {
                this.log.flush();
            }
        }
    }

    public Class<?> classNameToClassRef(String className) throws IllegalArgumentException {
        return this.classNameToClassRef(className, false);
    }

    public void freeTempFiles() {
        this.nestedJarHandler.close();
    }
}

