/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.FastClasspathScanner;
import io.github.lukehutch.fastclasspathscanner.classloaderhandler.ClassLoaderHandler;
import io.github.lukehutch.fastclasspathscanner.classloaderhandler.ClassLoaderHandlerRegistry;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathRelativePath;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import io.github.lukehutch.fastclasspathscanner.utils.AdditionOrderedSet;
import io.github.lukehutch.fastclasspathscanner.utils.FileUtils;
import io.github.lukehutch.fastclasspathscanner.utils.JarUtils;
import io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import io.github.lukehutch.fastclasspathscanner.utils.NestedJarHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ClasspathFinder {
    private final NestedJarHandler nestedJarHandler;
    private static String currDirPathStr = FileUtils.getCurrDirPathStr();
    private final List<ClasspathRelativePath> rawClasspathElements = new ArrayList<ClasspathRelativePath>();
    private final Set<ClasspathRelativePath> rawClasspathElementsSet = new HashSet<ClasspathRelativePath>();
    private static CallerResolver CALLER_RESOLVER;

    private void addClasspathElement(ClasspathRelativePath classpathEltPath, LogNode log) {
        if (this.rawClasspathElementsSet.add(classpathEltPath)) {
            this.rawClasspathElements.add(classpathEltPath);
            if (log != null) {
                log.log("Found classpath element: " + classpathEltPath);
            }
        } else if (log != null) {
            log.log("Ignoring duplicate classpath element: " + classpathEltPath);
        }
    }

    public boolean addClasspathElement(String pathElement, ClassLoader classLoader, LogNode log) {
        if (pathElement == null || pathElement.isEmpty()) {
            return false;
        }
        this.addClasspathElement(new ClasspathRelativePath(currDirPathStr, pathElement, Arrays.asList(classLoader), this.nestedJarHandler), log);
        return true;
    }

    public boolean addClasspathElement(String pathElement, List<ClassLoader> classLoaders, LogNode log) {
        if (pathElement == null || pathElement.isEmpty()) {
            return false;
        }
        this.addClasspathElement(new ClasspathRelativePath(currDirPathStr, pathElement, classLoaders, this.nestedJarHandler), log);
        return true;
    }

    public boolean addClasspathElements(String pathStr, ClassLoader classLoader, LogNode log) {
        if (pathStr == null || pathStr.isEmpty()) {
            return false;
        }
        for (String pathElement : pathStr.split(File.pathSeparator)) {
            this.addClasspathElement(pathElement, classLoader, log);
        }
        return true;
    }

    public boolean addClasspathElements(String pathStr, List<ClassLoader> classLoaders, LogNode log) {
        if (pathStr == null || pathStr.isEmpty()) {
            return false;
        }
        for (String pathElement : pathStr.split(File.pathSeparator)) {
            this.addClasspathElement(pathElement, classLoaders, log);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    ClasspathFinder(ScanSpec scanSpec, NestedJarHandler nestedJarHandler, LogNode log) {
        AdditionOrderedSet allClassLoaders = new AdditionOrderedSet();
        for (ClassLoader classLoader : scanSpec.contextClassLoaders) {
            void var8_8;
            void var8_10;
            Iterator<Class<? extends ClassLoaderHandler>> parentClassLoaders = new ArrayList<void>();
            ClassLoader classLoader2 = classLoader;
            while (var8_10 != null) {
                ((ArrayList)((Object)parentClassLoaders)).add((Class<? extends ClassLoaderHandler>)var8_10);
                ClassLoader classLoader3 = var8_10.getParent();
            }
            int n = ((ArrayList)((Object)parentClassLoaders)).size() - 1;
            while (var8_8 >= 0) {
                allClassLoaders.add(((ArrayList)((Object)parentClassLoaders)).get((int)var8_8));
                --var8_8;
            }
        }
        List<ClassLoader> classLoaderOrder = allClassLoaders.getList();
        this.nestedJarHandler = nestedJarHandler;
        if (scanSpec.overrideClasspath != null) {
            if (scanSpec.overrideClassLoaders && log != null) {
                log.log("It is not possible to override both the classpath and the ClassLoaders -- ignoring the ClassLoader override");
            }
            LogNode overrideLog = log == null ? null : log.log("Overriding classpath");
            this.addClasspathElements(scanSpec.overrideClasspath, classLoaderOrder, overrideLog);
            if (overrideLog != null) {
                log.log("WARNING: when the classpath is overridden, there is no guarantee that the classes found by classpath scanning will be the same as the classes loaded by the context classloader");
            }
        } else {
            String rtJarPath;
            if (!scanSpec.blacklistSystemJars() && (rtJarPath = JarUtils.getRtJarPath()) != null) {
                this.addClasspathElement(rtJarPath, classLoaderOrder, log);
            }
            ArrayList<Object> classLoaderHandlers = new ArrayList<Object>();
            for (Class clazz : scanSpec.extraClassLoaderHandlers) {
                try {
                    classLoaderHandlers.add(clazz.newInstance());
                }
                catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                    if (log == null) continue;
                    log.log("Could not instantiate " + clazz.getName(), reflectiveOperationException);
                }
            }
            for (Class<? extends ClassLoaderHandler> clazz : ClassLoaderHandlerRegistry.DEFAULT_CLASS_LOADER_HANDLERS) {
                try {
                    classLoaderHandlers.add(clazz.newInstance());
                }
                catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                    if (log == null) continue;
                    log.log("Could not instantiate " + clazz.getName(), reflectiveOperationException);
                }
            }
            if (log != null) {
                LogNode classLoaderHandlerLog = log.log("ClassLoaderHandlers loaded:");
                for (ClassLoaderHandler classLoaderHandler : classLoaderHandlers) {
                    classLoaderHandlerLog.log(classLoaderHandler.getClass().getName());
                }
            }
            for (ClassLoader classLoader : classLoaderOrder) {
                if (scanSpec.blacklistSystemJars() && classLoader.getClass().getName().startsWith("sun.misc.Launcher$ExtClassLoader")) continue;
                LogNode logNode = log == null ? null : log.log("Finding classpath elements in ClassLoader " + classLoader);
                boolean classloaderFound = false;
                for (ClassLoaderHandler classLoaderHandler : classLoaderHandlers) {
                    try {
                        if (!classLoaderHandler.handle(classLoader, this, logNode)) continue;
                        classloaderFound = true;
                        break;
                    }
                    catch (Exception e) {
                        if (logNode == null) continue;
                        logNode.log("Exception in ClassLoaderHandler", e);
                    }
                }
                if (classloaderFound || logNode == null) continue;
                logNode.log("Unknown ClassLoader type, cannot scan classes");
            }
            if (!scanSpec.overrideClassLoaders) {
                LogNode sysPropLog = log == null ? null : log.log("Getting classpath entries from java.class.path");
                this.addClasspathElements(System.getProperty("java.class.path"), classLoaderOrder, sysPropLog);
            }
        }
    }

    public List<ClasspathRelativePath> getRawClasspathElements() {
        return this.rawClasspathElements;
    }

    private static boolean isDescendantOf(ClassLoader cl0, ClassLoader cl1) {
        for (ClassLoader cl = cl0; cl != null; cl = cl.getParent()) {
            if (cl != cl1) continue;
            return true;
        }
        return false;
    }

    public static List<ClassLoader> findAllClassLoaders(LogNode log) {
        boolean useSystemLoader;
        AdditionOrderedSet<ClassLoader> classLoadersSet = new AdditionOrderedSet<ClassLoader>();
        ClassLoader callerLoader = null;
        if (CALLER_RESOLVER == null) {
            if (log != null) {
                log.log(ClasspathFinder.class.getSimpleName() + " could not create " + CallerResolver.class.getSimpleName() + ", current SecurityManager does not grant RuntimePermission(\"createSecurityManager\")");
            }
        } else {
            Class<?>[] callStack = CALLER_RESOLVER.getClassContext();
            if (callStack == null) {
                if (log != null) {
                    log.log(ClasspathFinder.class.getSimpleName() + ": " + CallerResolver.class.getSimpleName() + "#getClassContext() returned null");
                }
            } else {
                int fcsIdx;
                String fcsPkgPrefix = FastClasspathScanner.class.getPackage().getName() + ".";
                for (fcsIdx = callStack.length - 1; fcsIdx >= 0 && !callStack[fcsIdx].getName().startsWith(fcsPkgPrefix); --fcsIdx) {
                }
                if (fcsIdx < 0 || fcsIdx == callStack.length - 1) {
                    throw new RuntimeException("Could not find caller of " + fcsPkgPrefix + "* in call stack");
                }
                callerLoader = callStack[fcsIdx + 1].getClassLoader();
            }
        }
        boolean useCallerLoader = callerLoader != null;
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        boolean useContextLoader = contextLoader != null;
        ClassLoader systemLoader = ClassLoader.getSystemClassLoader();
        boolean bl = useSystemLoader = systemLoader != null;
        if (useCallerLoader && useContextLoader && ClasspathFinder.isDescendantOf(callerLoader, contextLoader)) {
            useContextLoader = false;
        }
        if (useContextLoader && useCallerLoader && ClasspathFinder.isDescendantOf(contextLoader, callerLoader)) {
            useCallerLoader = false;
        }
        if (useSystemLoader && useContextLoader && ClasspathFinder.isDescendantOf(systemLoader, contextLoader)) {
            useContextLoader = false;
        }
        if (useContextLoader && useSystemLoader && ClasspathFinder.isDescendantOf(contextLoader, systemLoader)) {
            useSystemLoader = false;
        }
        if (useSystemLoader && useCallerLoader && ClasspathFinder.isDescendantOf(systemLoader, callerLoader)) {
            useCallerLoader = false;
        }
        if (useCallerLoader && useSystemLoader && ClasspathFinder.isDescendantOf(callerLoader, systemLoader)) {
            useSystemLoader = false;
        }
        if (!(useCallerLoader || useContextLoader || useSystemLoader)) {
            throw new RuntimeException("Could not find a usable ClassLoader");
        }
        if (useSystemLoader) {
            classLoadersSet.add(systemLoader);
        }
        if (useCallerLoader) {
            classLoadersSet.add(callerLoader);
        }
        if (useContextLoader) {
            classLoadersSet.add(contextLoader);
        }
        List<ClassLoader> classLoaders = classLoadersSet.getList();
        if (log != null) {
            for (ClassLoader classLoader : classLoaders) {
                log.log("Found ClassLoader " + classLoader.toString());
            }
            log.addElapsedTime();
        }
        return classLoaders;
    }

    static {
        try {
            CALLER_RESOLVER = new CallerResolver();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private static final class CallerResolver
    extends SecurityManager {
        private CallerResolver() {
        }

        @Override
        protected Class<?>[] getClassContext() {
            return super.getClassContext();
        }
    }
}

