/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.classloaderhandler;

import io.github.lukehutch.fastclasspathscanner.classloaderhandler.ClassLoaderHandler;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathFinder;
import io.github.lukehutch.fastclasspathscanner.utils.ClasspathUtils;
import io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import io.github.lukehutch.fastclasspathscanner.utils.ReflectionUtils;
import java.io.File;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;

public class JBossClassLoaderHandler
implements ClassLoaderHandler {
    @Override
    public boolean handle(ClassLoader classLoader, ClasspathFinder classpathFinder, LogNode log) throws Exception {
        boolean handled = false;
        List<ClassLoader> classLoaders = Arrays.asList(classLoader);
        for (Class<?> c = classLoader.getClass(); c != null; c = c.getSuperclass()) {
            Object vfsResourceLoaders;
            if (!"org.jboss.modules.ModuleClassLoader".equals(c.getName()) || (vfsResourceLoaders = ReflectionUtils.invokeMethod(classLoader, "getResourceLoaders")) == null) continue;
            int n = Array.getLength(vfsResourceLoaders);
            for (int i = 0; i < n; ++i) {
                String path = null;
                Object resourceLoader = Array.get(vfsResourceLoaders, i);
                if (resourceLoader != null) {
                    Object root = ReflectionUtils.getFieldVal(resourceLoader, "root");
                    File physicalFile = (File)ReflectionUtils.invokeMethod(root, "getPhysicalFile");
                    if (physicalFile != null) {
                        File file;
                        String name = (String)ReflectionUtils.invokeMethod(root, "getName");
                        path = name != null ? (ClasspathUtils.canRead(file = new File(physicalFile.getParentFile(), name)) ? file.getAbsolutePath() : physicalFile.getAbsolutePath()) : physicalFile.getAbsolutePath();
                    } else {
                        path = (String)ReflectionUtils.invokeMethod(root, "getPathName");
                        if (path == null) {
                            Object file = root;
                            if (file == null) {
                                file = ReflectionUtils.getFieldVal(resourceLoader, "fileOfJar");
                            }
                            path = (String)ReflectionUtils.invokeMethod(file, "getAbsolutePath");
                        }
                    }
                }
                handled |= classpathFinder.addClasspathElement(path, classLoaders, log);
            }
        }
        return handled;
    }
}

