/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.utils;

import io.github.lukehutch.fastclasspathscanner.utils.ClasspathUtils;
import io.github.lukehutch.fastclasspathscanner.utils.FastPathResolver;
import io.github.lukehutch.fastclasspathscanner.utils.InterruptionChecker;
import io.github.lukehutch.fastclasspathscanner.utils.JarUtils;
import io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import io.github.lukehutch.fastclasspathscanner.utils.Recycler;
import io.github.lukehutch.fastclasspathscanner.utils.SingletonMap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.AbstractMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class NestedJarHandler {
    private final ConcurrentLinkedDeque<File> tempFiles = new ConcurrentLinkedDeque();
    private final SingletonMap<String, Map.Entry<File, Set<String>>> nestedPathToJarfileAndRootRelativePathsMap;
    private final SingletonMap<String, Recycler<ZipFile, IOException>> canonicalPathToZipFileRecyclerMap;
    private final InterruptionChecker interruptionChecker;
    public static final String TEMP_FILENAME_LEAF_SEPARATOR = "---";

    public NestedJarHandler(InterruptionChecker interruptionChecker, LogNode log) {
        this.interruptionChecker = interruptionChecker;
        this.canonicalPathToZipFileRecyclerMap = new SingletonMap<String, Recycler<ZipFile, IOException>>(){

            @Override
            public Recycler<ZipFile, IOException> newInstance(final String canonicalPath, LogNode log) throws Exception {
                return new Recycler<ZipFile, IOException>(){

                    @Override
                    public ZipFile newInstance() throws IOException {
                        return new ZipFile(canonicalPath);
                    }
                };
            }
        };
        this.nestedPathToJarfileAndRootRelativePathsMap = new SingletonMap<String, Map.Entry<File, Set<String>>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Map.Entry<File, Set<String>> newInstance(String nestedJarPath, LogNode log) throws Exception {
                Map.Entry parentJarfileAndRootRelativePaths;
                File parentJarFile;
                int lastPlingIdx = nestedJarPath.lastIndexOf(33);
                if (lastPlingIdx < 0) {
                    File canonicalFile;
                    File pathFile;
                    boolean isRemote = nestedJarPath.startsWith("http://") || nestedJarPath.startsWith("https://");
                    File file = pathFile = isRemote ? NestedJarHandler.this.downloadTempFile(nestedJarPath, log) : new File(nestedJarPath);
                    if (isRemote && pathFile == null) {
                        if (log != null) {
                            log.log(nestedJarPath, "Could not download jarfile " + nestedJarPath);
                        }
                        return null;
                    }
                    try {
                        canonicalFile = pathFile.getCanonicalFile();
                    }
                    catch (IOException | SecurityException e) {
                        if (log != null) {
                            log.log(nestedJarPath, "Path component " + nestedJarPath + " could not be canonicalized: " + e);
                        }
                        return null;
                    }
                    if (!ClasspathUtils.canRead(canonicalFile)) {
                        if (log != null) {
                            log.log(nestedJarPath, "Path component " + nestedJarPath + " does not exist");
                        }
                        return null;
                    }
                    if (!canonicalFile.isFile()) {
                        if (log != null) {
                            log.log(nestedJarPath, "Path component " + nestedJarPath + "  is not a file (expected a jarfile)");
                        }
                        return null;
                    }
                    File bareJarfile = NestedJarHandler.this.stripSFXHeader(canonicalFile, log);
                    HashSet rootRelativePaths = new HashSet();
                    return new AbstractMap.SimpleEntry<File, Set<String>>(bareJarfile, rootRelativePaths);
                }
                String parentPath = nestedJarPath.substring(0, lastPlingIdx);
                String childPath = nestedJarPath.substring(lastPlingIdx + 1);
                if (childPath.startsWith("/")) {
                    childPath = childPath.substring(1);
                }
                if ((parentJarFile = (File)(parentJarfileAndRootRelativePaths = (Map.Entry)NestedJarHandler.this.nestedPathToJarfileAndRootRelativePathsMap.getOrCreateSingleton(parentPath, log)).getKey()) == null) {
                    return null;
                }
                String parentJarFilePath = FastPathResolver.resolve(parentJarFile.getPath());
                if (!parentJarFilePath.equals(parentPath)) {
                    return (Map.Entry)NestedJarHandler.this.nestedPathToJarfileAndRootRelativePathsMap.getOrCreateSingleton(parentJarFilePath + "!" + childPath, log);
                }
                File bareParentJarFile = NestedJarHandler.this.stripSFXHeader(parentJarFile, log);
                Recycler parentJarRecycler = (Recycler)NestedJarHandler.this.canonicalPathToZipFileRecyclerMap.getOrCreateSingleton(bareParentJarFile.getCanonicalPath(), log);
                ZipFile parentZipFile = null;
                try {
                    ZipEntry childZipEntry;
                    parentZipFile = (ZipFile)parentJarRecycler.acquire();
                    if (childPath.endsWith("/")) {
                        childZipEntry = parentZipFile.getEntry(childPath);
                    } else {
                        childZipEntry = parentZipFile.getEntry(childPath + "/");
                        if (childZipEntry == null) {
                            childZipEntry = parentZipFile.getEntry(childPath);
                        }
                    }
                    if (childZipEntry == null) {
                        if (log != null) {
                            log.log(nestedJarPath, "Child path component " + childPath + " does not exist in jarfile " + bareParentJarFile);
                        }
                        Map.Entry<File, Set<String>> entry = null;
                        return entry;
                    }
                    if (childZipEntry.isDirectory()) {
                        if (log != null) {
                            log.log(nestedJarPath, "Child path component " + childPath + " in jarfile " + bareParentJarFile + " is a directory, not a file -- using as scanning root");
                        }
                        ((Set)parentJarfileAndRootRelativePaths.getValue()).add(childPath);
                        Map.Entry entry = parentJarfileAndRootRelativePaths;
                        return entry;
                    }
                    File childTempFile = NestedJarHandler.this.unzipToTempFile(parentZipFile, childZipEntry, log);
                    HashSet rootRelativePaths = new HashSet();
                    AbstractMap.SimpleEntry<File, Set<String>> simpleEntry = new AbstractMap.SimpleEntry<File, Set<String>>(childTempFile, rootRelativePaths);
                    return simpleEntry;
                }
                finally {
                    parentJarRecycler.release(parentZipFile);
                }
            }
        };
    }

    public Recycler<ZipFile, IOException> getZipFileRecycler(String canonicalPath, LogNode log) throws Exception {
        return this.canonicalPathToZipFileRecyclerMap.getOrCreateSingleton(canonicalPath, log);
    }

    public Map.Entry<File, Set<String>> getInnermostNestedJar(String nestedJarPath, LogNode log) throws Exception {
        return this.nestedPathToJarfileAndRootRelativePathsMap.getOrCreateSingleton(nestedJarPath, log);
    }

    private File downloadTempFile(String jarURL, LogNode log) {
        LogNode subLog = log == null ? null : log.log(jarURL, "Downloading URL " + jarURL);
        File tempFile = null;
        try {
            String suffix = TEMP_FILENAME_LEAF_SEPARATOR + jarURL.replace('/', '_').replace(':', '_').replace('?', '_').replace('&', '_').replace('=', '_');
            tempFile = File.createTempFile("FastClasspathScanner-", suffix);
            tempFile.deleteOnExit();
            this.tempFiles.add(tempFile);
            URL url = new URL(jarURL);
            try (InputStream inputStream = url.openStream();){
                Files.copy(inputStream, tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            if (subLog != null) {
                subLog.addElapsedTime();
            }
        }
        catch (Exception e) {
            if (subLog != null) {
                subLog.log("Could not download " + jarURL, e);
            }
            return null;
        }
        if (subLog != null) {
            subLog.log("Downloaded to temporary file " + tempFile);
            subLog.log("***** Note that it is time-consuming to scan jars at http(s) addresses, they must be downloaded for every scan, and the same jars must also be separately downloaded by the ClassLoader *****");
        }
        return tempFile;
    }

    private File unzipToTempFile(ZipFile zipFile, ZipEntry zipEntry, LogNode log) throws IOException {
        String zipEntryPath = zipEntry.getName();
        if (zipEntryPath.startsWith("/")) {
            zipEntryPath = zipEntryPath.substring(1);
        }
        String zipEntryLeaf = zipEntryPath.substring(zipEntryPath.lastIndexOf(47) + 1);
        File tempFile = File.createTempFile("FastClasspathScanner-", TEMP_FILENAME_LEAF_SEPARATOR + zipEntryLeaf);
        tempFile.deleteOnExit();
        this.tempFiles.add(tempFile);
        LogNode subLog = null;
        if (log != null) {
            String qualifiedPath = zipFile.getName() + "!/" + zipEntryPath;
            subLog = log.log(qualifiedPath, "Unzipping zip entry " + qualifiedPath);
            subLog.log("Extracted to temporary file " + tempFile.getPath());
        }
        try (InputStream inputStream = zipFile.getInputStream(zipEntry);){
            Files.copy(inputStream, tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        if (subLog != null) {
            subLog.addElapsedTime();
        }
        return tempFile;
    }

    private File stripSFXHeader(File zipfile, LogNode log) throws IOException {
        long sfxHeaderBytes = JarUtils.countBytesBeforePKMarker(zipfile);
        if (sfxHeaderBytes == -1L) {
            throw new IOException("Could not find zipfile \"PK\" marker in file " + zipfile);
        }
        if (sfxHeaderBytes == 0L) {
            return zipfile;
        }
        File bareZipfile = File.createTempFile("FastClasspathScanner-", TEMP_FILENAME_LEAF_SEPARATOR + JarUtils.leafName(zipfile.getName()));
        bareZipfile.deleteOnExit();
        this.tempFiles.add(bareZipfile);
        if (log != null) {
            log.log("Zipfile " + zipfile + " contains a self-extracting executable header of " + sfxHeaderBytes + " bytes. Stripping off header to create bare zipfile " + bareZipfile);
        }
        JarUtils.stripSFXHeader(zipfile, sfxHeaderBytes, bareZipfile);
        return bareZipfile;
    }

    public void close(LogNode log) {
        LogNode rmLog;
        LogNode logNode = rmLog = this.tempFiles.isEmpty() || log == null ? null : log.log("Removing temporary files");
        while (!this.tempFiles.isEmpty()) {
            File head = this.tempFiles.remove();
            String path = head.getPath();
            boolean success = head.delete();
            if (log == null) continue;
            rmLog.log((success ? "Removed" : "Unable to remove") + " " + path);
        }
        List<Recycler<ZipFile, IOException>> recyclers = null;
        try {
            recyclers = this.canonicalPathToZipFileRecyclerMap.values();
        }
        catch (InterruptedException e) {
            this.interruptionChecker.interrupt();
        }
        if (recyclers != null) {
            for (Recycler<ZipFile, IOException> recycler : recyclers) {
                recycler.close();
            }
            this.canonicalPathToZipFileRecyclerMap.clear();
        }
    }
}

