/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.typesignature;

import io.github.lukehutch.fastclasspathscanner.scanner.ScanResult;
import io.github.lukehutch.fastclasspathscanner.typesignature.ClassRefOrTypeVariableSignature;
import io.github.lukehutch.fastclasspathscanner.typesignature.ClassRefTypeSignature;
import io.github.lukehutch.fastclasspathscanner.typesignature.ClassTypeSignature;
import io.github.lukehutch.fastclasspathscanner.typesignature.MethodTypeSignature;
import io.github.lukehutch.fastclasspathscanner.typesignature.ReferenceTypeSignature;
import io.github.lukehutch.fastclasspathscanner.typesignature.TypeParameter;
import io.github.lukehutch.fastclasspathscanner.typesignature.TypeSignature;
import io.github.lukehutch.fastclasspathscanner.typesignature.TypeUtils;
import java.util.Set;

public class TypeVariableSignature
extends ClassRefOrTypeVariableSignature {
    private final String typeVariableName;
    MethodTypeSignature containingMethodSignature;
    ClassTypeSignature containingClassSignature;

    public TypeVariableSignature(String typeVariableName) {
        this.typeVariableName = typeVariableName;
    }

    public String getTypeVariableName() {
        return this.typeVariableName;
    }

    public TypeParameter getCorrespondingTypeParameter() {
        if (this.containingMethodSignature != null && this.containingMethodSignature.typeParameters != null && !this.containingMethodSignature.typeParameters.isEmpty()) {
            for (TypeParameter typeParameter : this.containingMethodSignature.typeParameters) {
                if (!typeParameter.identifier.equals(this.typeVariableName)) continue;
                return typeParameter;
            }
        }
        if (this.containingClassSignature != null && this.containingClassSignature.typeParameters != null && !this.containingClassSignature.typeParameters.isEmpty()) {
            for (TypeParameter typeParameter : this.containingClassSignature.typeParameters) {
                if (!typeParameter.identifier.equals(this.typeVariableName)) continue;
                return typeParameter;
            }
        }
        return null;
    }

    @Override
    public void getAllReferencedClassNames(Set<String> classNameListOut) {
    }

    @Override
    public Class<?> instantiate(ScanResult scanResult) {
        throw new RuntimeException("Cannot instantiate a type variable");
    }

    public int hashCode() {
        return this.typeVariableName.hashCode();
    }

    @Override
    public boolean equalsIgnoringTypeParams(TypeSignature other) {
        if (other instanceof ClassRefTypeSignature) {
            if (((ClassRefTypeSignature)other).className.equals("java.lang.Object")) {
                return true;
            }
            TypeParameter typeParameter = this.getCorrespondingTypeParameter();
            if (typeParameter == null) {
                return true;
            }
            if (typeParameter.classBound == null && (typeParameter.interfaceBounds == null || typeParameter.interfaceBounds.isEmpty())) {
                return true;
            }
            if (typeParameter.classBound != null) {
                if (typeParameter.classBound instanceof ClassRefTypeSignature) {
                    if (typeParameter.classBound.equals(other)) {
                        return true;
                    }
                } else {
                    if (typeParameter.classBound instanceof TypeVariableSignature) {
                        return this.equalsIgnoringTypeParams(typeParameter.classBound);
                    }
                    return false;
                }
            }
            for (ReferenceTypeSignature interfaceBound : typeParameter.interfaceBounds) {
                if (interfaceBound instanceof ClassRefTypeSignature) {
                    if (!interfaceBound.equals(other)) continue;
                    return true;
                }
                if (interfaceBound instanceof TypeVariableSignature) {
                    return this.equalsIgnoringTypeParams(interfaceBound);
                }
                return false;
            }
            return false;
        }
        return this.equals(other);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TypeVariableSignature)) {
            return false;
        }
        TypeVariableSignature o = (TypeVariableSignature)obj;
        return o.typeVariableName.equals(this.typeVariableName);
    }

    public String toString() {
        return this.typeVariableName;
    }

    public String toStringWithTypeBound() {
        TypeParameter typeParameter = this.getCorrespondingTypeParameter();
        if (typeParameter == null) {
            return this.typeVariableName;
        }
        return typeParameter.toString();
    }

    static TypeVariableSignature parse(TypeUtils.ParseState parseState) throws TypeUtils.ParseException {
        char peek = parseState.peek();
        if (peek == 'T') {
            parseState.next();
            if (!parseState.parseIdentifier()) {
                throw new TypeUtils.ParseException();
            }
            parseState.expect(';');
            TypeVariableSignature typeVariableSignature = new TypeVariableSignature(parseState.currToken());
            parseState.addTypeVariableSignature(typeVariableSignature);
            return typeVariableSignature;
        }
        return null;
    }
}

