/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import io.github.lukehutch.fastclasspathscanner.utils.ClasspathUtils;
import io.github.lukehutch.fastclasspathscanner.utils.FastPathResolver;
import io.github.lukehutch.fastclasspathscanner.utils.FileUtils;
import io.github.lukehutch.fastclasspathscanner.utils.JarUtils;
import io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import io.github.lukehutch.fastclasspathscanner.utils.NestedJarHandler;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Set;

class RelativePath {
    private final ClassLoader[] classLoaders;
    private final String pathToResolveAgainst;
    private final String relativePath;
    private String zipClasspathBaseDir = "";
    private final NestedJarHandler nestedJarHandler;
    private String resolvedPathCached;
    private boolean resolvedPathIsCached;
    private boolean isHttpURL;
    private boolean isHttpURLIsCached;
    private File fileCached;
    private boolean fileIsCached;
    private String canonicalPathCached;
    private boolean canonicalPathIsCached;
    private boolean isFileCached;
    private boolean isFileIsCached;
    private boolean isDirectoryCached;
    private boolean isDirectoryIsCached;
    private boolean existsCached;
    private boolean existsIsCached;
    private final LogNode log;

    public RelativePath(String pathToResolveAgainst, String relativePath, ClassLoader[] classLoaders, NestedJarHandler nestedJarHandler, LogNode log) {
        this.classLoaders = classLoaders;
        this.pathToResolveAgainst = pathToResolveAgainst;
        this.nestedJarHandler = nestedJarHandler;
        this.log = log;
        this.relativePath = relativePath.endsWith("!") ? relativePath.substring(0, relativePath.length() - 1) : (relativePath.endsWith("!/") ? relativePath.substring(0, relativePath.length() - 2) : (relativePath.endsWith("/!") ? relativePath.substring(0, relativePath.length() - 2) : (relativePath.endsWith("/!/") ? relativePath.substring(0, relativePath.length() - 3) : relativePath)));
    }

    public int hashCode() {
        try {
            return this.getCanonicalPath(this.log).hashCode() + this.zipClasspathBaseDir.hashCode() * 57;
        }
        catch (IOException e) {
            return 0;
        }
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof RelativePath)) {
            return false;
        }
        RelativePath other = (RelativePath)o;
        try {
            String thisCp = this.getCanonicalPath(this.log);
            String otherCp = other.getCanonicalPath(this.log);
            if (thisCp == null || otherCp == null) {
                return false;
            }
            if (!thisCp.equals(otherCp)) {
                return false;
            }
            return this.getZipClasspathBaseDir().equals(other.getZipClasspathBaseDir());
        }
        catch (IOException e) {
            return false;
        }
    }

    public String toString(LogNode log) {
        try {
            return this.zipClasspathBaseDir.isEmpty() ? this.getCanonicalPath(log) : this.getCanonicalPath(log) + "!" + this.zipClasspathBaseDir;
        }
        catch (IOException e) {
            return this.getResolvedPath();
        }
    }

    public String toString() {
        return this.toString(this.log);
    }

    public ClassLoader[] getClassLoaders() {
        return this.classLoaders;
    }

    public String getResolvedPath() {
        if (!this.resolvedPathIsCached) {
            this.resolvedPathCached = FastPathResolver.resolve(this.pathToResolveAgainst, this.relativePath);
            this.resolvedPathIsCached = true;
        }
        return this.resolvedPathCached;
    }

    public boolean isHttpURL() {
        if (!this.isHttpURLIsCached) {
            String resolvedPath = this.getResolvedPath();
            this.isHttpURL = resolvedPath.regionMatches(true, 0, "http://", 0, 7) || resolvedPath.regionMatches(true, 0, "https://", 0, 8);
            this.isHttpURLIsCached = true;
        }
        return this.isHttpURL;
    }

    public File getFile(LogNode log) throws IOException {
        if (!this.fileIsCached) {
            String path = this.getResolvedPath();
            if (path == null) {
                throw new IOException("Path " + this.relativePath + " could not be resolved relative to " + this.pathToResolveAgainst);
            }
            File pathFile = new File(path);
            if (pathFile.exists() && pathFile.isDirectory()) {
                this.fileCached = pathFile;
            } else {
                int plingIdx = path.lastIndexOf(33);
                try {
                    Map.Entry<File, Set<String>> innermostJarAndRootRelativePaths = this.nestedJarHandler.getInnermostNestedJar(path, log);
                    if (innermostJarAndRootRelativePaths != null) {
                        this.fileCached = innermostJarAndRootRelativePaths.getKey();
                        Set<String> rootRelativePaths = innermostJarAndRootRelativePaths.getValue();
                        if (!rootRelativePaths.isEmpty()) {
                            String tail;
                            String string = path.length() == plingIdx + 1 ? "" : (tail = path.charAt(plingIdx + 1) == '/' ? path.substring(plingIdx + 2) : path.substring(plingIdx + 1));
                            if (rootRelativePaths.contains(tail)) {
                                // empty if block
                            }
                            this.zipClasspathBaseDir = tail;
                        }
                    }
                }
                catch (Exception e) {
                    throw new IOException("Exception while locating jarfile " + this.relativePath, e);
                }
            }
            if (this.fileCached == null || !ClasspathUtils.canRead(this.fileCached)) {
                throw new IOException("Could not locate jarfile " + this.relativePath + (this.relativePath.equals(path) ? "" : " -- resolved to: " + path));
            }
            try {
                this.fileCached = this.fileCached.getCanonicalFile();
            }
            catch (IOException e) {
                throw new IOException("Could not canonicalize path " + path + " : " + e);
            }
            catch (SecurityException e) {
                throw new IOException("Could not canonicalize path " + path + " : " + e);
            }
            this.fileIsCached = true;
        }
        return this.fileCached;
    }

    public String getZipClasspathBaseDir() {
        return this.zipClasspathBaseDir;
    }

    public String getCanonicalPath(LogNode log) throws IOException {
        if (!this.canonicalPathIsCached) {
            File file = this.getFile(log);
            this.canonicalPathCached = FastPathResolver.resolve(file.getPath());
            this.canonicalPathIsCached = true;
        }
        return this.canonicalPathCached;
    }

    public boolean isFile(LogNode log) throws IOException {
        if (!this.isFileIsCached) {
            this.isFileCached = this.getFile(log).isFile();
            this.isFileIsCached = true;
        }
        return this.isFileCached;
    }

    public boolean isDirectory(LogNode log) throws IOException {
        if (!this.isDirectoryIsCached) {
            this.isDirectoryCached = this.getFile(log).isDirectory();
            this.isDirectoryIsCached = true;
        }
        return this.isDirectoryCached;
    }

    public boolean isClassfile() {
        return FileUtils.isClassfile(this.getResolvedPath());
    }

    private boolean exists(LogNode log) throws IOException {
        if (!this.existsIsCached) {
            this.existsCached = ClasspathUtils.canRead(this.getFile(log));
            this.existsIsCached = true;
        }
        return this.existsCached;
    }

    public boolean isValidClasspathElement(ScanSpec scanSpec, LogNode log) throws InterruptedException {
        String path = this.getResolvedPath();
        try {
            boolean isDirectory;
            if (!this.exists(log)) {
                if (log != null) {
                    log.log("Classpath element does not exist: " + path);
                }
                return false;
            }
            boolean isFile = this.isFile(log);
            if (isFile != !(isDirectory = this.isDirectory(log))) {
                if (log != null) {
                    log.log("Ignoring invalid classpath element: " + path);
                }
                return false;
            }
            if (isFile) {
                String canonicalPath = this.getCanonicalPath(log);
                if (scanSpec.blacklistSystemJars() && JarUtils.isJREJar(canonicalPath, log)) {
                    if (log != null) {
                        log.log("Ignoring JRE jar: " + path);
                    }
                    return false;
                }
            }
        }
        catch (IOException e) {
            if (log != null) {
                log.log("Could not canonicalize path " + path + " : " + e);
            }
            return false;
        }
        return true;
    }
}

