/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.classloaderhandler;

import io.github.lukehutch.fastclasspathscanner.classloaderhandler.ClassLoaderHandler;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathFinder;
import io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import io.github.lukehutch.fastclasspathscanner.utils.ReflectionUtils;
import java.io.File;
import java.lang.reflect.Array;

public class JBossClassLoaderHandler
implements ClassLoaderHandler {
    @Override
    public boolean handle(ClassLoader classloader, ClasspathFinder classpathFinder, LogNode log) throws Exception {
        for (Class<?> c = classloader.getClass(); c != null; c = c.getSuperclass()) {
            if (!"org.jboss.modules.ModuleClassLoader".equals(c.getName())) continue;
            Object vfsResourceLoaders = ReflectionUtils.invokeMethod(classloader, "getResourceLoaders");
            if (vfsResourceLoaders != null) {
                int n = Array.getLength(vfsResourceLoaders);
                for (int i = 0; i < n; ++i) {
                    String path = null;
                    Object resourceLoader = Array.get(vfsResourceLoaders, i);
                    if (resourceLoader != null) {
                        File file;
                        String name;
                        Object root = ReflectionUtils.getFieldVal(resourceLoader, "root");
                        File physicalFile = (File)ReflectionUtils.invokeMethod(root, "getPhysicalFile");
                        path = physicalFile != null ? ((name = (String)ReflectionUtils.invokeMethod(root, "getName")) != null ? (!(file = new File(physicalFile.getParentFile(), name)).exists() || !file.canRead() ? physicalFile.getAbsolutePath() : file.getAbsolutePath()) : physicalFile.getAbsolutePath()) : (String)ReflectionUtils.invokeMethod(root, "getPathName");
                    }
                    classpathFinder.addClasspathElement(path, log);
                }
            }
            return true;
        }
        return false;
    }
}

