/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import io.github.lukehutch.fastclasspathscanner.utils.FastPathResolver;
import io.github.lukehutch.fastclasspathscanner.utils.JarUtils;
import io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import io.github.lukehutch.fastclasspathscanner.utils.NestedJarHandler;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;

class ClasspathRelativePath {
    private final String pathToResolveAgainst;
    private final String relativePath;
    private final boolean isJar;
    private String zipClasspathBaseDir = "";
    private final NestedJarHandler nestedJarHandler;
    private String resolvedPathCached;
    private boolean resolvedPathIsCached;
    private File fileCached;
    private boolean fileIsCached;
    private String canonicalPathCached;
    private boolean canonicalPathIsCached;
    private boolean isFileCached;
    private boolean isFileIsCached;
    private boolean isDirectoryCached;
    private boolean isDirectoryIsCached;
    private boolean existsCached;
    private boolean existsIsCached;

    public ClasspathRelativePath(String pathToResolveAgainst, String relativePath, NestedJarHandler nestedJarHandler) {
        this.pathToResolveAgainst = pathToResolveAgainst;
        this.nestedJarHandler = nestedJarHandler;
        this.relativePath = relativePath.endsWith("!") ? relativePath.substring(0, relativePath.length() - 1) : (relativePath.endsWith("!/") ? relativePath.substring(0, relativePath.length() - 2) : (relativePath.endsWith("/!") ? relativePath.substring(0, relativePath.length() - 2) : (relativePath.endsWith("/!/") ? relativePath.substring(0, relativePath.length() - 3) : relativePath)));
        this.isJar = this.relativePath.contains("!") || JarUtils.isJar(this.relativePath);
    }

    public int hashCode() {
        try {
            return this.getCanonicalPath().hashCode() + this.zipClasspathBaseDir.hashCode() * 57;
        }
        catch (IOException e) {
            return 0;
        }
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof ClasspathRelativePath)) {
            return false;
        }
        ClasspathRelativePath other = (ClasspathRelativePath)o;
        try {
            String thisCp = this.getCanonicalPath();
            String otherCp = other.getCanonicalPath();
            if (thisCp == null || otherCp == null) {
                return false;
            }
            if (!thisCp.equals(otherCp)) {
                return false;
            }
            return this.getZipClasspathBaseDir().equals(other.getZipClasspathBaseDir());
        }
        catch (IOException e) {
            return false;
        }
    }

    public String toString() {
        try {
            return this.zipClasspathBaseDir.isEmpty() ? this.getCanonicalPath() : this.getCanonicalPath() + "!" + this.zipClasspathBaseDir;
        }
        catch (IOException e) {
            return this.getResolvedPath();
        }
    }

    public String getResolvedPath() {
        if (!this.resolvedPathIsCached) {
            this.resolvedPathCached = FastPathResolver.resolve(this.pathToResolveAgainst, this.relativePath);
            this.resolvedPathIsCached = true;
        }
        return this.resolvedPathCached;
    }

    public File getFile() throws IOException {
        if (!this.fileIsCached) {
            String path = this.getResolvedPath();
            if (path == null) {
                throw new IOException("Path " + this.relativePath + " could not be resolved relative to " + this.pathToResolveAgainst);
            }
            int plingIdx = path.indexOf(33);
            if (plingIdx > 0) {
                String nestedJarPath;
                String[] parts = path.split("!");
                int ii = parts.length - 1;
                for (int i = 0; i < ii; ++i) {
                    if (JarUtils.isJar(parts[i])) continue;
                    throw new IOException("Path " + path + " uses nested jar syntax, but contains a segment that does not have a jar extension");
                }
                if (!JarUtils.isJar(parts[parts.length - 1])) {
                    this.zipClasspathBaseDir = parts[parts.length - 1];
                    if (this.zipClasspathBaseDir.startsWith("/")) {
                        this.zipClasspathBaseDir = this.zipClasspathBaseDir.substring(1);
                    }
                    nestedJarPath = path.substring(0, path.lastIndexOf(33));
                } else {
                    nestedJarPath = path;
                }
                this.fileCached = this.nestedJarHandler.getInnermostNestedJar(nestedJarPath);
                if (this.fileCached == null) {
                    throw new IOException("Could not unzip nested jarfile: " + path);
                }
            } else {
                this.fileCached = new File(path);
            }
            this.fileCached = this.fileCached.getCanonicalFile();
            this.fileIsCached = true;
        }
        return this.fileCached;
    }

    public String getZipClasspathBaseDir() {
        return this.zipClasspathBaseDir;
    }

    public String getCanonicalPath() throws IOException {
        if (!this.canonicalPathIsCached) {
            File file = this.getFile();
            this.canonicalPathCached = file.getPath();
            this.canonicalPathIsCached = true;
        }
        return this.canonicalPathCached;
    }

    public boolean isFile() throws IOException {
        if (!this.isFileIsCached) {
            this.isFileCached = this.getFile().isFile();
            this.isFileIsCached = true;
        }
        return this.isFileCached;
    }

    public boolean isDirectory() throws IOException {
        if (!this.isDirectoryIsCached) {
            this.isDirectoryCached = this.getFile().isDirectory();
            this.isDirectoryIsCached = true;
        }
        return this.isDirectoryCached;
    }

    public boolean isJar() {
        return this.isJar;
    }

    public static boolean isClassfile(String path) {
        int len = path.length();
        return len > 6 && path.regionMatches(true, len - 6, ".class", 0, 6);
    }

    public boolean isClassfile() {
        return ClasspathRelativePath.isClassfile(this.getResolvedPath());
    }

    private boolean exists() throws IOException {
        if (!this.existsIsCached) {
            this.existsCached = this.getFile().exists();
            this.existsIsCached = true;
        }
        return this.existsCached;
    }

    public boolean isValidClasspathElement(ScanSpec scanSpec, ConcurrentHashMap<String, String> knownJREPaths, ConcurrentHashMap<String, String> knownNonJREPaths, LogNode log) throws InterruptedException {
        String path = this.getResolvedPath();
        if (path == null) {
            if (log != null) {
                log.log("Ignoring non-local classpath element: " + this.relativePath);
            }
            return false;
        }
        try {
            boolean isDirectory;
            if (!this.exists()) {
                if (log != null) {
                    log.log("Classpath element does not exist: " + path);
                }
                return false;
            }
            boolean isFile = this.isFile();
            if (isFile != !(isDirectory = this.isDirectory())) {
                if (log != null) {
                    log.log("Ignoring invalid classpath element: " + path);
                }
                return false;
            }
            if (isFile) {
                String canonicalPath = this.getCanonicalPath();
                if (!JarUtils.isJar(canonicalPath)) {
                    if (log != null) {
                        log.log("Ignoring non-jar file on classpath: " + path);
                    }
                    return false;
                }
                if (!scanSpec.scanJars) {
                    if (log != null) {
                        log.log("Ignoring jarfile, as jars are not being scanned: " + path);
                    }
                    return false;
                }
                if (scanSpec.blacklistSystemJars() && JarUtils.isJREJar(this.getFile(), 2, knownJREPaths, knownNonJREPaths, log)) {
                    if (log != null) {
                        log.log("Ignoring JRE jar: " + path);
                    }
                    return false;
                }
                if (!scanSpec.jarIsWhitelisted(canonicalPath)) {
                    if (log != null) {
                        log.log("Ignoring jarfile that did not match whitelist/blacklist criteria: " + path);
                    }
                    return false;
                }
            } else if (!scanSpec.scanDirs) {
                if (log != null) {
                    log.log("Ignoring directory, as directories are not being scanned: " + path);
                }
                return false;
            }
        }
        catch (IOException e) {
            if (log != null) {
                log.log("Could not canonicalize path: " + path);
            }
            return false;
        }
        return true;
    }
}

