/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.FastClasspathScanner;
import io.github.lukehutch.fastclasspathscanner.classloaderhandler.ClassLoaderHandler;
import io.github.lukehutch.fastclasspathscanner.classloaderhandler.ClassLoaderHandlerRegistry;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import io.github.lukehutch.fastclasspathscanner.utils.AdditionOrderedSet;
import io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class ClasspathFinder {
    private final List<String> rawClasspathElements = new ArrayList<String>();
    private static CallerResolver CALLER_RESOLVER;

    public boolean addClasspathElement(String pathElement, LogNode log) {
        if (pathElement != null && !pathElement.isEmpty()) {
            this.rawClasspathElements.add(pathElement);
            if (log != null) {
                log.log("Adding classpath element: " + pathElement);
            }
            return true;
        }
        return false;
    }

    public boolean addClasspathElements(String pathStr, LogNode log) {
        if (pathStr != null && !pathStr.isEmpty()) {
            for (String pathElement : pathStr.split(File.pathSeparator)) {
                this.addClasspathElement(pathElement, log);
            }
            return true;
        }
        return false;
    }

    ClasspathFinder(ScanSpec scanSpec, LogNode log) {
        if (scanSpec.overrideClasspath != null) {
            if (scanSpec.overrideClassLoaders && log != null) {
                log.log("It is not possible to override both the classpath and the ClassLoaders -- ignoring the ClassLoader override");
            }
            LogNode overrideLog = log == null ? null : log.log("Overriding classpath");
            this.addClasspathElements(scanSpec.overrideClasspath, overrideLog);
        } else {
            ArrayList<ClassLoaderHandler> classLoaderHandlers = new ArrayList<ClassLoaderHandler>();
            for (Class<? extends ClassLoaderHandler> clazz : ClassLoaderHandlerRegistry.DEFAULT_CLASS_LOADER_HANDLERS) {
                try {
                    classLoaderHandlers.add(clazz.newInstance());
                }
                catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                    if (log == null) continue;
                    log.log("Could not instantiate " + clazz.getName(), reflectiveOperationException);
                }
            }
            for (Class<? extends ClassLoaderHandler> clazz : scanSpec.extraClassLoaderHandlers) {
                try {
                    classLoaderHandlers.add(clazz.newInstance());
                }
                catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                    if (log == null) continue;
                    log.log("Could not instantiate " + clazz.getName(), reflectiveOperationException);
                }
            }
            if (log != null) {
                LogNode classLoaderHandlerLog = log.log("ClassLoaderHandlers loaded:");
                for (ClassLoaderHandler classLoaderHandler : classLoaderHandlers) {
                    classLoaderHandlerLog.log(classLoaderHandler.getClass().getName());
                }
            }
            AdditionOrderedSet allClassLoaders = new AdditionOrderedSet();
            for (ClassLoader classLoader : scanSpec.classLoaders) {
                ArrayList<ClassLoader> parentClassLoaders = new ArrayList<ClassLoader>();
                for (ClassLoader cl = classLoader; cl != null; cl = cl.getParent()) {
                    parentClassLoaders.add(cl);
                }
                for (int i = parentClassLoaders.size() - 1; i >= 0; --i) {
                    allClassLoaders.add(parentClassLoaders.get(i));
                }
            }
            List list = allClassLoaders.getList();
            for (ClassLoader classLoader : list) {
                if (scanSpec.blacklistSystemJars() && classLoader.getClass().getName().startsWith("sun.misc.Launcher$ExtClassLoader")) continue;
                LogNode classLoaderLog = log == null ? null : log.log("Finding classpath elements in ClassLoader " + classLoader);
                boolean classloaderFound = false;
                for (ClassLoaderHandler handler : classLoaderHandlers) {
                    try {
                        if (!handler.handle(classLoader, this, classLoaderLog)) continue;
                        classloaderFound = true;
                        break;
                    }
                    catch (Exception e) {
                        if (classLoaderLog == null) continue;
                        classLoaderLog.log("Exception in ClassLoaderHandler", e);
                    }
                }
                if (classloaderFound || classLoaderLog == null) continue;
                classLoaderLog.log("Unknown ClassLoader type, cannot scan classes");
            }
            if (!scanSpec.overrideClassLoaders) {
                LogNode logNode = log == null ? null : log.log("Getting classpath entries from java.class.path");
                this.addClasspathElements(System.getProperty("java.class.path"), logNode);
            }
        }
    }

    public List<String> getRawClasspathElements() {
        return this.rawClasspathElements;
    }

    private static boolean isDescendantOf(ClassLoader cl0, ClassLoader cl1) {
        for (ClassLoader cl = cl0; cl != null; cl = cl.getParent()) {
            if (cl != cl1) continue;
            return true;
        }
        return false;
    }

    public static List<ClassLoader> findAllClassLoaders(LogNode log) {
        AdditionOrderedSet<ClassLoader> classLoadersSet = new AdditionOrderedSet<ClassLoader>();
        if (CALLER_RESOLVER != null) {
            boolean useSystemLoader;
            int fcsIdx;
            String fcsPkgPrefix = FastClasspathScanner.class.getPackage().getName() + ".";
            Class<?>[] callStack = CALLER_RESOLVER.getClassContext();
            for (fcsIdx = callStack.length - 1; fcsIdx >= 0 && !callStack[fcsIdx].getName().startsWith(fcsPkgPrefix); --fcsIdx) {
            }
            if (fcsIdx < 0 || fcsIdx == callStack.length - 1) {
                throw new RuntimeException("Could not find caller of " + fcsPkgPrefix + "* in call stack");
            }
            ClassLoader callerLoader = callStack[fcsIdx + 1].getClassLoader();
            boolean useCallerLoader = callerLoader != null;
            ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
            boolean useContextLoader = contextLoader != null;
            ClassLoader systemLoader = ClassLoader.getSystemClassLoader();
            boolean bl = useSystemLoader = systemLoader != null;
            if (useCallerLoader && useContextLoader && ClasspathFinder.isDescendantOf(callerLoader, contextLoader)) {
                useContextLoader = false;
            }
            if (useCallerLoader && useContextLoader && ClasspathFinder.isDescendantOf(contextLoader, callerLoader)) {
                useCallerLoader = false;
            }
            if (useSystemLoader && useContextLoader && ClasspathFinder.isDescendantOf(systemLoader, contextLoader)) {
                useContextLoader = false;
            }
            if (useSystemLoader && useContextLoader && ClasspathFinder.isDescendantOf(contextLoader, systemLoader)) {
                useSystemLoader = false;
            }
            if (useSystemLoader && useCallerLoader && ClasspathFinder.isDescendantOf(systemLoader, callerLoader)) {
                useCallerLoader = false;
            }
            if (useSystemLoader && useCallerLoader && ClasspathFinder.isDescendantOf(callerLoader, systemLoader)) {
                useSystemLoader = false;
            }
            if (!(useCallerLoader || useContextLoader || useSystemLoader)) {
                throw new RuntimeException("Could not find a usable ClassLoader");
            }
            if (useSystemLoader) {
                classLoadersSet.add(systemLoader);
            }
            if (useCallerLoader) {
                classLoadersSet.add(callerLoader);
            }
            if (useContextLoader) {
                classLoadersSet.add(contextLoader);
            }
        } else if (log != null) {
            log.log(ClasspathFinder.class.getSimpleName() + " could not create " + CallerResolver.class.getSimpleName() + ", current SecurityManager does not grant RuntimePermission(\"createSecurityManager\")");
        }
        List<ClassLoader> classLoaders = classLoadersSet.getList();
        if (log != null) {
            for (ClassLoader classLoader : classLoaders) {
                log.log("Found ClassLoader " + classLoader.toString());
            }
            log.addElapsedTime();
        }
        return classLoaders;
    }

    static {
        try {
            CALLER_RESOLVER = new CallerResolver();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private static final class CallerResolver
    extends SecurityManager {
        private CallerResolver() {
        }

        @Override
        protected Class<?>[] getClassContext() {
            return super.getClassContext();
        }
    }
}

