/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.utils;

import io.github.lukehutch.fastclasspathscanner.utils.ClasspathUtils;
import io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class JarUtils {
    private static final List<String> JRE_PATHS;
    private static String RT_JAR_PATH;

    private static String getProperty(String propName) {
        try {
            return System.getProperty(propName);
        }
        catch (SecurityException e) {
            return null;
        }
    }

    private static void addJREPath(File dir, Set<String> jrePathsSet) {
        if (ClasspathUtils.canRead(dir) && dir.isDirectory()) {
            String path = dir.getPath();
            if (!path.endsWith(File.separator)) {
                path = path + File.separator;
            }
            jrePathsSet.add(path);
            try {
                String canonicalPath = dir.getCanonicalPath();
                if (!canonicalPath.endsWith(File.separator)) {
                    canonicalPath = canonicalPath + File.separator;
                }
                if (!canonicalPath.equals(path)) {
                    jrePathsSet.add(canonicalPath);
                }
            }
            catch (IOException | SecurityException exception) {
                // empty catch block
            }
        }
    }

    public static String getRtJarPath() {
        return RT_JAR_PATH;
    }

    public static void logJavaInfo(LogNode log) {
        if (log != null) {
            log.log("Operating system: " + JarUtils.getProperty("os.name") + " " + JarUtils.getProperty("os.version") + " " + JarUtils.getProperty("os.arch"));
            log.log("Java version: " + JarUtils.getProperty("java.version") + " (" + JarUtils.getProperty("java.vendor") + ")");
            LogNode javaLog = log.log("JRE paths:");
            for (String jrePath : JRE_PATHS) {
                javaLog.log(jrePath);
            }
            if (RT_JAR_PATH != null) {
                javaLog.log(RT_JAR_PATH);
            }
        }
    }

    public static boolean isJREJar(File jarfile, LogNode log) {
        String filePath = jarfile.getPath();
        for (String jrePathPrefix : JRE_PATHS) {
            if (!filePath.startsWith(jrePathPrefix)) continue;
            return true;
        }
        return false;
    }

    public static boolean isJar(String path) {
        int len = path.length();
        return path.regionMatches(true, len - 4, ".jar", 0, 4) || path.regionMatches(true, len - 4, ".zip", 0, 4) || path.regionMatches(true, len - 4, ".war", 0, 4) || path.regionMatches(true, len - 4, ".car", 0, 4) || path.regionMatches(true, len - 6, ".wsjar", 0, 6);
    }

    public static String leafName(String path) {
        int maxIdx;
        int lastSlashIdx = File.separatorChar == '/' ? path.lastIndexOf(47) : Math.max(path.lastIndexOf(47), path.lastIndexOf(File.separatorChar));
        int sepIdx = path.indexOf("---");
        if (sepIdx >= 0) {
            sepIdx += "---".length() - 1;
        }
        return (maxIdx = Math.max(lastSlashIdx, sepIdx)) < 0 ? path : path.substring(maxIdx + 1);
    }

    static {
        String javaExtDirs;
        JRE_PATHS = new ArrayList<String>();
        RT_JAR_PATH = null;
        HashSet<String> jrePathsSet = new HashSet<String>();
        String javaHome = JarUtils.getProperty("java.home");
        if (javaHome != null && !javaHome.isEmpty()) {
            File javaHomeFile = new File(javaHome);
            JarUtils.addJREPath(javaHomeFile, jrePathsSet);
            File libFile = new File(javaHomeFile, "lib");
            JarUtils.addJREPath(libFile, jrePathsSet);
            File extFile = new File(libFile, "ext");
            JarUtils.addJREPath(extFile, jrePathsSet);
            File rtJarFile = new File(libFile, "rt.jar");
            if (ClasspathUtils.canRead(rtJarFile)) {
                RT_JAR_PATH = rtJarFile.getPath();
            }
        }
        if ((javaExtDirs = JarUtils.getProperty("java.ext.dirs")) != null) {
            for (String javaExtDir : javaExtDirs.split(File.pathSeparator)) {
                if (javaExtDir.isEmpty()) continue;
                File javaExtDirFile = new File(javaExtDir);
                JarUtils.addJREPath(javaExtDirFile, jrePathsSet);
            }
        }
        JRE_PATHS.addAll(jrePathsSet);
        Collections.sort(JRE_PATHS);
    }
}

