/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.classloaderhandler;

import io.github.lukehutch.fastclasspathscanner.classloaderhandler.ClassLoaderHandler;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathFinder;
import io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import io.github.lukehutch.fastclasspathscanner.utils.ReflectionUtils;
import java.lang.reflect.Array;

public class JBossClassLoaderHandler
implements ClassLoaderHandler {
    @Override
    public boolean handle(ClassLoader classloader, ClasspathFinder classpathFinder, LogNode log) throws Exception {
        for (Class<?> c = classloader.getClass(); c != null; c = c.getSuperclass()) {
            if (!"org.jboss.modules.ModuleClassLoader".equals(c.getName())) continue;
            Object vfsResourceLoaders = ReflectionUtils.invokeMethod(classloader, "getResourceLoaders");
            if (vfsResourceLoaders != null) {
                int n = Array.getLength(vfsResourceLoaders);
                for (int i = 0; i < n; ++i) {
                    Object resourceLoader = Array.get(vfsResourceLoaders, i);
                    if (resourceLoader == null) continue;
                    Object root = ReflectionUtils.getFieldVal(resourceLoader, "root");
                    String pathElement = (String)ReflectionUtils.invokeMethod(root, "getPathName");
                    classpathFinder.addClasspathElement(pathElement, log);
                }
            }
            return true;
        }
        return false;
    }
}

