/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner;

import io.github.lukehutch.fastclasspathscanner.ScanInterruptedException;
import io.github.lukehutch.fastclasspathscanner.classloaderhandler.ClassLoaderHandler;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.ClassAnnotationMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.ClassMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.FileMatchContentsProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.FileMatchContentsProcessorWithContext;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.FileMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.FileMatchProcessorWithContext;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.ImplementingClassMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.StaticFinalFieldMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.SubclassMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.SubinterfaceMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanResult;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import io.github.lukehutch.fastclasspathscanner.scanner.Scanner;
import io.github.lukehutch.fastclasspathscanner.utils.AutoCloseableExecutorService;
import io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import io.github.lukehutch.fastclasspathscanner.utils.VersionFinder;
import java.io.File;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class FastClasspathScanner {
    private final String[] scanSpecArgs;
    private ScanSpec scanSpec;
    private List<File> classpathElts;
    private static String version;
    private static final int DEFAULT_NUM_WORKER_THREADS = 6;
    private LogNode log;

    public FastClasspathScanner(String ... scanSpec) {
        this.scanSpecArgs = scanSpec;
    }

    public static final synchronized String getVersion() {
        if (version == null) {
            version = VersionFinder.getVersion();
        }
        return version;
    }

    private synchronized ScanSpec getScanSpec() {
        if (this.scanSpec == null) {
            this.scanSpec = new ScanSpec(this.scanSpecArgs, this.log == null ? null : this.log.log("Parsing scan spec"));
        }
        return this.scanSpec;
    }

    public synchronized FastClasspathScanner verbose(boolean verbose) {
        if (verbose) {
            if (this.log == null) {
                this.log = new LogNode();
            }
        } else {
            this.log = null;
        }
        return this;
    }

    public synchronized FastClasspathScanner verbose() {
        this.verbose(true);
        return this;
    }

    public FastClasspathScanner ignoreFieldVisibility(boolean ignoreFieldVisibility) {
        this.getScanSpec().ignoreFieldVisibility = ignoreFieldVisibility;
        return this;
    }

    public FastClasspathScanner ignoreFieldVisibility() {
        this.ignoreFieldVisibility(true);
        return this;
    }

    public FastClasspathScanner enableFieldTypeIndexing(boolean enableFieldTypeIndexing) {
        this.getScanSpec().enableFieldTypeIndexing = enableFieldTypeIndexing;
        return this;
    }

    public FastClasspathScanner enableFieldTypeIndexing() {
        this.enableFieldTypeIndexing(true);
        return this;
    }

    public FastClasspathScanner strictWhitelist(boolean strictWhitelist) {
        this.getScanSpec().strictWhitelist = strictWhitelist;
        return this;
    }

    public FastClasspathScanner strictWhitelist() {
        this.strictWhitelist(true);
        return this;
    }

    public synchronized FastClasspathScanner registerClassLoaderHandler(Class<? extends ClassLoaderHandler> classLoaderHandlerClass) {
        this.getScanSpec().extraClassLoaderHandlers.add(classLoaderHandlerClass);
        return this;
    }

    public synchronized FastClasspathScanner overrideClasspath(String classpath) {
        this.getScanSpec().overrideClasspath = classpath;
        return this;
    }

    public synchronized FastClasspathScanner matchAllClasses(ClassMatchProcessor classMatchProcessor) {
        this.getScanSpec().matchAllClasses(classMatchProcessor);
        return this;
    }

    public synchronized FastClasspathScanner matchAllStandardClasses(ClassMatchProcessor classMatchProcessor) {
        this.getScanSpec().matchAllStandardClasses(classMatchProcessor);
        return this;
    }

    public synchronized FastClasspathScanner matchAllInterfaceClasses(ClassMatchProcessor ClassMatchProcessor2) {
        this.getScanSpec().matchAllInterfaceClasses(ClassMatchProcessor2);
        return this;
    }

    public synchronized FastClasspathScanner matchAllAnnotationClasses(ClassMatchProcessor ClassMatchProcessor2) {
        this.getScanSpec().matchAllAnnotationClasses(ClassMatchProcessor2);
        return this;
    }

    public synchronized <T> FastClasspathScanner matchSubclassesOf(Class<T> superclass, SubclassMatchProcessor<T> subclassMatchProcessor) {
        this.getScanSpec().matchSubclassesOf(superclass, subclassMatchProcessor);
        return this;
    }

    public synchronized <T> FastClasspathScanner matchSubinterfacesOf(Class<T> superinterface, SubinterfaceMatchProcessor<T> subinterfaceMatchProcessor) {
        this.getScanSpec().matchSubinterfacesOf(superinterface, subinterfaceMatchProcessor);
        return this;
    }

    public synchronized <T> FastClasspathScanner matchClassesImplementing(Class<T> implementedInterface, ImplementingClassMatchProcessor<T> interfaceMatchProcessor) {
        this.getScanSpec().matchClassesImplementing(implementedInterface, interfaceMatchProcessor);
        return this;
    }

    public synchronized <T> FastClasspathScanner matchClassesWithFieldOfType(Class<T> fieldType, ClassMatchProcessor classMatchProcessor) {
        this.enableFieldTypeIndexing();
        this.getScanSpec().matchClassesWithFieldOfType(fieldType, classMatchProcessor);
        return this;
    }

    public synchronized FastClasspathScanner matchClassesWithAnnotation(Class<?> annotation, ClassAnnotationMatchProcessor classAnnotationMatchProcessor) {
        this.getScanSpec().matchClassesWithAnnotation(annotation, classAnnotationMatchProcessor);
        return this;
    }

    public synchronized FastClasspathScanner matchStaticFinalFieldNames(Set<String> fullyQualifiedStaticFinalFieldNames, StaticFinalFieldMatchProcessor staticFinalFieldMatchProcessor) {
        this.getScanSpec().matchStaticFinalFieldNames(fullyQualifiedStaticFinalFieldNames, staticFinalFieldMatchProcessor);
        return this;
    }

    public synchronized FastClasspathScanner matchStaticFinalFieldNames(String fullyQualifiedStaticFinalFieldName, StaticFinalFieldMatchProcessor staticFinalFieldMatchProcessor) {
        this.getScanSpec().matchStaticFinalFieldNames(fullyQualifiedStaticFinalFieldName, staticFinalFieldMatchProcessor);
        return this;
    }

    public synchronized FastClasspathScanner matchStaticFinalFieldNames(String[] fullyQualifiedStaticFinalFieldNames, StaticFinalFieldMatchProcessor staticFinalFieldMatchProcessor) {
        this.getScanSpec().matchStaticFinalFieldNames(fullyQualifiedStaticFinalFieldNames, staticFinalFieldMatchProcessor);
        return this;
    }

    public synchronized FastClasspathScanner matchFilenamePattern(String pathRegexp, FileMatchProcessor fileMatchProcessor) {
        this.getScanSpec().matchFilenamePattern(pathRegexp, fileMatchProcessor);
        return this;
    }

    public synchronized FastClasspathScanner matchFilenamePattern(String pathRegexp, FileMatchContentsProcessor fileMatchContentsProcessor) {
        this.getScanSpec().matchFilenamePattern(pathRegexp, fileMatchContentsProcessor);
        return this;
    }

    public synchronized FastClasspathScanner matchFilenamePattern(String pathRegexp, FileMatchProcessorWithContext fileMatchProcessorWithContext) {
        this.getScanSpec().matchFilenamePattern(pathRegexp, fileMatchProcessorWithContext);
        return this;
    }

    public synchronized FastClasspathScanner matchFilenamePattern(String pathRegexp, FileMatchContentsProcessorWithContext fileMatchContentsProcessorWithContext) {
        this.getScanSpec().matchFilenamePattern(pathRegexp, fileMatchContentsProcessorWithContext);
        return this;
    }

    public synchronized FastClasspathScanner matchFilenamePath(String relativePathToMatch, FileMatchProcessor fileMatchProcessor) {
        this.getScanSpec().matchFilenamePath(relativePathToMatch, fileMatchProcessor);
        return this;
    }

    public synchronized FastClasspathScanner matchFilenamePath(String relativePathToMatch, FileMatchContentsProcessor fileMatchContentsProcessor) {
        this.getScanSpec().matchFilenamePath(relativePathToMatch, fileMatchContentsProcessor);
        return this;
    }

    public synchronized FastClasspathScanner matchFilenamePath(String relativePathToMatch, FileMatchProcessorWithContext fileMatchProcessorWithContext) {
        this.getScanSpec().matchFilenamePath(relativePathToMatch, fileMatchProcessorWithContext);
        return this;
    }

    public synchronized FastClasspathScanner matchFilenamePath(String relativePathToMatch, FileMatchContentsProcessorWithContext fileMatchContentsProcessorWithContext) {
        this.getScanSpec().matchFilenamePath(relativePathToMatch, fileMatchContentsProcessorWithContext);
        return this;
    }

    public synchronized FastClasspathScanner matchFilenamePathLeaf(String pathLeafToMatch, FileMatchProcessor fileMatchProcessor) {
        this.getScanSpec().matchFilenamePathLeaf(pathLeafToMatch, fileMatchProcessor);
        return this;
    }

    public synchronized FastClasspathScanner matchFilenamePathLeaf(String pathLeafToMatch, FileMatchContentsProcessor fileMatchContentsProcessor) {
        this.getScanSpec().matchFilenamePathLeaf(pathLeafToMatch, fileMatchContentsProcessor);
        return this;
    }

    public synchronized FastClasspathScanner matchFilenamePathLeaf(String pathLeafToMatch, FileMatchProcessorWithContext fileMatchProcessorWithContext) {
        this.getScanSpec().matchFilenamePathLeaf(pathLeafToMatch, fileMatchProcessorWithContext);
        return this;
    }

    public synchronized FastClasspathScanner matchFilenamePathLeaf(String pathLeafToMatch, FileMatchContentsProcessorWithContext fileMatchContentsProcessorWithContext) {
        this.getScanSpec().matchFilenamePathLeaf(pathLeafToMatch, fileMatchContentsProcessorWithContext);
        return this;
    }

    public synchronized FastClasspathScanner matchFilenameExtension(String extensionToMatch, FileMatchProcessor fileMatchProcessor) {
        this.getScanSpec().matchFilenameExtension(extensionToMatch, fileMatchProcessor);
        return this;
    }

    public synchronized FastClasspathScanner matchFilenameExtension(String extensionToMatch, FileMatchContentsProcessor fileMatchContentsProcessor) {
        this.getScanSpec().matchFilenameExtension(extensionToMatch, fileMatchContentsProcessor);
        return this;
    }

    public synchronized FastClasspathScanner matchFilenameExtension(String extensionToMatch, FileMatchProcessorWithContext fileMatchProcessorWithContext) {
        this.getScanSpec().matchFilenameExtension(extensionToMatch, fileMatchProcessorWithContext);
        return this;
    }

    public synchronized FastClasspathScanner matchFilenameExtension(String extensionToMatch, FileMatchContentsProcessorWithContext fileMatchContentsProcessorWithContext) {
        this.getScanSpec().matchFilenameExtension(extensionToMatch, fileMatchContentsProcessorWithContext);
        return this;
    }

    public synchronized Future<ScanResult> scanAsync(ExecutorService executorService, int numParallelTasks) {
        return executorService.submit(new Scanner(this.getScanSpec(), executorService, numParallelTasks, true, this.log));
    }

    public synchronized ScanResult scan(ExecutorService executorService, int numParallelTasks) {
        try {
            return this.scanAsync(executorService, numParallelTasks).get();
        }
        catch (InterruptedException e) {
            throw new ScanInterruptedException();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof InterruptedException) {
                throw new ScanInterruptedException();
            }
            throw new RuntimeException(e.getCause());
        }
    }

    public synchronized ScanResult scan(int numThreads) {
        try (AutoCloseableExecutorService executorService = new AutoCloseableExecutorService(numThreads);){
            ScanResult scanResult = this.scan(executorService, numThreads);
            return scanResult;
        }
    }

    public synchronized ScanResult scan() {
        return this.scan(6);
    }

    public Future<List<File>> getUniqueClasspathElementsAsync(ExecutorService executorService, int numParallelTasks) {
        final Future<ScanResult> scanResult = executorService.submit(new Scanner(this.getScanSpec(), executorService, numParallelTasks, false, this.log == null ? null : this.log.log("Getting unique classpath elements")));
        Future<List<File>> future = executorService.submit(new Callable<List<File>>(){

            @Override
            public List<File> call() throws Exception {
                if (FastClasspathScanner.this.log != null) {
                    FastClasspathScanner.this.log.log("Getting classpath elements");
                }
                return ((ScanResult)scanResult.get()).getUniqueClasspathElements();
            }
        });
        if (this.log != null) {
            this.log.flush();
        }
        return future;
    }

    public List<File> getUniqueClasspathElements(ExecutorService executorService, int numParallelTasks) {
        if (this.classpathElts == null) {
            try {
                this.classpathElts = this.getUniqueClasspathElementsAsync(executorService, numParallelTasks).get();
            }
            catch (InterruptedException e) {
                if (this.log != null) {
                    this.log.log("Thread interrupted while getting classpath elements");
                }
                throw new ScanInterruptedException();
            }
            catch (ExecutionException e) {
                if (this.log != null) {
                    this.log.log("Exception while getting classpath elements", e);
                }
                throw new RuntimeException(e.getCause());
            }
            if (this.log != null) {
                this.log.flush();
            }
        }
        return this.classpathElts;
    }

    public List<File> getUniqueClasspathElements() {
        if (this.classpathElts == null) {
            try (AutoCloseableExecutorService executorService = new AutoCloseableExecutorService(6);){
                List<File> list = this.getUniqueClasspathElements(executorService, 6);
                return list;
            }
        }
        return this.classpathElts;
    }
}

