/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.utils;

import io.github.lukehutch.fastclasspathscanner.utils.InterruptionChecker;
import io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;

public class WorkQueue<T>
implements AutoCloseable {
    private final WorkUnitProcessor<T> workUnitProcessor;
    private final ConcurrentLinkedQueue<T> workQueue = new ConcurrentLinkedQueue();
    private final AtomicInteger numWorkUnitsRemaining = new AtomicInteger();
    private final ConcurrentLinkedQueue<Future<?>> workerFutures = new ConcurrentLinkedQueue();
    private final InterruptionChecker interruptionChecker;
    private final LogNode log;

    private WorkQueue(WorkUnitProcessor<T> workUnitProcesor, InterruptionChecker interruptionChecker, LogNode log) {
        this.workUnitProcessor = workUnitProcesor;
        this.interruptionChecker = interruptionChecker;
        this.log = log;
    }

    public WorkQueue(Collection<T> initialWorkUnits, WorkUnitProcessor<T> workUnitProcesor, InterruptionChecker interruptionChecker, LogNode log) {
        this(workUnitProcesor, interruptionChecker, log);
        this.addWorkUnits(initialWorkUnits);
    }

    public void startWorkers(ExecutorService executorService, int numWorkers, LogNode log) {
        for (int i = 0; i < numWorkers; ++i) {
            this.workerFutures.add(executorService.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    WorkQueue.this.runWorkLoop();
                    return null;
                }
            }));
        }
    }

    public void runWorkLoop() throws InterruptedException, ExecutionException {
        while (this.numWorkUnitsRemaining.get() > 0) {
            Object workUnit = null;
            while (this.numWorkUnitsRemaining.get() > 0) {
                this.interruptionChecker.check();
                workUnit = this.workQueue.poll();
                if (workUnit == null) continue;
            }
            if (workUnit == null) {
                return;
            }
            try {
                this.workUnitProcessor.processWorkUnit(workUnit);
            }
            catch (InterruptedException e) {
                this.interruptionChecker.interrupt();
                throw e;
            }
            catch (Exception e) {
                if (this.log != null) {
                    this.log.log("Exception in worker thread", e);
                }
                throw this.interruptionChecker.executionException(e);
            }
            finally {
                this.numWorkUnitsRemaining.decrementAndGet();
            }
        }
    }

    private void addWorkUnit(T workUnit) {
        this.numWorkUnitsRemaining.incrementAndGet();
        this.workQueue.add(workUnit);
    }

    public void addWorkUnits(Collection<T> workUnits) {
        for (T workUnit : workUnits) {
            this.addWorkUnit(workUnit);
        }
    }

    @Override
    public void close() throws ExecutionException {
        Future<?> future;
        boolean uncompletedWork = false;
        if (this.numWorkUnitsRemaining.get() > 0) {
            uncompletedWork = true;
        }
        while ((future = this.workerFutures.poll()) != null) {
            try {
                if (uncompletedWork) {
                    future.cancel(true);
                }
                future.get();
            }
            catch (InterruptedException | CancellationException exception) {
            }
            catch (ExecutionException e) {
                if (this.log != null) {
                    this.log.log("Closed work queue because worker thread threw exception", e);
                }
                this.interruptionChecker.executionException(e);
            }
        }
        if (uncompletedWork) {
            throw new RuntimeException("Called close() before completing all work units");
        }
    }

    public static interface WorkUnitProcessor<T> {
        public void processWorkUnit(T var1) throws Exception;
    }
}

