/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathRelativePathToElementMap;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import io.github.lukehutch.fastclasspathscanner.utils.FastManifestParser;
import io.github.lukehutch.fastclasspathscanner.utils.FastPathResolver;
import io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;

class ClasspathRelativePath {
    private final String pathToResolveAgainst;
    private final String relativePath;
    private String resolvedPathCached;
    private boolean resolvedPathIsCached;
    private File fileCached;
    private boolean fileIsCached;
    private String canonicalPathCached;
    private boolean canonicalPathIsCached;
    private boolean isFileCached;
    private boolean isFileIsCached;
    private boolean isDirectoryCached;
    private boolean isDirectoryIsCached;
    private boolean existsCached;
    private boolean existsIsCached;

    public ClasspathRelativePath(String pathToResolveAgainst, String relativePath) {
        this.pathToResolveAgainst = pathToResolveAgainst;
        this.relativePath = relativePath;
    }

    public int hashCode() {
        try {
            return this.getCanonicalPath().hashCode();
        }
        catch (IOException e) {
            return 0;
        }
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof ClasspathRelativePath)) {
            return false;
        }
        ClasspathRelativePath other = (ClasspathRelativePath)o;
        try {
            String thisCp = this.getCanonicalPath();
            String otherCp = other.getCanonicalPath();
            if (thisCp == null || otherCp == null) {
                return false;
            }
            return thisCp.equals(otherCp);
        }
        catch (IOException e) {
            return false;
        }
    }

    public String toString() {
        try {
            return this.getCanonicalPath();
        }
        catch (IOException e) {
            return this.getResolvedPath();
        }
    }

    public String getResolvedPath() {
        if (!this.resolvedPathIsCached) {
            this.resolvedPathCached = FastPathResolver.resolve(this.pathToResolveAgainst, this.relativePath);
            this.resolvedPathIsCached = true;
        }
        return this.resolvedPathCached;
    }

    public File getFile() throws IOException {
        if (!this.fileIsCached) {
            String path = this.getResolvedPath();
            if (path == null) {
                throw new IOException("Path " + this.relativePath + " could not be resolved relative to " + this.pathToResolveAgainst);
            }
            this.fileCached = new File(path).getCanonicalFile();
            this.fileIsCached = true;
        }
        return this.fileCached;
    }

    public String getCanonicalPath() throws IOException {
        if (!this.canonicalPathIsCached) {
            File file = this.getFile();
            this.canonicalPathCached = file.getPath();
            this.canonicalPathIsCached = true;
        }
        return this.canonicalPathCached;
    }

    public boolean isFile() throws IOException {
        if (!this.isFileIsCached) {
            this.isFileCached = this.getFile().isFile();
            this.isFileIsCached = true;
        }
        return this.isFileCached;
    }

    public boolean isDirectory() throws IOException {
        if (!this.isDirectoryIsCached) {
            this.isDirectoryCached = this.getFile().isDirectory();
            this.isDirectoryIsCached = true;
        }
        return this.isDirectoryCached;
    }

    public static boolean isClassfile(String path) {
        int len = path.length();
        return len > 6 && path.regionMatches(true, len - 6, ".class", 0, 6);
    }

    public boolean isClassfile() {
        return ClasspathRelativePath.isClassfile(this.getResolvedPath());
    }

    private boolean exists() throws IOException {
        if (!this.existsIsCached) {
            this.existsCached = this.getFile().exists();
            this.existsIsCached = true;
        }
        return this.existsCached;
    }

    private static boolean isJar(String path) {
        int len = path.length();
        int extIdx = len - 3;
        return len > 4 && path.charAt(len - 4) == '.' && (path.regionMatches(true, extIdx, "jar", 0, 3) || path.regionMatches(true, extIdx, "zip", 0, 3) || path.regionMatches(true, extIdx, "war", 0, 3) || path.regionMatches(true, extIdx, "car", 0, 3));
    }

    private static boolean isJREJar(File file, int ancestralScanDepth, ConcurrentHashMap<String, String> knownJREPaths, ConcurrentHashMap<String, String> knownNonJREPaths, LogNode log) {
        if (ancestralScanDepth == 0) {
            return false;
        }
        File parent = file.getParentFile();
        if (parent == null) {
            return false;
        }
        String parentPathStr = parent.getPath();
        if (knownJREPaths.containsKey(parentPathStr)) {
            return true;
        }
        if (knownNonJREPaths.containsKey(parentPathStr)) {
            return false;
        }
        File rt = new File(parent, "jre/lib/rt.jar");
        if (!rt.exists() && !(rt = new File(parent, "lib/rt.jar")).exists()) {
            rt = new File(parent, "rt.jar");
        }
        boolean isJREJar = false;
        if (rt.exists()) {
            FastManifestParser manifest = new FastManifestParser(rt, log);
            if (manifest.isSystemJar) {
                isJREJar = true;
            }
        }
        if (!isJREJar) {
            isJREJar = ClasspathRelativePath.isJREJar(parent, ancestralScanDepth - 1, knownJREPaths, knownNonJREPaths, log);
        }
        if (!isJREJar) {
            knownNonJREPaths.put(parentPathStr, parentPathStr);
        } else {
            knownJREPaths.put(parentPathStr, parentPathStr);
        }
        return isJREJar;
    }

    public boolean isValid(ScanSpec scanSpec, ConcurrentHashMap<String, String> knownJREPaths, ConcurrentHashMap<String, String> knownNonJREPaths, ClasspathRelativePathToElementMap classpathElementMap, LogNode log) throws InterruptedException {
        String path = this.getResolvedPath();
        if (path == null) {
            if (log != null) {
                log.log("Ignoring non-local classpath element: " + this.relativePath);
            }
            return false;
        }
        if (classpathElementMap.get(this) != null) {
            if (log != null) {
                log.log("Ignoring duplicate classpath element: " + path);
            }
            return false;
        }
        try {
            boolean isDirectory;
            if (!this.exists()) {
                if (log != null) {
                    log.log("Classpath element does not exist: " + path);
                }
                return false;
            }
            boolean isFile = this.isFile();
            if (isFile != !(isDirectory = this.isDirectory())) {
                if (log != null) {
                    log.log("Ignoring invalid classpath element: " + path);
                }
                return false;
            }
            if (isFile) {
                if (!ClasspathRelativePath.isJar(this.getResolvedPath())) {
                    if (log != null) {
                        log.log("Ignoring non-jar file on classpath: " + path);
                    }
                    return false;
                }
                if (!scanSpec.scanJars) {
                    if (log != null) {
                        log.log("Ignoring jarfile, as jars are not being scanned: " + path);
                    }
                    return false;
                }
                if (scanSpec.blacklistSystemJars() && ClasspathRelativePath.isJREJar(this.getFile(), 2, knownJREPaths, knownNonJREPaths, log)) {
                    if (log != null) {
                        log.log("Ignoring JRE jar: " + path);
                    }
                    return false;
                }
                if (!scanSpec.jarIsWhitelisted(this.getFile().getName())) {
                    if (log != null) {
                        log.log("Ignoring jarfile that did not match whitelist/blacklist criteria: " + path);
                    }
                    return false;
                }
            } else if (!scanSpec.scanDirs) {
                if (log != null) {
                    log.log("Ignoring directory, as directories are not being scanned: " + path);
                }
                return false;
            }
        }
        catch (IOException e) {
            if (log != null) {
                log.log("Could not canonicalize path: " + path);
            }
            return false;
        }
        return true;
    }
}

