/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.classloaderhandler.ClassLoaderHandler;
import io.github.lukehutch.fastclasspathscanner.classloaderhandler.EquinoxClassLoaderHandler;
import io.github.lukehutch.fastclasspathscanner.classloaderhandler.JBossClassLoaderHandler;
import io.github.lukehutch.fastclasspathscanner.classloaderhandler.WeblogicClassLoaderHandler;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import io.github.lukehutch.fastclasspathscanner.utils.AdditionOrderedSet;
import io.github.lukehutch.fastclasspathscanner.utils.Join;
import io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ClasspathFinder {
    private final List<String> rawClasspathElements = new ArrayList<String>();
    private static CallerResolver CALLER_RESOLVER;
    private final List<ClassLoaderHandler> defaultClassLoaderHandlers = Arrays.asList(new EquinoxClassLoaderHandler(), new JBossClassLoaderHandler(), new WeblogicClassLoaderHandler());

    public void addClasspathElement(String pathElement) {
        this.rawClasspathElements.add(pathElement);
    }

    public void addClasspathElements(String pathStr) {
        if (pathStr != null && !pathStr.isEmpty()) {
            for (String pathElement : pathStr.split(File.pathSeparator)) {
                this.addClasspathElement(pathElement);
            }
        }
    }

    private static void addAllParentClassloaders(ClassLoader classLoader, AdditionOrderedSet<ClassLoader> classLoadersSetOut) {
        ArrayList<ClassLoader> callerClassLoaders = new ArrayList<ClassLoader>();
        for (ClassLoader cl = classLoader; cl != null; cl = cl.getParent()) {
            callerClassLoaders.add(cl);
        }
        for (int i = callerClassLoaders.size() - 1; i >= 0; --i) {
            classLoadersSetOut.add((ClassLoader)callerClassLoaders.get(i));
        }
    }

    private static void addAllParentClassloaders(Class<?> klass, AdditionOrderedSet<ClassLoader> classLoadersSetOut) {
        ClasspathFinder.addAllParentClassloaders(klass.getClassLoader(), classLoadersSetOut);
    }

    ClasspathFinder(ScanSpec scanSpec, LogNode log) {
        if (scanSpec.overrideClasspath != null) {
            this.addClasspathElements(scanSpec.overrideClasspath);
        } else {
            AdditionOrderedSet<ClassLoader> classLoadersSet = new AdditionOrderedSet<ClassLoader>();
            ClasspathFinder.addAllParentClassloaders(ClassLoader.getSystemClassLoader(), classLoadersSet);
            if (CALLER_RESOLVER != null) {
                Class<?>[] callStack;
                for (Class<?> callStackClass : callStack = CALLER_RESOLVER.getClassContext()) {
                    ClasspathFinder.addAllParentClassloaders(callStackClass, classLoadersSet);
                }
            } else if (log != null) {
                log.log(ClasspathFinder.class.getSimpleName() + " could not create " + CallerResolver.class.getSimpleName() + ", current SecurityManager does not grant RuntimePermission(\"createSecurityManager\")");
            }
            ClasspathFinder.addAllParentClassloaders(Thread.currentThread().getContextClassLoader(), classLoadersSet);
            ClasspathFinder.addAllParentClassloaders(ClasspathFinder.class, classLoadersSet);
            List<ClassLoader> classLoaders = classLoadersSet.getList();
            classLoaders.remove(null);
            ArrayList<ClassLoaderHandler> classLoaderHandlers = new ArrayList<ClassLoaderHandler>();
            classLoaderHandlers.add(new URLClassLoaderHandler());
            classLoaderHandlers.addAll(this.defaultClassLoaderHandlers);
            classLoaderHandlers.addAll(scanSpec.extraClassLoaderHandlers);
            if (log != null && !classLoaderHandlers.isEmpty()) {
                ArrayList<String> classLoaderHandlerNames = new ArrayList<String>();
                for (ClassLoaderHandler classLoaderHandler : classLoaderHandlers) {
                    classLoaderHandlerNames.add(classLoaderHandler.getClass().getName());
                }
                log.log("ClassLoaderHandlers loaded: " + Join.join(", ", classLoaderHandlerNames));
            }
            for (ClassLoader classLoader : classLoaders) {
                boolean classloaderFound = false;
                for (ClassLoaderHandler handler : classLoaderHandlers) {
                    try {
                        if (!handler.handle(classLoader, this)) continue;
                        if (log != null) {
                            log.log("Classpath elements from ClassLoader " + classLoader.getClass().getName() + " were extracted by ClassLoaderHandler " + handler.getClass().getName());
                        }
                        classloaderFound = true;
                        break;
                    }
                    catch (Exception e) {
                        if (log == null) continue;
                        log.log("Exception in " + classLoader.getClass().getName() + ": " + e.toString());
                    }
                }
                if (classloaderFound || log == null) continue;
                log.log("Found unknown ClassLoader type, cannot scan classes: " + classLoader.getClass().getName());
            }
            this.addClasspathElements(System.getProperty("java.class.path"));
        }
    }

    public List<String> getRawClasspathElements() {
        return this.rawClasspathElements;
    }

    static {
        try {
            CALLER_RESOLVER = new CallerResolver();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private static class URLClassLoaderHandler
    implements ClassLoaderHandler {
        private URLClassLoaderHandler() {
        }

        @Override
        public boolean handle(ClassLoader classloader, ClasspathFinder classpathFinder) {
            if (classloader instanceof URLClassLoader) {
                URL[] urls = ((URLClassLoader)classloader).getURLs();
                if (urls != null) {
                    for (URL url : urls) {
                        if (url == null) continue;
                        classpathFinder.addClasspathElement(url.toString());
                    }
                }
                return true;
            }
            return false;
        }
    }

    private static final class CallerResolver
    extends SecurityManager {
        private CallerResolver() {
        }

        @Override
        protected Class<?>[] getClassContext() {
            return super.getClassContext();
        }
    }
}

