/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.utils;

import io.github.lukehutch.fastclasspathscanner.FastClasspathScanner;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;

public class ThreadLog {
    private static AtomicBoolean versionLogged = new AtomicBoolean(false);
    private final Queue<ThreadLogEntry> logEntries = new ConcurrentLinkedQueue<ThreadLogEntry>();
    private SimpleDateFormat dateTimeFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mmX");
    private DecimalFormat nanoFormatter = new DecimalFormat("0.000000");

    public void log(int indentLevel, String msg) {
        this.logEntries.add(new ThreadLogEntry(indentLevel, msg));
    }

    public void log(String msg) {
        this.logEntries.add(new ThreadLogEntry(0, msg));
    }

    public void log(int indentLevel, String msg, long elapsedTimeNanos) {
        this.logEntries.add(new ThreadLogEntry(indentLevel, msg, elapsedTimeNanos));
    }

    public void log(String msg, long elapsedTimeNanos) {
        this.logEntries.add(new ThreadLogEntry(0, msg, elapsedTimeNanos));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        if (versionLogged.compareAndSet(false, true) && FastClasspathScanner.verbose) {
            this.log("FastClasspathScanner version " + FastClasspathScanner.getVersion());
        }
        if (!this.logEntries.isEmpty()) {
            SimpleDateFormat simpleDateFormat = this.dateTimeFormatter;
            synchronized (simpleDateFormat) {
                StringBuilder buf = new StringBuilder();
                for (ThreadLogEntry logEntry : this.logEntries) {
                    buf.append(this.dateTimeFormatter.format(logEntry.time));
                    buf.append('\t');
                    buf.append(FastClasspathScanner.class.getSimpleName());
                    buf.append('\t');
                    int numIndentChars = 2 * logEntry.indentLevel;
                    for (int i = 0; i < numIndentChars - 1; ++i) {
                        buf.append('-');
                    }
                    if (numIndentChars > 0) {
                        buf.append(" ");
                    }
                    buf.append(logEntry.msg);
                    if (logEntry.elapsedTimeNanos >= 0L) {
                        buf.append(" in ");
                        buf.append(this.nanoFormatter.format(logEntry.elapsedTimeNanos));
                    }
                    buf.append('\n');
                }
                System.err.println(buf.toString());
                System.err.flush();
                this.logEntries.clear();
            }
        }
    }

    private static class ThreadLogEntry {
        private final int indentLevel;
        private final Date time;
        private final String msg;
        private final long elapsedTimeNanos;

        public ThreadLogEntry(int indentLevel, String msg, long elapsedTimeNanos) {
            this.indentLevel = indentLevel;
            this.msg = msg;
            this.time = Calendar.getInstance().getTime();
            this.elapsedTimeNanos = elapsedTimeNanos;
        }

        public ThreadLogEntry(int indentLevel, String msg) {
            this(indentLevel, msg, -1L);
        }
    }
}

