/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.FastClasspathScanner;
import io.github.lukehutch.fastclasspathscanner.classpath.ClasspathFinder;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathResource;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import io.github.lukehutch.fastclasspathscanner.utils.ThreadLog;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class RecursiveScanner
implements Callable<Void> {
    private final ClasspathFinder classpathFinder;
    private final ScanSpec scanSpec;
    private final AtomicInteger numDirsScanned = new AtomicInteger();
    private final AtomicInteger numJarfileDirsScanned = new AtomicInteger();
    private final AtomicInteger numFilesScanned = new AtomicInteger();
    private final AtomicInteger numJarfileFilesScanned = new AtomicInteger();
    private final AtomicInteger numJarfilesScanned = new AtomicInteger();
    private final AtomicInteger numClassfilesScanned = new AtomicInteger();
    private final LinkedBlockingQueue<ClasspathResource> matchingFiles;
    private final LinkedBlockingQueue<ClasspathResource> matchingClassfiles;
    private final Map<File, Long> fileToTimestamp;
    private final int numWorkerThreads;
    private final ThreadLog log;
    private boolean interrupted = false;
    private final Set<String> previouslyScannedCanonicalPaths = new HashSet<String>();
    private final Set<String> previouslyScannedRelativePaths = new HashSet<String>();

    public RecursiveScanner(ClasspathFinder classpathFinder, ScanSpec scanSpec, LinkedBlockingQueue<ClasspathResource> matchingFiles, LinkedBlockingQueue<ClasspathResource> matchingClassfiles, Map<File, Long> fileToTimestamp, int numWorkerThreads, ThreadLog log) {
        this.classpathFinder = classpathFinder;
        this.scanSpec = scanSpec;
        this.matchingFiles = matchingFiles;
        this.matchingClassfiles = matchingClassfiles;
        this.fileToTimestamp = fileToTimestamp;
        this.numWorkerThreads = numWorkerThreads;
        this.log = log;
    }

    private boolean previouslyScanned(File fileOrDir) {
        try {
            return !this.previouslyScannedCanonicalPaths.add(fileOrDir.getCanonicalPath());
        }
        catch (IOException | SecurityException e) {
            return true;
        }
    }

    private boolean previouslyScanned(String relativePath) {
        return !this.previouslyScannedRelativePaths.add(relativePath);
    }

    private void scanDir(File classpathElt, File dir, int ignorePrefixLen, boolean inWhitelistedPath) {
        File[] filesInDir;
        String dirPath;
        String dirRelativePath;
        ScanSpec.ScanSpecPathMatch matchStatus;
        if (FastClasspathScanner.verbose) {
            this.log.log(3, "Scanning directory: " + dir);
        }
        if ((matchStatus = this.scanSpec.pathWhitelistMatchStatus(dirRelativePath = ignorePrefixLen > (dirPath = dir.getPath()).length() ? "/" : dirPath.substring(ignorePrefixLen).replace(File.separatorChar, '/') + "/")) == ScanSpec.ScanSpecPathMatch.NOT_WITHIN_WHITELISTED_PATH || matchStatus == ScanSpec.ScanSpecPathMatch.WITHIN_BLACKLISTED_PATH) {
            if (FastClasspathScanner.verbose) {
                this.log.log(3, "Reached non-whitelisted (or blacklisted) directory: " + dirRelativePath);
            }
            return;
        }
        if (matchStatus == ScanSpec.ScanSpecPathMatch.WITHIN_WHITELISTED_PATH) {
            inWhitelistedPath = true;
        }
        if ((filesInDir = dir.listFiles()) == null) {
            if (FastClasspathScanner.verbose) {
                this.log.log(4, "Invalid directory " + dir);
            }
            return;
        }
        long startTime = System.nanoTime();
        for (File fileInDir : filesInDir) {
            String fileInDirRelativePath;
            if (this.interrupted |= Thread.currentThread().isInterrupted()) {
                return;
            }
            if (fileInDir.isDirectory()) {
                if (!inWhitelistedPath && matchStatus != ScanSpec.ScanSpecPathMatch.ANCESTOR_OF_WHITELISTED_PATH) continue;
                this.scanDir(classpathElt, fileInDir, ignorePrefixLen, inWhitelistedPath);
                continue;
            }
            if (!fileInDir.isFile()) continue;
            String string = fileInDirRelativePath = dirRelativePath.isEmpty() || "/".equals(dirRelativePath) ? fileInDir.getName() : dirRelativePath + fileInDir.getName();
            if (!inWhitelistedPath && (matchStatus != ScanSpec.ScanSpecPathMatch.AT_WHITELISTED_CLASS_PACKAGE || !this.scanSpec.isSpecificallyWhitelistedClass(fileInDirRelativePath))) continue;
            boolean subFilePreviouslyScannedCanonical = this.previouslyScanned(fileInDir);
            boolean subFilePreviouslyScannedRelative = this.previouslyScanned(fileInDirRelativePath);
            if (subFilePreviouslyScannedRelative || subFilePreviouslyScannedCanonical) {
                if (!FastClasspathScanner.verbose) continue;
                this.log.log(3, "Reached duplicate path, ignoring: " + fileInDirRelativePath);
                continue;
            }
            if (FastClasspathScanner.verbose) {
                this.log.log(3, "Found whitelisted file: " + fileInDirRelativePath);
            }
            boolean matchedFile = false;
            if (fileInDirRelativePath.endsWith(".class")) {
                this.matchingClassfiles.add(new ClasspathResource(classpathElt, false, fileInDirRelativePath));
                this.numClassfilesScanned.incrementAndGet();
                matchedFile = true;
            }
            for (ScanSpec.FilePathTesterAndMatchProcessorWrapper fileMatcher : this.scanSpec.getFilePathTestersAndMatchProcessorWrappers()) {
                if (!fileMatcher.filePathTester.filePathMatches(classpathElt, fileInDirRelativePath)) continue;
                this.matchingFiles.add(new ClasspathResource(classpathElt, false, fileInDirRelativePath, fileMatcher.fileMatchProcessorWrapper));
                matchedFile = true;
            }
            if (!matchedFile) continue;
            this.numFilesScanned.incrementAndGet();
            this.fileToTimestamp.put(fileInDir, fileInDir.lastModified());
        }
        this.numDirsScanned.incrementAndGet();
        if (FastClasspathScanner.verbose) {
            this.log.log(3, "Scanned directory " + dir + " and subdirectories", System.nanoTime() - startTime);
        }
    }

    private void scanZipfile(File classpathElt, ZipFile zipFile) {
        if (FastClasspathScanner.verbose) {
            this.log.log(3, "Scanning jarfile: " + classpathElt);
        }
        long startTime = System.nanoTime();
        String prevParentRelativePath = null;
        ScanSpec.ScanSpecPathMatch prevParentMatchStatus = null;
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            boolean isDir;
            if (this.interrupted |= Thread.currentThread().isInterrupted()) {
                return;
            }
            ZipEntry zipEntry = entries.nextElement();
            String relativePath = zipEntry.getName();
            if (relativePath.startsWith("/")) {
                relativePath = relativePath.substring(1);
            }
            if (isDir = zipEntry.isDirectory()) continue;
            if (this.previouslyScanned(relativePath)) {
                if (!FastClasspathScanner.verbose) continue;
                this.log.log(3, "Reached duplicate relative path, ignoring: " + relativePath);
                continue;
            }
            int lastSlashIdx = relativePath.lastIndexOf("/");
            String parentRelativePath = lastSlashIdx < 0 ? "/" : relativePath.substring(0, lastSlashIdx + 1);
            boolean parentRelativePathChanged = !parentRelativePath.equals(prevParentRelativePath);
            ScanSpec.ScanSpecPathMatch parentMatchStatus = prevParentRelativePath == null || parentRelativePathChanged ? this.scanSpec.pathWhitelistMatchStatus(parentRelativePath) : prevParentMatchStatus;
            prevParentRelativePath = parentRelativePath;
            prevParentMatchStatus = parentMatchStatus;
            if (parentRelativePathChanged) {
                this.numJarfileDirsScanned.incrementAndGet();
            }
            if (parentMatchStatus != ScanSpec.ScanSpecPathMatch.WITHIN_WHITELISTED_PATH && (parentMatchStatus != ScanSpec.ScanSpecPathMatch.AT_WHITELISTED_CLASS_PACKAGE || !this.scanSpec.isSpecificallyWhitelistedClass(relativePath))) continue;
            if (FastClasspathScanner.verbose) {
                this.log.log(3, "Found whitelisted file in jarfile: " + relativePath);
            }
            boolean matchedFile = false;
            if (relativePath.endsWith(".class")) {
                this.matchingClassfiles.add(new ClasspathResource(classpathElt, true, relativePath));
                this.numClassfilesScanned.incrementAndGet();
                matchedFile = true;
            }
            for (ScanSpec.FilePathTesterAndMatchProcessorWrapper fileMatcher : this.scanSpec.getFilePathTestersAndMatchProcessorWrappers()) {
                if (!fileMatcher.filePathTester.filePathMatches(classpathElt, relativePath)) continue;
                this.matchingFiles.add(new ClasspathResource(classpathElt, true, relativePath, fileMatcher.fileMatchProcessorWrapper));
                matchedFile = true;
            }
            if (!matchedFile) continue;
            this.numJarfileFilesScanned.incrementAndGet();
        }
        this.numJarfilesScanned.incrementAndGet();
        this.fileToTimestamp.put(classpathElt, classpathElt.lastModified());
        if (FastClasspathScanner.verbose) {
            this.log.log(4, "Scanned jarfile " + classpathElt, System.nanoTime() - startTime);
        }
    }

    @Override
    public Void call() throws Exception {
        List<File> uniqueClasspathElts = this.classpathFinder.getUniqueClasspathElements();
        if (FastClasspathScanner.verbose) {
            this.log.log(1, "Classpath element scan order:");
            for (int i = 0; i < uniqueClasspathElts.size(); ++i) {
                File elt = uniqueClasspathElts.get(i);
                this.log.log(2, i + ": " + elt);
            }
        }
        for (File classpathElt : uniqueClasspathElts) {
            block26: {
                boolean isJar;
                if (this.previouslyScanned(classpathElt)) {
                    if (!FastClasspathScanner.verbose) continue;
                    this.log.log(2, "Reached duplicate classpath entry, ignoring: " + classpathElt);
                    continue;
                }
                boolean isDirectory = classpathElt.isDirectory();
                boolean bl = isJar = !isDirectory;
                if (isDirectory && this.scanSpec.scanNonJars) {
                    this.scanDir(classpathElt, classpathElt, classpathElt.getPath().length() + 1, false);
                } else {
                    if (isJar && this.scanSpec.scanJars) {
                        if (!this.scanSpec.jarIsWhitelisted(classpathElt.getName())) {
                            if (!FastClasspathScanner.verbose) continue;
                            this.log.log(2, "Skipping jarfile that did not match whitelist/blacklist criteria: " + classpathElt.getName());
                            continue;
                        }
                        try (ZipFile zipFile = new ZipFile(classpathElt);){
                            this.scanZipfile(classpathElt, zipFile);
                            break block26;
                        }
                        catch (IOException e) {
                            if (FastClasspathScanner.verbose) {
                                this.log.log(2, "Error opening ZipFile " + classpathElt.getName() + ": " + e);
                            }
                            break block26;
                        }
                    }
                    if (FastClasspathScanner.verbose) {
                        this.log.log(2, "Skipping classpath element " + classpathElt.getPath());
                    }
                }
            }
            if (!(this.interrupted |= Thread.currentThread().isInterrupted())) continue;
            break;
        }
        for (int i = 0; i < this.numWorkerThreads; ++i) {
            this.matchingClassfiles.add(ClasspathResource.END_OF_QUEUE);
            this.matchingFiles.add(ClasspathResource.END_OF_QUEUE);
        }
        if (FastClasspathScanner.verbose) {
            this.log.log(1, "Number of resources scanned: directories: " + this.numDirsScanned.get() + "; files: " + this.numFilesScanned.get() + "; jarfiles: " + this.numJarfilesScanned.get() + "; jarfile-internal directories: " + this.numJarfileDirsScanned + "; jarfile-internal files: " + this.numJarfileFilesScanned + "; classfiles: " + this.numClassfilesScanned);
        }
        return null;
    }
}

