/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.classfileparser.ClassInfo;
import io.github.lukehutch.fastclasspathscanner.scanner.ClassInfoUnlinked;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;

public class ClassInfoLinkerCaller
implements Callable<Void> {
    private final int numWorkerThreads;
    private final LinkedBlockingQueue<ClassInfoUnlinked> classInfoUnlinked;
    private final Map<String, ClassInfo> classNameToClassInfo;

    public ClassInfoLinkerCaller(LinkedBlockingQueue<ClassInfoUnlinked> classInfoUnlinked, Map<String, ClassInfo> classNameToClassInfo, int numWorkerThreads) {
        this.classInfoUnlinked = classInfoUnlinked;
        this.classNameToClassInfo = classNameToClassInfo;
        this.numWorkerThreads = numWorkerThreads;
    }

    @Override
    public Void call() {
        int endOfQueueMarkersNeeded = this.numWorkerThreads;
        while (endOfQueueMarkersNeeded > 0 && !Thread.currentThread().isInterrupted()) {
            try {
                ClassInfoUnlinked c = this.classInfoUnlinked.take();
                if (c == ClassInfoUnlinked.END_OF_QUEUE) {
                    --endOfQueueMarkersNeeded;
                    continue;
                }
                c.link(this.classNameToClassInfo);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return null;
    }
}

