/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.classpath.classloaderhandlers;

import io.github.lukehutch.fastclasspathscanner.classpath.ClassLoaderHandler;
import io.github.lukehutch.fastclasspathscanner.classpath.ClasspathFinder;
import io.github.lukehutch.fastclasspathscanner.utils.ReflectionUtils;
import java.lang.reflect.Array;

public class EquinoxClassLoaderHandler
implements ClassLoaderHandler {
    private boolean readSystemBundles = false;

    @Override
    public boolean handle(ClassLoader classloader, ClasspathFinder classpathFinder) throws Exception {
        for (Class<?> c = classloader.getClass(); c != null; c = c.getSuperclass()) {
            if (!"org.eclipse.osgi.internal.loader.EquinoxClassLoader".equals(c.getName())) continue;
            Object manager = ReflectionUtils.getFieldVal(classloader, "manager");
            Object entries = ReflectionUtils.getFieldVal(manager, "entries");
            if (entries != null) {
                int n = Array.getLength(entries);
                for (int i = 0; i < n; ++i) {
                    Object entry = Array.get(entries, i);
                    Object bundlefile = ReflectionUtils.getFieldVal(entry, "bundlefile");
                    Object basefile = ReflectionUtils.getFieldVal(bundlefile, "basefile");
                    if (basefile == null) continue;
                    Object cp = ReflectionUtils.getFieldVal(bundlefile, "cp");
                    if (cp != null) {
                        classpathFinder.addClasspathElement(basefile.toString() + "/" + cp.toString());
                        continue;
                    }
                    classpathFinder.addClasspathElement(basefile.toString());
                }
            }
            if (!this.readSystemBundles) {
                Object delegate = ReflectionUtils.getFieldVal(classloader, "delegate");
                Object container = ReflectionUtils.getFieldVal(delegate, "container");
                Object storage = ReflectionUtils.getFieldVal(container, "storage");
                Object moduleContainer = ReflectionUtils.getFieldVal(storage, "moduleContainer");
                Object moduleDatabase = ReflectionUtils.getFieldVal(moduleContainer, "moduleDatabase");
                Object modulesById = ReflectionUtils.getFieldVal(moduleDatabase, "modulesById");
                Object module0 = ReflectionUtils.invokeMethod(modulesById, "get", Object.class, 0L);
                Object bundle = ReflectionUtils.invokeMethod(module0, "getBundle");
                Object bundleContext = ReflectionUtils.invokeMethod(bundle, "getBundleContext");
                Object bundles = ReflectionUtils.invokeMethod(bundleContext, "getBundles");
                if (bundles != null) {
                    int n = Array.getLength(bundles);
                    for (int i = 0; i < n; ++i) {
                        int fileIdx;
                        Object equinoxBundle = Array.get(bundles, i);
                        Object module = ReflectionUtils.getFieldVal(equinoxBundle, "module");
                        String location = (String)ReflectionUtils.getFieldVal(module, "location");
                        if (location == null || (fileIdx = location.indexOf("file:")) < 0) continue;
                        location = location.substring(fileIdx);
                        classpathFinder.addClasspathElement(location);
                    }
                }
                this.readSystemBundles = true;
            }
            return true;
        }
        return false;
    }
}

