/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.classfileparser;

import io.github.lukehutch.fastclasspathscanner.FastClasspathScanner;
import io.github.lukehutch.fastclasspathscanner.scanner.ClassInfoUnlinked;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import io.github.lukehutch.fastclasspathscanner.utils.ThreadLog;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ClassfileBinaryParser {
    private final ScanSpec scanSpec;
    private final ThreadLog log;
    private InputStream inputStream;
    private String className;
    private static final int INITIAL_BUFFER_CHUNK_SIZE = 16384;
    private static final int SUBSEQUENT_BUFFER_CHUNK_SIZE = 4096;
    private byte[] buf = new byte[16384];
    private int curr = 0;
    private int used = 0;
    private int[] offset;
    private int[] tag;
    private int[] indirectStringRefs;

    public ClassfileBinaryParser(ScanSpec scanSpec, ThreadLog log) {
        this.scanSpec = scanSpec;
        this.log = log;
    }

    private void readMore(int bytesRequired) throws IOException, InterruptedException {
        int bytesRead;
        int extraBytesNeeded = bytesRequired - (this.used - this.curr);
        int bytesToRequest = extraBytesNeeded + 4096;
        int maxNewUsed = this.used + bytesToRequest;
        if (maxNewUsed > this.buf.length) {
            int newBufLen;
            for (newBufLen = this.buf.length; newBufLen < maxNewUsed; newBufLen <<= 1) {
            }
            this.buf = Arrays.copyOf(this.buf, newBufLen);
        }
        for (int extraBytesStillNotRead = extraBytesNeeded; extraBytesStillNotRead > 0; extraBytesStillNotRead -= bytesRead) {
            bytesRead = this.inputStream.read(this.buf, this.used, bytesToRequest);
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            if (bytesRead > 0) {
                this.used += bytesRead;
                bytesToRequest -= bytesRead;
                continue;
            }
            if (extraBytesStillNotRead <= 0) break;
            throw new IOException("Premature EOF while reading classfile");
        }
    }

    private int readUnsignedByte() throws IOException, InterruptedException {
        if (this.curr > this.used - 1) {
            this.readMore(1);
        }
        return this.buf[this.curr++] & 0xFF;
    }

    private int readUnsignedByte(int offset) {
        return this.buf[offset] & 0xFF;
    }

    private int readUnsignedShort() throws IOException, InterruptedException {
        if (this.curr > this.used - 2) {
            this.readMore(2);
        }
        int val = (this.buf[this.curr] & 0xFF) << 8 | this.buf[this.curr + 1] & 0xFF;
        this.curr += 2;
        return val;
    }

    private int readUnsignedShort(int offset) {
        return (this.buf[offset] & 0xFF) << 8 | this.buf[offset + 1] & 0xFF;
    }

    private int readInt() throws IOException, InterruptedException {
        if (this.curr > this.used - 4) {
            this.readMore(4);
        }
        int val = (this.buf[this.curr] & 0xFF) << 24 | (this.buf[this.curr + 1] & 0xFF) << 16 | (this.buf[this.curr + 2] & 0xFF) << 8 | this.buf[this.curr + 3] & 0xFF;
        this.curr += 4;
        return val;
    }

    private int readInt(int offset) throws IOException {
        return (this.buf[offset] & 0xFF) << 24 | (this.buf[offset + 1] & 0xFF) << 16 | (this.buf[offset + 2] & 0xFF) << 8 | this.buf[offset + 3] & 0xFF;
    }

    private long readLong() throws IOException, InterruptedException {
        if (this.curr > this.used - 8) {
            this.readMore(8);
        }
        long val = (long)((this.buf[this.curr] & 0xFF) << 24 | (this.buf[this.curr + 1] & 0xFF) << 16 | (this.buf[this.curr + 2] & 0xFF) << 8 | this.buf[this.curr + 3] & 0xFF) << 32 | (long)((this.buf[this.curr + 4] & 0xFF) << 24) | (long)((this.buf[this.curr + 5] & 0xFF) << 16) | (long)((this.buf[this.curr + 6] & 0xFF) << 8) | (long)(this.buf[this.curr + 7] & 0xFF);
        this.curr += 8;
        return val;
    }

    private long readLong(int offset) throws IOException {
        return (long)((this.buf[offset] & 0xFF) << 24 | (this.buf[offset + 1] & 0xFF) << 16 | (this.buf[offset + 2] & 0xFF) << 8 | this.buf[offset + 3] & 0xFF) << 32 | (long)((this.buf[offset + 4] & 0xFF) << 24) | (long)((this.buf[offset + 5] & 0xFF) << 16) | (long)((this.buf[offset + 6] & 0xFF) << 8) | (long)(this.buf[offset + 7] & 0xFF);
    }

    private void skip(int bytesToSkip) throws IOException, InterruptedException {
        if (this.curr > this.used - bytesToSkip) {
            this.readMore(bytesToSkip);
        }
        this.curr += bytesToSkip;
    }

    private String readString(int offset, boolean replaceSlashWithDot) {
        int c;
        int byteIdx;
        int utfLen = this.readUnsignedShort(offset);
        int start = offset + 2;
        char[] chars = new char[utfLen];
        int charIdx = 0;
        for (byteIdx = 0; byteIdx < utfLen && (c = this.buf[start + byteIdx] & 0xFF) <= 127; ++byteIdx) {
            chars[charIdx++] = (char)(replaceSlashWithDot && c == 47 ? 46 : c);
        }
        block6: while (byteIdx < utfLen) {
            c = this.buf[start + byteIdx] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++byteIdx;
                    chars[charIdx++] = (char)(replaceSlashWithDot && c == 47 ? 46 : c);
                    continue block6;
                }
                case 12: 
                case 13: {
                    if ((byteIdx += 2) > utfLen) {
                        throw new RuntimeException("Bad modified UTF8");
                    }
                    byte c2 = this.buf[start + byteIdx - 1];
                    if ((c2 & 0xC0) != 128) {
                        throw new RuntimeException("Bad modified UTF8");
                    }
                    int c4 = (c & 0x1F) << 6 | c2 & 0x3F;
                    chars[charIdx++] = (char)(replaceSlashWithDot && c4 == 47 ? 46 : c4);
                    continue block6;
                }
                case 14: {
                    if ((byteIdx += 3) > utfLen) {
                        throw new RuntimeException("Bad modified UTF8");
                    }
                    byte c2 = this.buf[start + byteIdx - 2];
                    byte c3 = this.buf[start + byteIdx - 1];
                    if ((c2 & 0xC0) != 128 || (c3 & 0xC0) != 128) {
                        throw new RuntimeException("Bad modified UTF8");
                    }
                    int c4 = (c & 0xF) << 12 | (c2 & 0x3F) << 6 | (c3 & 0x3F) << 0;
                    chars[charIdx++] = (char)(replaceSlashWithDot && c4 == 47 ? 46 : c4);
                    continue block6;
                }
            }
            throw new RuntimeException("Bad modified UTF8");
        }
        if (charIdx < utfLen) {
            return new String(chars, 0, charIdx);
        }
        return new String(chars);
    }

    private int getConstantPoolStringOffset(int constantPoolIdx) {
        int t = this.tag[constantPoolIdx];
        if (t != 1 && t != 7 && t != 8) {
            throw new RuntimeException("Wrong tag number at constant pool index " + constantPoolIdx + ", cannot continue reading class. Please report this on the FastClasspathScanner GitHub page.");
        }
        int cpIdx = constantPoolIdx;
        if (t == 7 || t == 8) {
            int indirIdx = this.indirectStringRefs[constantPoolIdx];
            if (indirIdx == -1) {
                throw new RuntimeException("Bad string indirection index, cannot continue reading class. Please report this on the FastClasspathScanner GitHub page.");
            }
            if (indirIdx == 0) {
                return 0;
            }
            cpIdx = indirIdx;
        }
        return this.offset[cpIdx];
    }

    private String getConstantPoolString(int constantPoolIdx, boolean replaceSlashWithDot) {
        int constantPoolStringOffset = this.getConstantPoolStringOffset(constantPoolIdx);
        return constantPoolStringOffset == 0 ? null : this.readString(constantPoolStringOffset, replaceSlashWithDot);
    }

    private String getConstantPoolString(int constantPoolIdx) {
        int constantPoolStringOffset = this.getConstantPoolStringOffset(constantPoolIdx);
        return constantPoolStringOffset == 0 ? null : this.readString(constantPoolStringOffset, false);
    }

    private String getConstantPoolClassName(int constantPoolIdx) {
        return this.getConstantPoolString(constantPoolIdx, true);
    }

    private boolean constantPoolStringEquals(int constantPoolIdx, String otherString) {
        int otherLen;
        int strOffset = this.getConstantPoolStringOffset(constantPoolIdx);
        if (strOffset == 0) {
            return otherString == null;
        }
        int strLen = this.readUnsignedShort(strOffset);
        if (strLen != (otherLen = otherString.length())) {
            return false;
        }
        int strStart = strOffset + 2;
        for (int i = 0; i < strLen; ++i) {
            if ((char)(this.buf[strStart + i] & 0xFF) == otherString.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private Object getConstantPoolValue(int constantPoolIdx) throws IOException {
        switch (this.tag[constantPoolIdx]) {
            case 1: {
                return this.getConstantPoolString(constantPoolIdx);
            }
            case 3: {
                return new Integer(this.readInt(this.offset[constantPoolIdx]));
            }
            case 4: {
                return new Float(Float.intBitsToFloat(this.readInt(this.offset[constantPoolIdx])));
            }
            case 5: {
                return new Long(this.readLong(this.offset[constantPoolIdx]));
            }
            case 6: {
                return new Double(Double.longBitsToDouble(this.readLong(this.offset[constantPoolIdx])));
            }
            case 7: 
            case 8: {
                return this.getConstantPoolString(constantPoolIdx);
            }
        }
        throw new RuntimeException("Constant pool entry type " + this.tag[constantPoolIdx] + " unsupported, cannot continue reading class. Please report this on the FastClasspathScanner GitHub page.");
    }

    private String readAnnotation() throws IOException, InterruptedException {
        String annotationFieldDescriptor = this.getConstantPoolClassName(this.readUnsignedShort());
        String annotationClassName = annotationFieldDescriptor.charAt(0) == 'L' && annotationFieldDescriptor.charAt(annotationFieldDescriptor.length() - 1) == ';' ? annotationFieldDescriptor.substring(1, annotationFieldDescriptor.length() - 1) : annotationFieldDescriptor;
        int numElementValuePairs = this.readUnsignedShort();
        for (int i = 0; i < numElementValuePairs; ++i) {
            this.skip(2);
            this.readAnnotationElementValue();
        }
        return annotationClassName;
    }

    private void readAnnotationElementValue() throws IOException, InterruptedException {
        char tag = (char)this.readUnsignedByte();
        switch (tag) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': 
            case 's': {
                this.skip(2);
                break;
            }
            case 'e': {
                this.skip(4);
                break;
            }
            case 'c': {
                this.skip(2);
                break;
            }
            case '@': {
                this.readAnnotation();
                break;
            }
            case '[': {
                int count = this.readUnsignedShort();
                for (int l = 0; l < count; ++l) {
                    this.readAnnotationElementValue();
                }
                break;
            }
            default: {
                throw new RuntimeException("Class " + this.className + " has unknown annotation element type tag '" + (char)tag + "': element size unknown, cannot continue reading class. Please report this on the FastClasspathScanner GitHub page.");
            }
        }
    }

    private void addFieldTypeDescriptorParts(ClassInfoUnlinked classInfoUnlinked, String typeDescriptor) {
        for (int i = 0; i < typeDescriptor.length(); ++i) {
            char c = typeDescriptor.charAt(i);
            if (c != 'L') continue;
            int typeNameStart = ++i;
            while (i < typeDescriptor.length() && (c = typeDescriptor.charAt(i)) != '<' && c != ';') {
                ++i;
            }
            char[] typeNameChars = new char[i - typeNameStart];
            for (int j = typeNameStart; j < i; ++j) {
                char chr = typeDescriptor.charAt(j);
                typeNameChars[j - typeNameStart] = chr == '/' ? 46 : (int)chr;
            }
            String typeName = new String(typeNameChars);
            if (!this.scanSpec.classIsNotBlacklisted(typeName)) continue;
            classInfoUnlinked.addFieldType(typeName);
        }
    }

    private boolean classNameMatches(String relativePath) {
        int i;
        int len = this.className.length();
        if (len != relativePath.length() - 6) {
            return false;
        }
        for (i = 0; i < len; ++i) {
            char c = this.className.charAt(i);
            char r = relativePath.charAt(i);
            if (c == '.' && r == '/' || c == r) continue;
            return false;
        }
        for (i = 0; i < 6; ++i) {
            if (relativePath.charAt(len + i) == ".class".charAt(i)) continue;
            return false;
        }
        return true;
    }

    public ClassInfoUnlinked readClassInfoFromClassfileHeader(String relativePath, InputStream inputStream, Map<String, HashSet<String>> classNameToStaticFinalFieldsToMatch, ConcurrentHashMap<String, String> stringInternMap) throws IOException {
        try {
            int attributeLength;
            this.className = null;
            this.inputStream = inputStream;
            this.curr = 0;
            this.used = inputStream.read(this.buf, 0, 16384);
            if (this.used < 0) {
                throw new IOException("Classfile " + relativePath + " is empty");
            }
            if (this.readInt() != -889275714 && FastClasspathScanner.verbose) {
                throw new IOException("Classfile " + relativePath + " does not have correct classfile magic number");
            }
            this.readUnsignedShort();
            this.readUnsignedShort();
            int cpCount = this.readUnsignedShort();
            if (this.offset == null || this.offset.length < cpCount) {
                this.offset = new int[cpCount];
                this.tag = new int[cpCount];
                this.indirectStringRefs = new int[cpCount];
            }
            Arrays.fill(this.indirectStringRefs, 0, cpCount, -1);
            block19: for (int i = 1; i < cpCount; ++i) {
                this.tag[i] = this.readUnsignedByte();
                this.offset[i] = this.curr;
                switch (this.tag[i]) {
                    case 1: {
                        int strLen = this.readUnsignedShort();
                        this.skip(strLen);
                        continue block19;
                    }
                    case 3: 
                    case 4: {
                        this.skip(4);
                        continue block19;
                    }
                    case 5: 
                    case 6: {
                        this.skip(8);
                        ++i;
                        continue block19;
                    }
                    case 7: 
                    case 8: {
                        this.indirectStringRefs[i] = this.readUnsignedShort();
                        continue block19;
                    }
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: {
                        this.skip(4);
                        continue block19;
                    }
                    case 15: {
                        this.skip(3);
                        continue block19;
                    }
                    case 16: {
                        this.skip(2);
                        continue block19;
                    }
                    case 18: {
                        this.skip(4);
                        continue block19;
                    }
                    default: {
                        throw new RuntimeException("Unknown constant pool tag " + this.tag + " in classfile " + relativePath + " (element size unknown, cannot continue reading class. Please report this on the FastClasspathScanner GitHub page.");
                    }
                }
            }
            int flags = this.readUnsignedShort();
            boolean isInterface = (flags & 0x200) != 0;
            boolean isAnnotation = (flags & 0x2000) != 0;
            this.className = this.getConstantPoolClassName(this.readUnsignedShort());
            if ("java.lang.Object".equals(this.className)) {
                return null;
            }
            if (!this.classNameMatches(relativePath)) {
                if (FastClasspathScanner.verbose) {
                    this.log.log(2, "Class " + this.className + " is at incorrect relative path " + relativePath + " -- ignoring");
                }
                return null;
            }
            String superclassName = this.getConstantPoolClassName(this.readUnsignedShort());
            ClassInfoUnlinked classInfoUnlinked = new ClassInfoUnlinked(this.className, isInterface, isAnnotation, stringInternMap);
            if (this.scanSpec.classIsNotBlacklisted(superclassName)) {
                classInfoUnlinked.addSuperclass(superclassName);
            }
            int interfaceCount = this.readUnsignedShort();
            for (int i = 0; i < interfaceCount; ++i) {
                String interfaceName = this.getConstantPoolClassName(this.readUnsignedShort());
                if (!this.scanSpec.classIsNotBlacklisted(interfaceName)) continue;
                classInfoUnlinked.addImplementedInterface(interfaceName);
            }
            HashSet<String> staticFinalFieldsToMatch = classNameToStaticFinalFieldsToMatch == null ? null : classNameToStaticFinalFieldsToMatch.get(this.className);
            int fieldCount = this.readUnsignedShort();
            for (int i = 0; i < fieldCount; ++i) {
                boolean scanField;
                int accessFlags = this.readUnsignedShort();
                boolean isPublicField = (accessFlags & 2) == 2;
                boolean bl = scanField = isPublicField || this.scanSpec.ignoreFieldVisibility;
                if (!scanField) {
                    this.readUnsignedShort();
                    this.readUnsignedShort();
                    int attributesCount = this.readUnsignedShort();
                    for (int j = 0; j < attributesCount; ++j) {
                        this.readUnsignedShort();
                        int attributeLength2 = this.readInt();
                        this.skip(attributeLength2);
                    }
                    continue;
                }
                boolean isStaticFinalField = (accessFlags & 0x18) == 24;
                int fieldNameConstantPoolIdx = this.readUnsignedShort();
                String fieldName = null;
                boolean isMatchedFieldName = false;
                if (staticFinalFieldsToMatch != null && scanField && staticFinalFieldsToMatch.contains(fieldName = this.getConstantPoolString(fieldNameConstantPoolIdx))) {
                    isMatchedFieldName = true;
                }
                int fieldTypeDescriptorConstantPoolIdx = this.readUnsignedShort();
                String fieldTypeDescriptor = scanField ? this.getConstantPoolString(fieldTypeDescriptorConstantPoolIdx) : null;
                int attributesCount = this.readUnsignedShort();
                this.addFieldTypeDescriptorParts(classInfoUnlinked, fieldTypeDescriptor);
                if (!isStaticFinalField && isMatchedFieldName) {
                    this.log.log(2, "Cannot match requested field " + classInfoUnlinked.className + "." + this.getConstantPoolString(fieldNameConstantPoolIdx) + " because it is either not static or not final");
                }
                boolean foundConstantValue = false;
                for (int j = 0; j < attributesCount; ++j) {
                    int attributeNameConstantPoolIdx = this.readUnsignedShort();
                    int attributeLength3 = this.readInt();
                    if (isStaticFinalField && isMatchedFieldName && this.constantPoolStringEquals(attributeNameConstantPoolIdx, "ConstantValue")) {
                        Object constValue = this.getConstantPoolValue(this.readUnsignedShort());
                        switch (fieldTypeDescriptor.charAt(0)) {
                            case 'B': {
                                constValue = new Byte(((Integer)constValue).byteValue());
                                break;
                            }
                            case 'C': {
                                constValue = new Character((char)((Integer)constValue).intValue());
                                break;
                            }
                            case 'S': {
                                constValue = new Short(((Integer)constValue).shortValue());
                                break;
                            }
                            case 'Z': {
                                constValue = new Boolean((Integer)constValue != 0);
                                break;
                            }
                            case 'D': 
                            case 'F': 
                            case 'I': 
                            case 'J': {
                                break;
                            }
                            default: {
                                if ("Ljava/lang/String;".equals(fieldTypeDescriptor)) break;
                                throw new RuntimeException("Unknown constant initializer type " + fieldTypeDescriptor + " for class " + this.className + " -- please report this on the FastClasspathScanner GitHub page.");
                            }
                        }
                        classInfoUnlinked.addFieldConstantValue(fieldName, constValue);
                        foundConstantValue = true;
                    } else if (this.constantPoolStringEquals(attributeNameConstantPoolIdx, "Signature")) {
                        String fieldTypeSignature = this.getConstantPoolString(this.readUnsignedShort());
                        this.addFieldTypeDescriptorParts(classInfoUnlinked, fieldTypeSignature);
                    } else {
                        this.skip(attributeLength3);
                    }
                    if (foundConstantValue || !isStaticFinalField || !isMatchedFieldName) continue;
                    this.log.log(2, "Requested static final field " + classInfoUnlinked.className + "." + this.getConstantPoolString(fieldNameConstantPoolIdx) + " is not initialized with a constant literal value, so there is no initializer value in the constant pool of the classfile");
                }
            }
            int methodCount = this.readUnsignedShort();
            for (int i = 0; i < methodCount; ++i) {
                this.skip(6);
                int attributesCount = this.readUnsignedShort();
                for (int j = 0; j < attributesCount; ++j) {
                    this.skip(2);
                    attributeLength = this.readInt();
                    this.skip(attributeLength);
                }
            }
            int attributesCount = this.readUnsignedShort();
            for (int i = 0; i < attributesCount; ++i) {
                int attributeNameConstantPoolIdx = this.readUnsignedShort();
                attributeLength = this.readInt();
                if (this.constantPoolStringEquals(attributeNameConstantPoolIdx, "RuntimeVisibleAnnotations")) {
                    int annotationCount = this.readUnsignedShort();
                    for (int m = 0; m < annotationCount; ++m) {
                        String annotationName = this.readAnnotation();
                        if (!this.scanSpec.classIsNotBlacklisted(annotationName)) continue;
                        classInfoUnlinked.addAnnotation(annotationName);
                    }
                    continue;
                }
                this.skip(attributeLength);
            }
            return classInfoUnlinked;
        }
        catch (Exception e) {
            this.log.log(2, "Exception while attempting to load classfile " + relativePath + ": " + e);
            return null;
        }
    }
}

