/*
 * Decompiled with CFR 0.152.
 */
package com.yalantis.ucrop.util;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Point;
import android.net.Uri;
import android.os.AsyncTask;
import android.util.Log;
import android.view.Display;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yalantis.ucrop.callback.BitmapLoadCallback;
import com.yalantis.ucrop.task.BitmapLoadTask;
import com.yalantis.ucrop.util.EglUtils;
import com.yalantis.ucrop.util.FileUtils;
import com.yalantis.ucrop.util.ImageHeaderParser;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;

public class BitmapLoadUtils {
    private static final int MAX_BITMAP_SIZE = 0x6400000;
    private static final String CONTENT_SCHEME = "content";
    private static final String TAG = "BitmapLoadUtils";

    public static void decodeBitmapInBackground(@NonNull Context context, @NonNull Uri uri, @Nullable Uri outputUri, int requiredWidth, int requiredHeight, BitmapLoadCallback loadCallback) {
        new BitmapLoadTask(context, uri, outputUri, requiredWidth, requiredHeight, loadCallback).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
    }

    public static Bitmap transformBitmap(@NonNull Bitmap bitmap, @NonNull Matrix transformMatrix) {
        try {
            Bitmap converted = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)transformMatrix, (boolean)true);
            if (!bitmap.sameAs(converted)) {
                bitmap = converted;
            }
        }
        catch (OutOfMemoryError error) {
            Log.e((String)TAG, (String)"transformBitmap: ", (Throwable)error);
        }
        return bitmap;
    }

    @Deprecated
    public static int calculateInSampleSize(@NonNull BitmapFactory.Options options, int reqWidth, int reqHeight) {
        int height = options.outHeight;
        int width = options.outWidth;
        int inSampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            while (height / inSampleSize > reqHeight || width / inSampleSize > reqWidth) {
                inSampleSize *= 2;
            }
        }
        return inSampleSize;
    }

    public static int computeSize(int srcWidth, int srcHeight) {
        srcWidth = srcWidth % 2 == 1 ? srcWidth + 1 : srcWidth;
        srcHeight = srcHeight % 2 == 1 ? srcHeight + 1 : srcHeight;
        int longSide = Math.max(srcWidth, srcHeight);
        int shortSide = Math.min(srcWidth, srcHeight);
        float scale = (float)shortSide / (float)longSide;
        if (scale <= 1.0f && (double)scale > 0.5625) {
            if (longSide < 1664) {
                return 1;
            }
            if (longSide < 4990) {
                return 2;
            }
            if (longSide > 4990 && longSide < 10240) {
                return 4;
            }
            return longSide / 1280;
        }
        if ((double)scale <= 0.5625 && (double)scale > 0.5) {
            return longSide / 1280 == 0 ? 1 : longSide / 1280;
        }
        return (int)Math.ceil((double)longSide / (1280.0 / (double)scale));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] getMaxImageSize(Context context, Uri mInputUri) {
        if (FileUtils.isHasHttp(mInputUri.toString())) {
            return new int[]{0, 0};
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        try {
            InputStream stream = context.getContentResolver().openInputStream(mInputUri);
            BitmapFactory.decodeStream((InputStream)stream, null, (BitmapFactory.Options)options);
            options.inSampleSize = BitmapLoadUtils.computeSize(options.outWidth, options.outHeight);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        options.inJustDecodeBounds = false;
        Bitmap decodeSampledBitmap = null;
        boolean decodeAttemptSuccess = false;
        while (!decodeAttemptSuccess) {
            try {
                InputStream stream = context.getContentResolver().openInputStream(mInputUri);
                try {
                    decodeSampledBitmap = BitmapFactory.decodeStream((InputStream)stream, null, (BitmapFactory.Options)options);
                }
                finally {
                    BitmapLoadUtils.close(stream);
                }
                if (BitmapLoadUtils.checkSize(decodeSampledBitmap, options)) continue;
                decodeAttemptSuccess = true;
            }
            catch (OutOfMemoryError error) {
                Log.e((String)TAG, (String)"doInBackground: BitmapFactory.decodeFileDescriptor: ", (Throwable)error);
                options.inSampleSize *= 2;
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"doInBackground: ImageDecoder.createSource: ", (Throwable)e);
            }
        }
        if (decodeSampledBitmap == null) {
            return new int[]{0, 0};
        }
        return new int[]{decodeSampledBitmap.getWidth(), decodeSampledBitmap.getHeight()};
    }

    public static boolean checkSize(Bitmap bitmap, BitmapFactory.Options options) {
        int bitmapSize;
        int n = bitmapSize = bitmap != null ? bitmap.getByteCount() : 0;
        if ((long)bitmapSize > BitmapLoadUtils.getTotalMemory()) {
            options.inSampleSize *= 2;
            return true;
        }
        return false;
    }

    public static long getTotalMemory() {
        long totalMemory = Runtime.getRuntime().totalMemory();
        return totalMemory > 0x6400000L ? 0x6400000L : totalMemory;
    }

    public static int getExifOrientation(@NonNull Context context, @NonNull Uri imageUri) {
        int orientation = 0;
        try {
            InputStream stream = context.getContentResolver().openInputStream(imageUri);
            if (stream == null) {
                return orientation;
            }
            orientation = new ImageHeaderParser(stream).getOrientation();
            BitmapLoadUtils.close(stream);
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("getExifOrientation: " + imageUri.toString()), (Throwable)e);
        }
        return orientation;
    }

    public static int exifToDegrees(int exifOrientation) {
        int rotation;
        switch (exifOrientation) {
            case 5: 
            case 6: {
                rotation = 90;
                break;
            }
            case 3: 
            case 4: {
                rotation = 180;
                break;
            }
            case 7: 
            case 8: {
                rotation = 270;
                break;
            }
            default: {
                rotation = 0;
            }
        }
        return rotation;
    }

    public static int exifToTranslation(int exifOrientation) {
        int translation;
        switch (exifOrientation) {
            case 2: 
            case 4: 
            case 5: 
            case 7: {
                translation = -1;
                break;
            }
            default: {
                translation = 1;
            }
        }
        return translation;
    }

    public static int calculateMaxBitmapSize(@NonNull Context context) {
        int maxTextureSize;
        WindowManager wm = (WindowManager)context.getSystemService("window");
        Point size = new Point();
        if (wm != null) {
            Display display = wm.getDefaultDisplay();
            display.getSize(size);
        }
        int width = size.x;
        int height = size.y;
        int maxBitmapSize = (int)Math.sqrt(Math.pow(width, 2.0) + Math.pow(height, 2.0));
        Canvas canvas = new Canvas();
        int maxCanvasSize = Math.min(canvas.getMaximumBitmapWidth(), canvas.getMaximumBitmapHeight());
        if (maxCanvasSize > 0) {
            maxBitmapSize = Math.min(maxBitmapSize, maxCanvasSize);
        }
        if ((maxTextureSize = EglUtils.getMaxTextureSize()) > 0) {
            maxBitmapSize = Math.min(maxBitmapSize, maxTextureSize);
        }
        Log.d((String)TAG, (String)("maxBitmapSize: " + maxBitmapSize));
        return maxBitmapSize;
    }

    public static void close(@Nullable Closeable c) {
        if (c != null && c instanceof Closeable) {
            try {
                c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static boolean hasContentScheme(Uri uri) {
        return uri != null && CONTENT_SCHEME.equals(uri.getScheme());
    }
}

