/*
 * Decompiled with CFR 0.152.
 */
package com.yalantis.ucrop.util;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.util.Log;
import android.webkit.MimeTypeMap;
import androidx.annotation.NonNull;
import com.yalantis.ucrop.util.BitmapLoadUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.text.SimpleDateFormat;
import java.util.Locale;

public class FileUtils {
    private static final String TAG = "FileUtils";
    public static final String GIF = ".gif";
    public static final String WEBP = ".webp";
    public static final String JPEG = ".jpeg";
    private static final SimpleDateFormat sf = new SimpleDateFormat("yyyyMMddHHmmssSSS");

    private FileUtils() {
    }

    public static boolean isContent(String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return false;
        }
        return url.startsWith("content://");
    }

    public static Uri replaceOutputUri(Context context, boolean isForbidGifWebp, Uri inputUri, Uri outputUri) {
        try {
            String postfix = FileUtils.getPostfixDefaultEmpty(context, isForbidGifWebp, inputUri);
            if (TextUtils.isEmpty((CharSequence)postfix)) {
                return outputUri;
            }
            String outputPath = FileUtils.isContent(outputUri.toString()) ? outputUri.toString() : outputUri.getPath();
            int lastIndexOf = outputPath.lastIndexOf(".");
            outputPath = outputPath.replace(outputPath.substring(lastIndexOf), postfix);
            outputUri = FileUtils.isContent(outputPath) ? Uri.parse((String)outputPath) : Uri.fromFile((File)new File(outputPath));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return outputUri;
    }

    public static String getPostfixDefaultJPEG(Context context, boolean isForbidGifWebp, Uri inputUri) {
        String postfix = JPEG;
        if (isForbidGifWebp) {
            String mimeType = FileUtils.getMimeTypeFromMediaContentUri(context, inputUri);
            if (FileUtils.isGif(mimeType)) {
                postfix = GIF;
            } else if (FileUtils.isWebp(mimeType)) {
                postfix = WEBP;
            }
        }
        return postfix;
    }

    public static String getPostfixDefaultEmpty(Context context, boolean isForbidGifWebp, Uri inputUri) {
        String postfix = "";
        if (isForbidGifWebp) {
            String mimeType = FileUtils.getMimeTypeFromMediaContentUri(context, inputUri);
            if (FileUtils.isGif(mimeType)) {
                postfix = GIF;
            } else if (FileUtils.isWebp(mimeType)) {
                postfix = WEBP;
            }
        }
        return postfix;
    }

    public static String getInputPath(Uri inputUri) {
        return FileUtils.isContent(inputUri.toString()) || FileUtils.isHasHttp(inputUri.toString()) ? inputUri.toString() : inputUri.getPath();
    }

    public static boolean isUrlHasVideo(String url) {
        return !TextUtils.isEmpty((CharSequence)url) && url.toLowerCase().endsWith(".mp4");
    }

    public static boolean isHasVideo(String mimeType) {
        return mimeType != null && mimeType.startsWith("video");
    }

    public static boolean isHasAudio(String mimeType) {
        return mimeType != null && mimeType.startsWith("audio");
    }

    public static boolean isHasHttp(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return false;
        }
        return path.startsWith("http") || path.startsWith("https") || path.startsWith("/http") || path.startsWith("/https");
    }

    public static boolean isGif(String mimeType) {
        return mimeType != null && (mimeType.equals("image/gif") || mimeType.equals("image/GIF"));
    }

    public static boolean isWebp(String mimeType) {
        return mimeType != null && (mimeType.equals("image/webp") || mimeType.equals("image/WEBP"));
    }

    public static String getMimeTypeFromMediaContentUri(Context context, Uri uri) {
        String mimeType;
        if (uri.getScheme().equals("content")) {
            ContentResolver cr = context.getContentResolver();
            mimeType = cr.getType(uri);
        } else {
            String fileExtension = MimeTypeMap.getFileExtensionFromUrl((String)uri.toString());
            mimeType = MimeTypeMap.getSingleton().getMimeTypeFromExtension(fileExtension.toLowerCase());
        }
        return mimeType;
    }

    public static String getCreateFileName(String prefix) {
        long millis = System.currentTimeMillis();
        return prefix + sf.format(millis);
    }

    public static String getCreateFileName() {
        long millis = System.currentTimeMillis();
        return sf.format(millis);
    }

    public static boolean isExternalStorageDocument(Uri uri) {
        return "com.android.externalstorage.documents".equals(uri.getAuthority());
    }

    public static boolean isDownloadsDocument(Uri uri) {
        return "com.android.providers.downloads.documents".equals(uri.getAuthority());
    }

    public static boolean isMediaDocument(Uri uri) {
        return "com.android.providers.media.documents".equals(uri.getAuthority());
    }

    public static boolean isGooglePhotosUri(Uri uri) {
        return "com.google.android.apps.photos.content".equals(uri.getAuthority());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDataColumn(Context context, Uri uri, String selection, String[] selectionArgs) {
        Cursor cursor = null;
        String column = "_data";
        String[] projection = new String[]{"_data"};
        try {
            cursor = context.getContentResolver().query(uri, projection, selection, selectionArgs, null);
            if (cursor != null && cursor.moveToFirst()) {
                int column_index = cursor.getColumnIndexOrThrow("_data");
                String string2 = cursor.getString(column_index);
                return string2;
            }
        }
        catch (IllegalArgumentException ex) {
            Log.i((String)TAG, (String)String.format(Locale.getDefault(), "getDataColumn: _data - [%s]", ex.getMessage()));
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return null;
    }

    @SuppressLint(value={"NewApi"})
    public static String getPath(Context context, Uri uri) {
        boolean isKitKat;
        boolean bl = isKitKat = Build.VERSION.SDK_INT >= 19;
        if (isKitKat && DocumentsContract.isDocumentUri((Context)context, (Uri)uri)) {
            if (FileUtils.isExternalStorageDocument(uri)) {
                String docId = DocumentsContract.getDocumentId((Uri)uri);
                String[] split = docId.split(":");
                String type = split[0];
                if ("primary".equalsIgnoreCase(type)) {
                    return Environment.getExternalStorageDirectory() + "/" + split[1];
                }
            } else if (FileUtils.isDownloadsDocument(uri)) {
                String id2 = DocumentsContract.getDocumentId((Uri)uri);
                if (!TextUtils.isEmpty((CharSequence)id2)) {
                    try {
                        Uri contentUri = ContentUris.withAppendedId((Uri)Uri.parse((String)"content://downloads/public_downloads"), (long)Long.valueOf(id2));
                        return FileUtils.getDataColumn(context, contentUri, null, null);
                    }
                    catch (NumberFormatException e) {
                        Log.i((String)TAG, (String)e.getMessage());
                        return null;
                    }
                }
            } else if (FileUtils.isMediaDocument(uri)) {
                String docId = DocumentsContract.getDocumentId((Uri)uri);
                String[] split = docId.split(":");
                String type = split[0];
                Uri contentUri = null;
                if ("image".equals(type)) {
                    contentUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                } else if ("video".equals(type)) {
                    contentUri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                } else if ("audio".equals(type)) {
                    contentUri = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                }
                String selection = "_id=?";
                String[] selectionArgs = new String[]{split[1]};
                return FileUtils.getDataColumn(context, contentUri, "_id=?", selectionArgs);
            }
        } else {
            if ("content".equalsIgnoreCase(uri.getScheme())) {
                if (FileUtils.isGooglePhotosUri(uri)) {
                    return uri.getLastPathSegment();
                }
                return FileUtils.getDataColumn(context, uri, null, null);
            }
            if ("file".equalsIgnoreCase(uri.getScheme())) {
                return uri.getPath();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(@NonNull String pathFrom, @NonNull String pathTo) throws IOException {
        if (pathFrom.equalsIgnoreCase(pathTo)) {
            return;
        }
        AbstractInterruptibleChannel outputChannel = null;
        AbstractInterruptibleChannel inputChannel = null;
        try {
            inputChannel = new FileInputStream(new File(pathFrom)).getChannel();
            outputChannel = new FileOutputStream(new File(pathTo)).getChannel();
            ((FileChannel)inputChannel).transferTo(0L, ((FileChannel)inputChannel).size(), (WritableByteChannel)((Object)outputChannel));
        }
        finally {
            if (inputChannel != null) {
                inputChannel.close();
            }
            if (outputChannel != null) {
                outputChannel.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(@NonNull Context context, @NonNull Uri uriFrom, @NonNull Uri uriTo) throws IOException {
        block7: {
            if (uriFrom.equals((Object)uriTo)) {
                return;
            }
            InputStream isFrom = null;
            OutputStream osTo = null;
            try {
                isFrom = context.getContentResolver().openInputStream(uriFrom);
                osTo = context.getContentResolver().openOutputStream(uriTo);
                if (isFrom instanceof FileInputStream && osTo instanceof FileOutputStream) {
                    FileChannel inputChannel = ((FileInputStream)isFrom).getChannel();
                    FileChannel outputChannel = ((FileOutputStream)osTo).getChannel();
                    inputChannel.transferTo(0L, inputChannel.size(), outputChannel);
                    break block7;
                }
                throw new IllegalArgumentException("The input or output URI don't represent a file. uCrop requires then to represent files in order to work properly.");
            }
            finally {
                if (isFrom != null) {
                    isFrom.close();
                }
                if (osTo != null) {
                    osTo.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeFileFromIS(InputStream is, OutputStream os) {
        boolean bl;
        BufferedOutputStream osBuffer = null;
        BufferedInputStream isBuffer = null;
        try {
            int len;
            isBuffer = new BufferedInputStream(is);
            osBuffer = new BufferedOutputStream(os);
            byte[] data = new byte[1024];
            while ((len = isBuffer.read(data)) != -1) {
                os.write(data, 0, len);
            }
            os.flush();
            bl = true;
        }
        catch (Exception e) {
            boolean bl2;
            try {
                e.printStackTrace();
                bl2 = false;
            }
            catch (Throwable throwable) {
                BitmapLoadUtils.close(isBuffer);
                BitmapLoadUtils.close(osBuffer);
                throw throwable;
            }
            BitmapLoadUtils.close(isBuffer);
            BitmapLoadUtils.close(osBuffer);
            return bl2;
        }
        BitmapLoadUtils.close(isBuffer);
        BitmapLoadUtils.close(osBuffer);
        return bl;
    }
}

