/*
 * Decompiled with CFR 0.152.
 */
package com.yalantis.ucrop.task;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.exifinterface.media.ExifInterface;
import com.yalantis.ucrop.callback.BitmapCropCallback;
import com.yalantis.ucrop.model.CropParameters;
import com.yalantis.ucrop.model.ExifInfo;
import com.yalantis.ucrop.model.ImageState;
import com.yalantis.ucrop.util.BitmapLoadUtils;
import com.yalantis.ucrop.util.FileUtils;
import com.yalantis.ucrop.util.ImageHeaderParser;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;

public class BitmapCropTask
extends AsyncTask<Void, Void, Throwable> {
    private static final int MIN_CROPPED_HEIGHT = 1;
    private static final String TAG = "BitmapCropTask";
    private static final String CONTENT_SCHEME = "content";
    private final WeakReference<Context> mContext;
    private Bitmap mViewBitmap;
    private final RectF mCropRect;
    private final RectF mCurrentImageRect;
    private float mCurrentScale;
    private float mCurrentAngle;
    private final int mMaxResultImageSizeX;
    private final int mMaxResultImageSizeY;
    private final Bitmap.CompressFormat mCompressFormat;
    private final int mCompressQuality;
    private final String mImageInputPath;
    private final String mImageOutputPath;
    private final Uri mImageInputUri;
    private final Uri mImageOutputUri;
    private final ExifInfo mExifInfo;
    private final BitmapCropCallback mCropCallback;
    private int mCroppedImageWidth;
    private int mCroppedImageHeight;
    private int cropOffsetX;
    private int cropOffsetY;

    public BitmapCropTask(@NonNull Context context, @Nullable Bitmap viewBitmap, @NonNull ImageState imageState, @NonNull CropParameters cropParameters, @Nullable BitmapCropCallback cropCallback) {
        this.mContext = new WeakReference<Context>(context);
        this.mViewBitmap = viewBitmap;
        this.mCropRect = imageState.getCropRect();
        this.mCurrentImageRect = imageState.getCurrentImageRect();
        this.mCurrentScale = imageState.getCurrentScale();
        this.mCurrentAngle = imageState.getCurrentAngle();
        this.mMaxResultImageSizeX = cropParameters.getMaxResultImageSizeX();
        this.mMaxResultImageSizeY = cropParameters.getMaxResultImageSizeY();
        this.mCompressFormat = cropParameters.getCompressFormat();
        this.mCompressQuality = cropParameters.getCompressQuality();
        this.mImageInputPath = cropParameters.getImageInputPath();
        this.mImageOutputPath = cropParameters.getImageOutputPath();
        this.mImageInputUri = cropParameters.getContentImageInputUri();
        this.mImageOutputUri = cropParameters.getContentImageOutputUri();
        this.mExifInfo = cropParameters.getExifInfo();
        this.mCropCallback = cropCallback;
    }

    @Nullable
    protected Throwable doInBackground(Void ... params) {
        if (this.mViewBitmap == null) {
            return new NullPointerException("ViewBitmap is null");
        }
        if (this.mViewBitmap.isRecycled()) {
            return new NullPointerException("ViewBitmap is recycled");
        }
        if (this.mCurrentImageRect.isEmpty()) {
            return new NullPointerException("CurrentImageRect is empty");
        }
        if (this.mImageOutputUri == null) {
            return new NullPointerException("ImageOutputUri is null");
        }
        try {
            this.crop();
            this.mViewBitmap = null;
        }
        catch (Throwable throwable) {
            return throwable;
        }
        return null;
    }

    private boolean crop() throws IOException {
        Context context = (Context)this.mContext.get();
        if (context == null) {
            return false;
        }
        if (this.mMaxResultImageSizeX > 0 && this.mMaxResultImageSizeY > 0) {
            float cropWidth = this.mCropRect.width() / this.mCurrentScale;
            float cropHeight = this.mCropRect.height() / this.mCurrentScale;
            if (cropWidth > (float)this.mMaxResultImageSizeX || cropHeight > (float)this.mMaxResultImageSizeY) {
                float scaleX = (float)this.mMaxResultImageSizeX / cropWidth;
                float scaleY = (float)this.mMaxResultImageSizeY / cropHeight;
                float resizeScale = Math.min(scaleX, scaleY);
                Bitmap resizedBitmap = Bitmap.createScaledBitmap((Bitmap)this.mViewBitmap, (int)Math.round((float)this.mViewBitmap.getWidth() * resizeScale), (int)Math.round((float)this.mViewBitmap.getHeight() * resizeScale), (boolean)false);
                if (this.mViewBitmap != resizedBitmap) {
                    this.mViewBitmap.recycle();
                }
                this.mViewBitmap = resizedBitmap;
                this.mCurrentScale /= resizeScale;
            }
        }
        if (this.mCurrentAngle != 0.0f) {
            Matrix tempMatrix = new Matrix();
            tempMatrix.setRotate(this.mCurrentAngle, (float)(this.mViewBitmap.getWidth() / 2), (float)(this.mViewBitmap.getHeight() / 2));
            Bitmap rotatedBitmap = Bitmap.createBitmap((Bitmap)this.mViewBitmap, (int)0, (int)0, (int)this.mViewBitmap.getWidth(), (int)this.mViewBitmap.getHeight(), (Matrix)tempMatrix, (boolean)true);
            if (this.mViewBitmap != rotatedBitmap) {
                this.mViewBitmap.recycle();
            }
            this.mViewBitmap = rotatedBitmap;
        }
        this.cropOffsetX = Math.round((this.mCropRect.left - this.mCurrentImageRect.left) / this.mCurrentScale);
        this.cropOffsetY = Math.round((this.mCropRect.top - this.mCurrentImageRect.top) / this.mCurrentScale);
        this.mCroppedImageWidth = Math.round(this.mCropRect.width() / this.mCurrentScale);
        this.mCroppedImageHeight = Math.round(this.mCropRect.height() / this.mCurrentScale);
        boolean shouldCrop = this.shouldCrop(this.mCroppedImageWidth, this.mCroppedImageHeight);
        Log.i((String)TAG, (String)("Should crop: " + shouldCrop));
        if (shouldCrop) {
            this.checkValidityCropBounds();
            this.saveImage(Bitmap.createBitmap((Bitmap)this.mViewBitmap, (int)this.cropOffsetX, (int)this.cropOffsetY, (int)this.mCroppedImageWidth, (int)this.mCroppedImageHeight));
            if (this.mCompressFormat.equals((Object)Bitmap.CompressFormat.JPEG)) {
                this.copyExifForOutputFile(context);
            }
            return true;
        }
        if (Build.VERSION.SDK_INT >= 29 && FileUtils.isContent(this.mImageInputPath)) {
            InputStream inputStream = context.getContentResolver().openInputStream(Uri.parse((String)this.mImageInputPath));
            FileUtils.writeFileFromIS(inputStream, new FileOutputStream(this.mImageOutputPath));
        } else {
            FileUtils.copyFile(this.mImageInputPath, this.mImageOutputPath);
        }
        return false;
    }

    private void checkValidityCropBounds() {
        if (this.cropOffsetX < 0) {
            this.cropOffsetX = 0;
            this.mCroppedImageWidth = this.mViewBitmap.getWidth();
        }
        if (this.cropOffsetY < 0) {
            this.cropOffsetY = 0;
            this.mCroppedImageHeight = this.mViewBitmap.getHeight();
        }
    }

    private void copyExifForOutputFile(Context context) throws IOException {
        boolean hasImageInputUriContentSchema = BitmapLoadUtils.hasContentScheme(this.mImageInputUri);
        boolean hasImageOutputUriContentSchema = BitmapLoadUtils.hasContentScheme(this.mImageOutputUri);
        if (hasImageInputUriContentSchema && hasImageOutputUriContentSchema) {
            if (Build.VERSION.SDK_INT >= 21) {
                ImageHeaderParser.copyExif(context, this.mCroppedImageWidth, this.mCroppedImageHeight, this.mImageInputUri, this.mImageOutputUri);
            } else {
                Log.e((String)TAG, (String)"It is not possible to write exif info into file represented by \"content\" Uri if Android < LOLLIPOP");
            }
        } else if (hasImageInputUriContentSchema) {
            ImageHeaderParser.copyExif(context, this.mCroppedImageWidth, this.mCroppedImageHeight, this.mImageInputUri, this.mImageOutputPath);
        } else if (hasImageOutputUriContentSchema) {
            if (Build.VERSION.SDK_INT >= 21) {
                ExifInterface originalExif = new ExifInterface(this.mImageInputPath);
                ImageHeaderParser.copyExif(context, originalExif, this.mCroppedImageWidth, this.mCroppedImageHeight, this.mImageOutputUri);
            } else {
                Log.e((String)TAG, (String)"It is not possible to write exif info into file represented by \"content\" Uri if Android < LOLLIPOP");
            }
        } else {
            ExifInterface originalExif = new ExifInterface(this.mImageInputPath);
            ImageHeaderParser.copyExif(originalExif, this.mCroppedImageWidth, this.mCroppedImageHeight, this.mImageOutputPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveImage(@NonNull Bitmap croppedBitmap) {
        Context context = (Context)this.mContext.get();
        if (context == null) {
            return;
        }
        OutputStream outputStream = null;
        ByteArrayOutputStream outStream = null;
        try {
            outputStream = context.getContentResolver().openOutputStream(this.mImageOutputUri);
            outStream = new ByteArrayOutputStream();
            croppedBitmap.compress(this.mCompressFormat, this.mCompressQuality, (OutputStream)outStream);
            outputStream.write(outStream.toByteArray());
            croppedBitmap.recycle();
        }
        catch (IOException exc) {
            try {
                Log.e((String)TAG, (String)exc.getLocalizedMessage());
            }
            catch (Throwable throwable) {
                BitmapLoadUtils.close(outputStream);
                BitmapLoadUtils.close(outStream);
                throw throwable;
            }
            BitmapLoadUtils.close(outputStream);
            BitmapLoadUtils.close(outStream);
        }
        BitmapLoadUtils.close(outputStream);
        BitmapLoadUtils.close(outStream);
    }

    private boolean shouldCrop(int width, int height) {
        int pixelError = 1;
        return this.mMaxResultImageSizeX > 0 && this.mMaxResultImageSizeY > 0 || Math.abs(this.mCropRect.left - this.mCurrentImageRect.left) > (float)(pixelError += Math.round((float)Math.max(width, height) / 1000.0f)) || Math.abs(this.mCropRect.top - this.mCurrentImageRect.top) > (float)pixelError || Math.abs(this.mCropRect.bottom - this.mCurrentImageRect.bottom) > (float)pixelError || Math.abs(this.mCropRect.right - this.mCurrentImageRect.right) > (float)pixelError || this.mCurrentAngle != 0.0f;
    }

    protected void onPostExecute(@Nullable Throwable t) {
        if (this.mCropCallback != null) {
            if (t == null) {
                Uri uri = BitmapLoadUtils.hasContentScheme(this.mImageOutputUri) ? this.mImageOutputUri : Uri.fromFile((File)new File(this.mImageOutputPath));
                this.mCropCallback.onBitmapCropped(uri, this.cropOffsetX, this.cropOffsetY, this.mCroppedImageWidth, this.mCroppedImageHeight);
            } else {
                this.mCropCallback.onCropFailure(t);
            }
        }
    }
}

