/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.TextPaint;
import android.util.AttributeSet;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatTextView;
import com.luck.picture.lib.R;

public class MediumBoldTextView
extends AppCompatTextView {
    private float mStrokeWidth = 0.6f;

    public MediumBoldTextView(Context context) {
        super(context);
        this.initView(context, null);
    }

    public MediumBoldTextView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initView(context, attrs);
    }

    private void initView(Context context, @Nullable AttributeSet attrs) {
        if (attrs != null) {
            TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.PsMediumBoldTextView);
            this.mStrokeWidth = array.getFloat(R.styleable.PsMediumBoldTextView_stroke_Width, this.mStrokeWidth);
        }
    }

    protected void onDraw(Canvas canvas) {
        TextPaint paint = this.getPaint();
        if (paint.getStrokeWidth() != this.mStrokeWidth) {
            paint.setStrokeWidth(this.mStrokeWidth);
            paint.setStyle(Paint.Style.FILL_AND_STROKE);
        }
        super.onDraw(canvas);
    }

    public void setStrokeWidth(float mStrokeWidth) {
        this.mStrokeWidth = mStrokeWidth;
        this.invalidate();
    }
}

