/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.utils;

import android.content.Context;
import android.text.TextUtils;
import android.widget.Toast;
import com.luck.picture.lib.app.PictureAppMaster;
import com.luck.picture.lib.thread.PictureThreadUtils;

public class ToastUtils {
    private static final long TIME = 1000L;
    private static long lastClickTime;
    private static String mLastText;

    public static void showToast(final Context context, final String text) {
        if (ToastUtils.isFastDoubleClick() && TextUtils.equals((CharSequence)text, (CharSequence)mLastText)) {
            return;
        }
        Context appContext = PictureAppMaster.getInstance().getAppContext();
        if (appContext == null) {
            appContext = context.getApplicationContext();
        }
        if (PictureThreadUtils.isInUiThread()) {
            Toast.makeText((Context)appContext, (CharSequence)text, (int)0).show();
            mLastText = text;
        } else {
            PictureThreadUtils.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    Context appContext = PictureAppMaster.getInstance().getAppContext();
                    if (appContext == null) {
                        appContext = context.getApplicationContext();
                    }
                    Toast.makeText((Context)appContext, (CharSequence)text, (int)0).show();
                    mLastText = text;
                }
            });
        }
    }

    public static boolean isFastDoubleClick() {
        long time = System.currentTimeMillis();
        if (time - lastClickTime < 1000L) {
            return true;
        }
        lastClickTime = time;
        return false;
    }
}

