/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import com.luck.picture.lib.R;
import com.luck.picture.lib.utils.ValueOf;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public class DateUtils {
    @SuppressLint(value={"SimpleDateFormat"})
    private static final SimpleDateFormat sf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
    @SuppressLint(value={"SimpleDateFormat"})
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");

    public static long getCurrentTimeMillis() {
        String timeToString = ValueOf.toString(System.currentTimeMillis());
        return ValueOf.toLong(timeToString.length() > 10 ? timeToString.substring(0, 10) : timeToString);
    }

    public static String getDataFormat(Context context, long time) {
        long l = time = String.valueOf(time).length() > 10 ? time : time * 1000L;
        if (DateUtils.isThisWeek(time)) {
            return context.getString(R.string.ps_current_week);
        }
        if (DateUtils.isThisMonth(time)) {
            return context.getString(R.string.ps_current_month);
        }
        return sdf.format(time);
    }

    private static boolean isThisWeek(long time) {
        Calendar calendar = Calendar.getInstance();
        int currentWeek = calendar.get(3);
        calendar.setTime(new Date(time));
        int paramWeek = calendar.get(3);
        return paramWeek == currentWeek;
    }

    public static boolean isThisMonth(long time) {
        Date date = new Date(time);
        String param = sdf.format(date);
        String now = sdf.format(new Date());
        return param.equals(now);
    }

    public static int dateDiffer(long d) {
        try {
            long l1 = DateUtils.getCurrentTimeMillis();
            long interval = l1 - d;
            return (int)Math.abs(interval);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static String formatDurationTime(long duration) {
        return String.format(Locale.getDefault(), "%02d:%02d", TimeUnit.MILLISECONDS.toMinutes(duration), TimeUnit.MILLISECONDS.toSeconds(duration) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(duration)));
    }

    public static String getCreateFileName(String prefix) {
        long millis = System.currentTimeMillis();
        return prefix + sf.format(millis);
    }

    public static String getCreateFileName() {
        long millis = System.currentTimeMillis();
        return sf.format(millis);
    }

    public static String cdTime(long sTime, long eTime) {
        long diff = eTime - sTime;
        return diff > 1000L ? diff / 1000L + "\u79d2" : diff + "\u6beb\u79d2";
    }
}

