/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.loader;

import android.content.Context;
import android.net.Uri;
import android.provider.MediaStore;
import android.text.TextUtils;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.config.PictureSelectionConfig;
import com.luck.picture.lib.config.SelectMimeType;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.entity.LocalMediaFolder;
import com.luck.picture.lib.interfaces.OnQueryAlbumListener;
import com.luck.picture.lib.interfaces.OnQueryAllAlbumListener;
import com.luck.picture.lib.interfaces.OnQueryDataResultListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class IBridgeMediaLoader {
    protected static final String TAG = IBridgeMediaLoader.class.getSimpleName();
    protected static final Uri QUERY_URI = MediaStore.Files.getContentUri((String)"external");
    protected static final String ORDER_BY = "date_modified DESC";
    protected static final String NOT_GIF_UNKNOWN = "!='image/*'";
    protected static final String NOT_GIF = " AND (mime_type!='image/gif' AND mime_type!='image/*')";
    protected static final String GROUP_BY_BUCKET_Id = " GROUP BY (bucket_id";
    protected static final String COLUMN_COUNT = "count";
    protected static final String COLUMN_BUCKET_ID = "bucket_id";
    protected static final String COLUMN_DURATION = "duration";
    protected static final String COLUMN_BUCKET_DISPLAY_NAME = "bucket_display_name";
    protected static final int MAX_SORT_SIZE = 60;
    protected Context mContext;
    protected PictureSelectionConfig config;
    protected static final String[] PROJECTION = new String[]{"_id", "_data", "mime_type", "width", "height", "duration", "_size", "bucket_display_name", "_display_name", "bucket_id", "date_added"};

    public void loadAllMedia(OnQueryAllAlbumListener<LocalMediaFolder> query) {
    }

    public void loadOnlyInAppDirAllMedia(OnQueryAlbumListener<LocalMediaFolder> query) {
    }

    public void loadFirstPageMedia(long bucketId, int pageSize, OnQueryDataResultListener<LocalMedia> query) {
    }

    public void loadPageMediaData(long bucketId, int page, int pageSize, OnQueryDataResultListener<LocalMedia> query) {
    }

    public void loadPageMediaData(long bucketId, int page, int limit, int pageSize, OnQueryDataResultListener<LocalMedia> query) {
    }

    public String getFirstCover(long bucketId) {
        return null;
    }

    protected static String[] getSelectionArgsForSingleMediaType(int mediaType) {
        return new String[]{String.valueOf(mediaType)};
    }

    protected static String[] getSelectionArgsForAllMediaType() {
        return new String[]{String.valueOf(1), String.valueOf(3)};
    }

    protected String getDurationCondition() {
        long maxS = this.config.filterVideoMaxSecond == 0 ? Long.MAX_VALUE : (long)this.config.filterVideoMaxSecond;
        return String.format(Locale.CHINA, "%d <%s duration and duration <= %d", Math.max(0L, (long)this.config.filterVideoMinSecond), Math.max(0L, (long)this.config.filterVideoMinSecond) == 0L ? "" : "=", maxS);
    }

    protected String getFileSizeCondition() {
        long maxS = this.config.filterMaxFileSize == 0L ? Long.MAX_VALUE : this.config.filterMaxFileSize;
        return String.format(Locale.CHINA, "%d <%s _size and _size <= %d", Math.max(0L, this.config.filterMinFileSize), Math.max(0L, this.config.filterMinFileSize) == 0L ? "" : "=", maxS);
    }

    protected String getQueryMimeCondition() {
        List<String> filters = this.config.queryOnlyList;
        HashSet<String> filterSet = new HashSet<String>(filters);
        Iterator<String> iterator = filterSet.iterator();
        StringBuilder stringBuilder = new StringBuilder();
        int index = -1;
        while (iterator.hasNext()) {
            String value = iterator.next();
            if (TextUtils.isEmpty((CharSequence)value)) continue;
            if (this.config.chooseMode == SelectMimeType.ofVideo()) {
                if (value.startsWith("image") || value.startsWith("audio")) {
                    continue;
                }
            } else if (this.config.chooseMode != SelectMimeType.ofImage() ? this.config.chooseMode == SelectMimeType.ofAudio() && (value.startsWith("video") || value.startsWith("image")) : value.startsWith("audio") || value.startsWith("video")) continue;
            stringBuilder.append(++index == 0 ? " AND " : " OR ").append("mime_type").append("='").append(value).append("'");
        }
        if (this.config.chooseMode != SelectMimeType.ofVideo() && !this.config.isGif && !filterSet.contains(PictureMimeType.ofGIF())) {
            stringBuilder.append(NOT_GIF);
        }
        return stringBuilder.toString();
    }
}

