/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.adapter.holder;

import android.view.View;
import android.widget.TextView;
import com.luck.picture.lib.R;
import com.luck.picture.lib.adapter.holder.BaseRecyclerMediaHolder;
import com.luck.picture.lib.config.PictureSelectionConfig;
import com.luck.picture.lib.config.SelectMimeType;
import com.luck.picture.lib.style.SelectMainStyle;
import com.luck.picture.lib.utils.StyleUtils;

public class CameraViewHolder
extends BaseRecyclerMediaHolder {
    public CameraViewHolder(View itemView) {
        super(itemView);
        int textColor;
        String text;
        int drawableTop;
        TextView tvCamera = (TextView)itemView.findViewById(R.id.tvCamera);
        SelectMainStyle adapterStyle = PictureSelectionConfig.selectorStyle.getSelectMainStyle();
        int background = adapterStyle.getAdapterCameraBackgroundColor();
        if (StyleUtils.checkStyleValidity(background)) {
            tvCamera.setBackgroundColor(background);
        }
        if (StyleUtils.checkStyleValidity(drawableTop = adapterStyle.getAdapterCameraDrawableTop())) {
            tvCamera.setCompoundDrawablesRelativeWithIntrinsicBounds(0, drawableTop, 0, 0);
        }
        if (StyleUtils.checkTextValidity(text = adapterStyle.getAdapterCameraText())) {
            tvCamera.setText((CharSequence)text);
        } else if (PictureSelectionConfig.getInstance().chooseMode == SelectMimeType.ofAudio()) {
            tvCamera.setText((CharSequence)itemView.getContext().getString(R.string.ps_tape));
        }
        int textSize = adapterStyle.getAdapterCameraTextSize();
        if (StyleUtils.checkSizeValidity(textSize)) {
            tvCamera.setTextSize((float)textSize);
        }
        if (StyleUtils.checkStyleValidity(textColor = adapterStyle.getAdapterCameraTextColor())) {
            tvCamera.setTextColor(textColor);
        }
    }
}

