/*
 * Decompiled with CFR 0.152.
 */
package top.zibin.luban.io;

import java.util.ArrayDeque;
import java.util.Queue;
import top.zibin.luban.io.PoolAble;

abstract class BaseKeyPool<T extends PoolAble> {
    private static final int MAX_SIZE = 20;
    private final Queue<T> keyPool = BaseKeyPool.createQueue(20);

    BaseKeyPool() {
    }

    T get() {
        PoolAble result = (PoolAble)this.keyPool.poll();
        if (result == null) {
            result = this.create();
        }
        return (T)result;
    }

    public void offer(T key) {
        if (this.keyPool.size() < 20) {
            this.keyPool.offer(key);
        }
    }

    public static <T> Queue<T> createQueue(int size) {
        return new ArrayDeque(size);
    }

    abstract T create();
}

