/*
 * Decompiled with CFR 0.152.
 */
package org.lognet.springboot.grpc.autoconfigure;

import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import org.lognet.springboot.grpc.context.GRpcServerInitializedEvent;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.event.EventListener;
import org.springframework.core.io.Resource;
import org.springframework.util.unit.DataSize;

@ConfigurationProperties(value="grpc")
public class GRpcServerProperties
implements InitializingBean {
    public static final int DEFAULT_GRPC_PORT = 6565;
    private Integer port = null;
    private SecurityProperties security;
    private RecoveryProperties recovery;
    private NettyServerProperties nettyServer;
    private volatile Integer runningPort = null;
    private int startUpPhase = Integer.MAX_VALUE;
    private boolean enabled = true;
    private String inProcessServerName;
    private boolean enableReflection = false;
    private int shutdownGrace = 0;

    @EventListener
    public void onServerStarted(GRpcServerInitializedEvent event) {
        this.runningPort = event.getServer().getPort();
    }

    public Integer getPortOrDefault() {
        return Optional.ofNullable(this.port).orElse(6565);
    }

    public Integer getRunningPort() {
        return this.runningPort;
    }

    public void afterPropertiesSet() throws Exception {
        Optional.ofNullable(this.nettyServer).map(NettyServerProperties::getPrimaryListenAddress).ifPresent(a -> {
            this.port = a.getPort();
        });
    }

    public Integer getPort() {
        return this.port;
    }

    public SecurityProperties getSecurity() {
        return this.security;
    }

    public RecoveryProperties getRecovery() {
        return this.recovery;
    }

    public NettyServerProperties getNettyServer() {
        return this.nettyServer;
    }

    public int getStartUpPhase() {
        return this.startUpPhase;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getInProcessServerName() {
        return this.inProcessServerName;
    }

    public boolean isEnableReflection() {
        return this.enableReflection;
    }

    public int getShutdownGrace() {
        return this.shutdownGrace;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setSecurity(SecurityProperties security) {
        this.security = security;
    }

    public void setRecovery(RecoveryProperties recovery) {
        this.recovery = recovery;
    }

    public void setNettyServer(NettyServerProperties nettyServer) {
        this.nettyServer = nettyServer;
    }

    public void setStartUpPhase(int startUpPhase) {
        this.startUpPhase = startUpPhase;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setInProcessServerName(String inProcessServerName) {
        this.inProcessServerName = inProcessServerName;
    }

    public void setEnableReflection(boolean enableReflection) {
        this.enableReflection = enableReflection;
    }

    public void setShutdownGrace(int shutdownGrace) {
        this.shutdownGrace = shutdownGrace;
    }

    public static class NettyServerProperties {
        private boolean onCollisionPreferShadedNetty;
        private Integer flowControlWindow;
        private Integer initialFlowControlWindow;
        private Integer maxConcurrentCallsPerConnection;
        private Duration keepAliveTime;
        private Duration keepAliveTimeout;
        private Duration maxConnectionAge;
        private Duration maxConnectionAgeGrace;
        private Duration maxConnectionIdle;
        private Duration permitKeepAliveTime;
        private DataSize maxInboundMessageSize;
        private DataSize maxInboundMetadataSize;
        private Boolean permitKeepAliveWithoutCalls;
        private InetSocketAddress primaryListenAddress;
        private List<InetSocketAddress> additionalListenAddresses;

        public boolean isOnCollisionPreferShadedNetty() {
            return this.onCollisionPreferShadedNetty;
        }

        public Integer getFlowControlWindow() {
            return this.flowControlWindow;
        }

        public Integer getInitialFlowControlWindow() {
            return this.initialFlowControlWindow;
        }

        public Integer getMaxConcurrentCallsPerConnection() {
            return this.maxConcurrentCallsPerConnection;
        }

        public Duration getKeepAliveTime() {
            return this.keepAliveTime;
        }

        public Duration getKeepAliveTimeout() {
            return this.keepAliveTimeout;
        }

        public Duration getMaxConnectionAge() {
            return this.maxConnectionAge;
        }

        public Duration getMaxConnectionAgeGrace() {
            return this.maxConnectionAgeGrace;
        }

        public Duration getMaxConnectionIdle() {
            return this.maxConnectionIdle;
        }

        public Duration getPermitKeepAliveTime() {
            return this.permitKeepAliveTime;
        }

        public DataSize getMaxInboundMessageSize() {
            return this.maxInboundMessageSize;
        }

        public DataSize getMaxInboundMetadataSize() {
            return this.maxInboundMetadataSize;
        }

        public Boolean getPermitKeepAliveWithoutCalls() {
            return this.permitKeepAliveWithoutCalls;
        }

        public InetSocketAddress getPrimaryListenAddress() {
            return this.primaryListenAddress;
        }

        public List<InetSocketAddress> getAdditionalListenAddresses() {
            return this.additionalListenAddresses;
        }

        public void setOnCollisionPreferShadedNetty(boolean onCollisionPreferShadedNetty) {
            this.onCollisionPreferShadedNetty = onCollisionPreferShadedNetty;
        }

        public void setFlowControlWindow(Integer flowControlWindow) {
            this.flowControlWindow = flowControlWindow;
        }

        public void setInitialFlowControlWindow(Integer initialFlowControlWindow) {
            this.initialFlowControlWindow = initialFlowControlWindow;
        }

        public void setMaxConcurrentCallsPerConnection(Integer maxConcurrentCallsPerConnection) {
            this.maxConcurrentCallsPerConnection = maxConcurrentCallsPerConnection;
        }

        public void setKeepAliveTime(Duration keepAliveTime) {
            this.keepAliveTime = keepAliveTime;
        }

        public void setKeepAliveTimeout(Duration keepAliveTimeout) {
            this.keepAliveTimeout = keepAliveTimeout;
        }

        public void setMaxConnectionAge(Duration maxConnectionAge) {
            this.maxConnectionAge = maxConnectionAge;
        }

        public void setMaxConnectionAgeGrace(Duration maxConnectionAgeGrace) {
            this.maxConnectionAgeGrace = maxConnectionAgeGrace;
        }

        public void setMaxConnectionIdle(Duration maxConnectionIdle) {
            this.maxConnectionIdle = maxConnectionIdle;
        }

        public void setPermitKeepAliveTime(Duration permitKeepAliveTime) {
            this.permitKeepAliveTime = permitKeepAliveTime;
        }

        public void setMaxInboundMessageSize(DataSize maxInboundMessageSize) {
            this.maxInboundMessageSize = maxInboundMessageSize;
        }

        public void setMaxInboundMetadataSize(DataSize maxInboundMetadataSize) {
            this.maxInboundMetadataSize = maxInboundMetadataSize;
        }

        public void setPermitKeepAliveWithoutCalls(Boolean permitKeepAliveWithoutCalls) {
            this.permitKeepAliveWithoutCalls = permitKeepAliveWithoutCalls;
        }

        public void setPrimaryListenAddress(InetSocketAddress primaryListenAddress) {
            this.primaryListenAddress = primaryListenAddress;
        }

        public void setAdditionalListenAddresses(List<InetSocketAddress> additionalListenAddresses) {
            this.additionalListenAddresses = additionalListenAddresses;
        }
    }

    public static class SecurityProperties {
        private Resource certChain;
        private Resource privateKey;
        private Auth auth;

        public Resource getCertChain() {
            return this.certChain;
        }

        public Resource getPrivateKey() {
            return this.privateKey;
        }

        public Auth getAuth() {
            return this.auth;
        }

        public void setCertChain(Resource certChain) {
            this.certChain = certChain;
        }

        public void setPrivateKey(Resource privateKey) {
            this.privateKey = privateKey;
        }

        public void setAuth(Auth auth) {
            this.auth = auth;
        }

        public static class Auth {
            private Integer interceptorOrder;
            private boolean failFast = true;

            public Integer getInterceptorOrder() {
                return this.interceptorOrder;
            }

            public boolean isFailFast() {
                return this.failFast;
            }

            public void setInterceptorOrder(Integer interceptorOrder) {
                this.interceptorOrder = interceptorOrder;
            }

            public void setFailFast(boolean failFast) {
                this.failFast = failFast;
            }
        }
    }

    public static class RecoveryProperties {
        private Integer interceptorOrder;

        public Integer getInterceptorOrder() {
            return this.interceptorOrder;
        }

        public void setInterceptorOrder(Integer interceptorOrder) {
            this.interceptorOrder = interceptorOrder;
        }
    }
}

