/*
 * Decompiled with CFR 0.152.
 */
package org.lognet.springboot.grpc.autoconfigure;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Optional;
import org.lognet.springboot.grpc.autoconfigure.ConditionalOnMissingErrorHandler;
import org.lognet.springboot.grpc.recovery.GRpcExceptionHandler;
import org.lognet.springboot.grpc.recovery.GRpcServiceAdvice;
import org.lognet.springboot.grpc.recovery.HandlerMethod;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.ReflectionUtils;

public class OnMissingErrorHandlerCondition
extends SpringBootCondition {
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        Class exc = (Class)metadata.getAnnotationAttributes(ConditionalOnMissingErrorHandler.class.getName()).get("value");
        ReflectionUtils.MethodFilter f = method -> AnnotatedElementUtils.hasAnnotation((AnnotatedElement)method, GRpcExceptionHandler.class);
        for (String adviceBeanName : context.getBeanFactory().getBeanNamesForAnnotation(GRpcServiceAdvice.class)) {
            String beanClassName = context.getBeanFactory().getBeanDefinition(adviceBeanName).getBeanClassName();
            try {
                for (Method method2 : MethodIntrospector.selectMethods(Class.forName(beanClassName), (ReflectionUtils.MethodFilter)f)) {
                    Optional<Class<? extends Throwable>> handledException = HandlerMethod.getHandledException(method2, false);
                    if (!handledException.isPresent() || !handledException.get().isAssignableFrom(exc)) continue;
                    return ConditionOutcome.noMatch((String)String.format("Found %s handler at %s.%s", handledException.get().getName(), beanClassName, method2.getName()));
                }
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }
        return ConditionOutcome.match();
    }
}

