// Generated by delombok at Sun Aug 16 14:24:28 UTC 2020
package org.lognet.springboot.grpc.autoconfigure;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.core.io.Resource;
import org.springframework.util.SocketUtils;
import java.util.Optional;

/**
 * Created by alexf on 26-Jan-16.
 */
@ConfigurationProperties("grpc")
public class GRpcServerProperties {
    public static final int DEFAULT_GRPC_PORT = 6565;
    /**
     * gRPC server port
     */
    private Integer port = null;
    private SecurityProperties security;
    private volatile Integer runningPort = null;
    /**
     * Enables the embedded grpc server.
     */
    private boolean enabled = true;
    /**
     * In process server name.
     * If  the value is not empty, the embedded in-process server will be created and started.
     */
    private String inProcessServerName;
    /**
     * Enables server reflection using <a href="https://github.com/grpc/grpc-java/blob/master/documentation/server-reflection-tutorial.md">ProtoReflectionService</a>.
     * Available only from gRPC 1.3 or higher.
     */
    private boolean enableReflection = false;
    /**
     * Number of seconds to wait for preexisting calls to finish before shutting down.
     * A negative value is equivalent to an infinite grace period
     */
    private int shutdownGrace = 0;

    public Integer getRunningPort() {
        if (null == runningPort) {
            synchronized (this) {
                if (null == runningPort) {
                    runningPort = Optional.ofNullable(port).map(p -> 0 == p ? SocketUtils.findAvailableTcpPort() : p).orElse(DEFAULT_GRPC_PORT);
                }
            }
        }
        return runningPort;
    }


    public static class SecurityProperties {
        private Resource certChain;
        private Resource privateKey;

        @java.lang.SuppressWarnings("all")
        public Resource getCertChain() {
            return this.certChain;
        }

        @java.lang.SuppressWarnings("all")
        public Resource getPrivateKey() {
            return this.privateKey;
        }

        @java.lang.SuppressWarnings("all")
        public void setCertChain(final Resource certChain) {
            this.certChain = certChain;
        }

        @java.lang.SuppressWarnings("all")
        public void setPrivateKey(final Resource privateKey) {
            this.privateKey = privateKey;
        }
    }

    /**
     * gRPC server port
     */
    @java.lang.SuppressWarnings("all")
    public Integer getPort() {
        return this.port;
    }

    @java.lang.SuppressWarnings("all")
    public SecurityProperties getSecurity() {
        return this.security;
    }

    /**
     * Enables the embedded grpc server.
     */
    @java.lang.SuppressWarnings("all")
    public boolean isEnabled() {
        return this.enabled;
    }

    /**
     * In process server name.
     * If  the value is not empty, the embedded in-process server will be created and started.
     */
    @java.lang.SuppressWarnings("all")
    public String getInProcessServerName() {
        return this.inProcessServerName;
    }

    /**
     * Enables server reflection using <a href="https://github.com/grpc/grpc-java/blob/master/documentation/server-reflection-tutorial.md">ProtoReflectionService</a>.
     * Available only from gRPC 1.3 or higher.
     */
    @java.lang.SuppressWarnings("all")
    public boolean isEnableReflection() {
        return this.enableReflection;
    }

    /**
     * Number of seconds to wait for preexisting calls to finish before shutting down.
     * A negative value is equivalent to an infinite grace period
     */
    @java.lang.SuppressWarnings("all")
    public int getShutdownGrace() {
        return this.shutdownGrace;
    }

    /**
     * gRPC server port
     */
    @java.lang.SuppressWarnings("all")
    public void setPort(final Integer port) {
        this.port = port;
    }

    @java.lang.SuppressWarnings("all")
    public void setSecurity(final SecurityProperties security) {
        this.security = security;
    }

    /**
     * Enables the embedded grpc server.
     */
    @java.lang.SuppressWarnings("all")
    public void setEnabled(final boolean enabled) {
        this.enabled = enabled;
    }

    /**
     * In process server name.
     * If  the value is not empty, the embedded in-process server will be created and started.
     */
    @java.lang.SuppressWarnings("all")
    public void setInProcessServerName(final String inProcessServerName) {
        this.inProcessServerName = inProcessServerName;
    }

    /**
     * Enables server reflection using <a href="https://github.com/grpc/grpc-java/blob/master/documentation/server-reflection-tutorial.md">ProtoReflectionService</a>.
     * Available only from gRPC 1.3 or higher.
     */
    @java.lang.SuppressWarnings("all")
    public void setEnableReflection(final boolean enableReflection) {
        this.enableReflection = enableReflection;
    }

    /**
     * Number of seconds to wait for preexisting calls to finish before shutting down.
     * A negative value is equivalent to an infinite grace period
     */
    @java.lang.SuppressWarnings("all")
    public void setShutdownGrace(final int shutdownGrace) {
        this.shutdownGrace = shutdownGrace;
    }
}
