/*
 * Decompiled with CFR 0.152.
 */
package org.lognet.springboot.grpc.context;

import java.util.Properties;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.util.SocketUtils;

public class GRpcServerEnvironment
implements EnvironmentPostProcessor {
    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        MutablePropertySources sources = environment.getPropertySources();
        Properties properties = new Properties();
        Integer configuredPort = (Integer)environment.getProperty("grpc.port", Integer.class);
        properties.put("grpc.port", (Object)0);
        if (null == configuredPort) {
            properties.put("local.grpc.port", (Object)6565);
        } else if (0 == configuredPort) {
            properties.put("local.grpc.port", (Object)SocketUtils.findAvailableTcpPort());
        } else {
            properties.put("grpc.port", configuredPort);
            properties.put("local.grpc.port", configuredPort);
        }
        sources.addLast((PropertySource)new PropertiesPropertySource("grpc", properties));
    }
}

