/*
 * Decompiled with CFR 0.152.
 */
package io.github.linpeilie;

import io.github.linpeilie.BaseCycleAvoidingMapper;
import io.github.linpeilie.BaseMapMapper;
import io.github.linpeilie.BaseMapper;
import io.github.linpeilie.ConvertException;
import io.github.linpeilie.ConverterFactory;
import io.github.linpeilie.CycleAvoidingMappingContext;
import io.github.linpeilie.DefaultConverterFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class Converter {
    private final ConverterFactory converterFactory;

    public Converter() {
        this.converterFactory = new DefaultConverterFactory();
    }

    public Converter(ConverterFactory converterFactory) {
        this.converterFactory = converterFactory;
    }

    public <S, T> T convert(S source, Class<T> targetType) {
        if (source == null) {
            return null;
        }
        BaseMapper<?, T> mapper = this.converterFactory.getMapper(source.getClass(), targetType);
        if (mapper != null) {
            return mapper.convert(source);
        }
        throw new ConvertException("cannot find converter from " + source.getClass().getSimpleName() + " to " + targetType.getSimpleName());
    }

    public <S, T> T convert(S source, T target) {
        if (source == null) {
            return null;
        }
        if (target == null) {
            return null;
        }
        BaseMapper<?, ?> mapper = this.converterFactory.getMapper(source.getClass(), target.getClass());
        if (mapper != null) {
            return (T)mapper.convert(source, target);
        }
        throw new ConvertException("cannot find converter from " + source.getClass().getSimpleName() + " to " + target.getClass().getSimpleName());
    }

    public <S, T> List<T> convert(List<S> source, Class<T> targetType) {
        if (source == null || source.isEmpty()) {
            return new ArrayList();
        }
        return source.stream().map(item -> this.convert((Object)item, (Object)targetType)).collect(Collectors.toList());
    }

    public <S, T> T convert(S source, Class<T> target, CycleAvoidingMappingContext context) {
        if (source == null) {
            return null;
        }
        BaseCycleAvoidingMapper<?, CycleAvoidingMappingContext> mapper = this.converterFactory.getCycleAvoidingMapper(source.getClass(), target);
        if (mapper != null) {
            return (T)mapper.convert(source, context);
        }
        throw new ConvertException("cannot find converter from " + source.getClass().getSimpleName() + " to " + target.getSimpleName());
    }

    public <S, T> List<T> convert(List<S> source, Class<T> targetType, CycleAvoidingMappingContext context) {
        if (source == null || source.isEmpty()) {
            return new ArrayList();
        }
        return source.stream().map(item -> this.convert(item, targetType, context)).collect(Collectors.toList());
    }

    public <T> T convert(Map<String, Object> map, Class<T> target) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        if (map.values().stream().allMatch(Objects::isNull)) {
            return null;
        }
        BaseMapMapper<T> mapper = this.converterFactory.getMapMapper(target);
        if (mapper != null) {
            return mapper.convert(map);
        }
        throw new ConvertException("cannot find converter from " + map.getClass().getName() + " to " + target.getSimpleName());
    }
}

