/*
 * Decompiled with CFR 0.152.
 */
package com.tlf.AliPay;

import com.alibaba.fastjson.JSONObject;
import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayClient;
import com.alipay.api.AlipayRequest;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.request.AlipayTradeCloseRequest;
import com.alipay.api.request.AlipayTradePagePayRequest;
import com.alipay.api.request.AlipayTradePrecreateRequest;
import com.alipay.api.request.AlipayTradeQueryRequest;
import com.alipay.api.response.AlipayTradeCloseResponse;
import com.alipay.api.response.AlipayTradePagePayResponse;
import com.alipay.api.response.AlipayTradePrecreateResponse;
import com.alipay.api.response.AlipayTradeQueryResponse;
import com.tlf.AliPay.AliPayConfig;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliPayApi {
    private static final Logger log = LoggerFactory.getLogger(AliPayApi.class);
    private static AlipayClient alipayClient = null;
    private static AlipayClient sandboxAalipayClient = null;

    private static void init(boolean isSandBox, AliPayConfig aliPayConfig) {
        if (isSandBox) {
            sandboxAalipayClient = new DefaultAlipayClient(aliPayConfig.getTEST_SERVERURL(), aliPayConfig.getTEST_APP_ID(), aliPayConfig.getTEST_APP_PRIVATE_KEY(), aliPayConfig.getFORMAT(), aliPayConfig.getCHARSET(), aliPayConfig.getTEST_ALIPAY_PUBLIC_KEY(), aliPayConfig.getSIGN_TYPE());
        } else {
            alipayClient = new DefaultAlipayClient(aliPayConfig.getSERVERURL(), aliPayConfig.getAPP_ID(), aliPayConfig.getAPP_PRIVATE_KEY(), aliPayConfig.getFORMAT(), aliPayConfig.getCHARSET(), aliPayConfig.getALIPAY_PUBLIC_KEY(), aliPayConfig.getSIGN_TYPE());
        }
    }

    public static String pcQrCodeForm(String out_trade_no, BigDecimal money, String goodTitle, String time_expire, boolean isSandBox, AliPayConfig aliPayConfig) {
        AliPayApi.init(isSandBox, aliPayConfig);
        AlipayTradePagePayRequest alipayRequest = new AlipayTradePagePayRequest();
        if (isSandBox) {
            alipayRequest.setReturnUrl(aliPayConfig.getTEST_RETURN_URL());
            alipayRequest.setNotifyUrl(aliPayConfig.getTEST_NOTIFY_URL());
        } else {
            alipayRequest.setReturnUrl(aliPayConfig.getRETURN_URL());
            alipayRequest.setNotifyUrl(aliPayConfig.getNOTIFY_URL());
        }
        JSONObject params = new JSONObject();
        params.put("out_trade_no", (Object)out_trade_no);
        params.put("total_amount", (Object)money);
        params.put("subject", (Object)goodTitle);
        params.put("product_code", (Object)"FAST_INSTANT_TRADE_PAY");
        params.put("qr_pay_mode", (Object)2);
        params.put("qrcode_width", (Object)200);
        params.put("time_expire", (Object)time_expire);
        alipayRequest.setBizContent(params.toString());
        String form = null;
        try {
            AlipayTradePagePayResponse alipayResponse = null;
            alipayResponse = isSandBox ? (AlipayTradePagePayResponse)sandboxAalipayClient.pageExecute((AlipayRequest)alipayRequest) : (AlipayTradePagePayResponse)alipayClient.pageExecute((AlipayRequest)alipayRequest);
            if (alipayResponse.isSuccess()) {
                log.info("\u652f\u4ed8\u5b9d >>> \u7535\u8111\u7f51\u7ad9\u652f\u4ed8 >>> \u4e0b\u5355\u6210\u529f! form = {}", (Object)alipayResponse.getBody());
                form = alipayResponse.getBody();
            } else {
                log.info("\u652f\u4ed8\u5b9d >>> \u7535\u8111\u7f51\u7ad9\u652f\u4ed8 >>> \u4e0b\u5355\u5931\u8d25! body = {}", (Object)alipayResponse.getBody());
            }
        }
        catch (AlipayApiException e) {
            e.printStackTrace();
            log.info("\u652f\u4ed8\u5b9d >>> \u7535\u8111\u7f51\u7ad9\u652f\u4ed8 >>> \u4e0b\u5355\u5f02\u5e38");
        }
        return form;
    }

    public static String qrCode(String out_trade_no, BigDecimal money, String goodTitle, String time_expire, boolean isSandBox, AliPayConfig aliPayConfig) {
        AliPayApi.init(isSandBox, aliPayConfig);
        money = money.setScale(2, 0);
        AlipayTradePrecreateRequest alipayRequest = new AlipayTradePrecreateRequest();
        if (isSandBox) {
            alipayRequest.setReturnUrl(aliPayConfig.getTEST_RETURN_URL());
            alipayRequest.setNotifyUrl(aliPayConfig.getTEST_NOTIFY_URL());
        } else {
            alipayRequest.setReturnUrl(aliPayConfig.getRETURN_URL());
            alipayRequest.setNotifyUrl(aliPayConfig.getNOTIFY_URL());
        }
        JSONObject params = new JSONObject();
        params.put("out_trade_no", (Object)out_trade_no);
        params.put("total_amount", (Object)money);
        params.put("subject", (Object)goodTitle);
        params.put("time_expire", (Object)time_expire);
        alipayRequest.setBizContent(params.toString());
        String qr_code = null;
        try {
            AlipayTradePrecreateResponse alipayResponse = null;
            alipayResponse = isSandBox ? (AlipayTradePrecreateResponse)sandboxAalipayClient.execute((AlipayRequest)alipayRequest) : (AlipayTradePrecreateResponse)alipayClient.execute((AlipayRequest)alipayRequest);
            if (alipayResponse.isSuccess()) {
                log.info("\u652f\u4ed8\u5b9d >>> \u5f53\u9762\u4ed8\uff08\u626b\u7801\u652f\u4ed8\uff09 >>> \u4e0b\u5355\u6210\u529f! qr_code = {}", (Object)alipayResponse.getQrCode());
                qr_code = alipayResponse.getQrCode();
            } else {
                log.error("\u652f\u4ed8\u5b9d >>> \u5f53\u9762\u4ed8\uff08\u626b\u7801\u652f\u4ed8\uff09 >>> \u4e0b\u5355\u5931\u8d25! sub_code = {}, sub_msg = {}", (Object)alipayResponse.getSubCode(), (Object)alipayResponse.getSubMsg());
            }
        }
        catch (AlipayApiException e) {
            e.printStackTrace();
            log.error("\u652f\u4ed8\u5b9d >>> \u5f53\u9762\u4ed8\uff08\u626b\u7801\u652f\u4ed8\uff09 >>> \u4e0b\u5355\u5f02\u5e38", (Throwable)e);
        }
        return qr_code;
    }

    public static boolean close(String out_trade_no, boolean isSandBox, AliPayConfig aliPayConfig) {
        AliPayApi.init(isSandBox, aliPayConfig);
        AlipayTradeCloseRequest alipayRequest = new AlipayTradeCloseRequest();
        if (isSandBox) {
            alipayRequest.setReturnUrl(aliPayConfig.getTEST_RETURN_URL());
            alipayRequest.setNotifyUrl(aliPayConfig.getTEST_NOTIFY_URL());
        } else {
            alipayRequest.setReturnUrl(aliPayConfig.getRETURN_URL());
            alipayRequest.setNotifyUrl(aliPayConfig.getNOTIFY_URL());
        }
        JSONObject params = new JSONObject();
        params.put("out_trade_no", (Object)out_trade_no);
        alipayRequest.setBizContent(params.toString());
        try {
            AlipayTradeCloseResponse alipayResponse = null;
            alipayResponse = isSandBox ? (AlipayTradeCloseResponse)sandboxAalipayClient.execute((AlipayRequest)alipayRequest) : (AlipayTradeCloseResponse)alipayClient.execute((AlipayRequest)alipayRequest);
            if (!alipayResponse.isSuccess()) {
                log.error("\u652f\u4ed8\u5b9d >>> \u5f53\u9762\u4ed8\uff08\u626b\u7801\u652f\u4ed8\uff09 >>> \u53d6\u6d88\u5931\u8d25! sub_code = {}, sub_msg = {}", (Object)alipayResponse.getSubCode(), (Object)alipayResponse.getSubMsg());
                return false;
            }
            log.info("\u652f\u4ed8\u5b9d >>> \u5f53\u9762\u4ed8\uff08\u626b\u7801\u652f\u4ed8\uff09 >>> \u53d6\u6d88\u6210\u529f! OutTradeNo = {}", (Object)alipayResponse.getOutTradeNo());
        }
        catch (AlipayApiException e) {
            e.printStackTrace();
            log.error("\u652f\u4ed8\u5b9d >>> \u5f53\u9762\u4ed8\uff08\u626b\u7801\u652f\u4ed8\uff09 >>> \u53d6\u6d88\u5f02\u5e38\uff01", (Throwable)e);
            return false;
        }
        return true;
    }

    public static boolean query(String out_trade_no, boolean isSandBox, AliPayConfig aliPayConfig) {
        AliPayApi.init(isSandBox, aliPayConfig);
        AlipayTradeQueryRequest request = new AlipayTradeQueryRequest();
        JSONObject params = new JSONObject();
        params.put("out_trade_no", (Object)out_trade_no);
        request.setBizContent(params.toString());
        try {
            AlipayTradeQueryResponse alipayResponse = null;
            alipayResponse = isSandBox ? (AlipayTradeQueryResponse)sandboxAalipayClient.execute((AlipayRequest)request) : (AlipayTradeQueryResponse)alipayClient.execute((AlipayRequest)request);
            if (!alipayResponse.isSuccess()) {
                log.error("\u652f\u4ed8\u5b9d >>> \u5f53\u9762\u4ed8\uff08\u626b\u7801\u652f\u4ed8\uff09 >>> \u67e5\u8be2\u5931\u8d25! sub_code = {}, sub_msg = {}", (Object)alipayResponse.getSubCode(), (Object)alipayResponse.getSubMsg());
                return false;
            }
            log.info("\u652f\u4ed8\u5b9d >>> \u5f53\u9762\u4ed8\uff08\u626b\u7801\u652f\u4ed8\uff09 >>> \u67e5\u8be2\u6210\u529f! OutTradeNo = {}", (Object)alipayResponse.getOutTradeNo());
        }
        catch (AlipayApiException e) {
            e.printStackTrace();
            log.error("\u652f\u4ed8\u5b9d >>> \u5f53\u9762\u4ed8\uff08\u626b\u7801\u652f\u4ed8\uff09 >>> \u67e5\u8be2\u5f02\u5e38\uff01", (Throwable)e);
            return false;
        }
        return true;
    }

    public static Map<String, String> transferCallBackResultToMap(HttpServletRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        Map requestParams = request.getParameterMap();
        for (String name : requestParams.keySet()) {
            String[] values = (String[])requestParams.get(name);
            String valueStr = "";
            for (int i = 0; i < values.length; ++i) {
                valueStr = i == values.length - 1 ? valueStr + values[i] : valueStr + values[i] + ",";
            }
            params.put(name, valueStr);
        }
        return params;
    }
}

