/*
 * Decompiled with CFR 0.152.
 */
package me.leavestyle.handler;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.leavestyle.common.JsonUtils;
import me.leavestyle.handler.StrAbstractCacheHandler;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StrCacheFunUtils {
    private static final Logger log = LoggerFactory.getLogger(StrCacheFunUtils.class);

    StrCacheFunUtils() {
    }

    public static <K, V, R> Map<K, V> fetchFromCache(List<K> keys, StrAbstractCacheHandler<K, V, R> handler, Function<String, V> convert) {
        List cacheKeys = keys.stream().map(handler.initRedisKeyFun).collect(Collectors.toList());
        List redisValues = (List)handler.initObtainCacheFun.apply(cacheKeys);
        log.debug("Fetch from cache, keys : {}, values : {}", cacheKeys, (Object)redisValues);
        return Stream.iterate(0, i -> i + 1).limit(keys.size()).map(i -> {
            String redisValue = (String)redisValues.get((int)i);
            if (Objects.isNull(redisValue)) {
                return null;
            }
            Object value = convert.apply(redisValue);
            if (value == null) {
                return null;
            }
            return Pair.of(keys.get((int)i), value);
        }).filter(Objects::nonNull).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
    }

    public static <K, V, R> Map<K, V> fetchFromDb(List<K> keys, StrAbstractCacheHandler<K, V, R> handler, Function<List<R>, Map<K, V>> classifier) {
        if (CollectionUtils.isEmpty(keys)) {
            return new HashMap();
        }
        log.debug("query from DB , keys are not cached = {} ", keys);
        List dbData = handler.reDbFun.apply(keys);
        if (CollectionUtils.isEmpty(dbData)) {
            return new HashMap();
        }
        return classifier.apply(dbData);
    }

    public static <K, V, R> void writeToCache(List<K> unCachedKeys, Map<K, V> dbData, Predicate<V> emptyStrategy, StrAbstractCacheHandler<K, V, R> handler) {
        if (CollectionUtils.isEmpty(unCachedKeys)) {
            return;
        }
        Map<String, String> convertValues = unCachedKeys.stream().map(key -> {
            Object value = dbData.get(key);
            if (handler.opNoCacheStrategy.test(value)) {
                return null;
            }
            if (emptyStrategy.test(value)) {
                return Pair.of((Object)handler.initRedisKeyFun.apply(key), (Object)"");
            }
            try {
                return Pair.of((Object)handler.initRedisKeyFun.apply(key), (Object)JsonUtils.toJsonStr(value));
            }
            catch (JsonProcessingException e) {
                log.error("Convert object to json error : ", (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
        try {
            handler.initCacheBiConsumer.accept(convertValues, handler.opExpireTime);
            log.info("multiSet cache, keys = {} expireMs = {}", (Object)JsonUtils.toJsonStr(convertValues.keySet()), (Object)handler.opExpireTime);
        }
        catch (Exception e) {
            log.error("redis multi cache error : ", (Throwable)e);
        }
    }
}

