/*
 * Decompiled with CFR 0.152.
 */
package me.leavestyle.handler;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import me.leavestyle.common.JsonUtils;
import me.leavestyle.handler.StrAbstractCacheHandler;
import me.leavestyle.handler.StrCacheFunUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjStrCacheHandler<K, V>
extends StrAbstractCacheHandler<K, V, V> {
    private static final Logger log = LoggerFactory.getLogger(ObjStrCacheHandler.class);

    @Override
    protected Map<K, V> fetchFromCache(List<K> keys) {
        return StrCacheFunUtils.fetchFromCache(keys, this, cacheValue -> JsonUtils.toObjWithDefault(cacheValue, this.initValueType));
    }

    @Override
    protected Map<K, V> fetchFromDb(List<K> keys) {
        return StrCacheFunUtils.fetchFromDb(keys, this, dbData -> dbData.stream().collect(Collectors.toMap(this.reDbGroupFun, i -> i)));
    }

    @Override
    protected void writeToCache(List<K> unCachedKeys, Map<K, V> dbData) {
        StrCacheFunUtils.writeToCache(unCachedKeys, dbData, Objects::isNull, this);
    }

    @Override
    protected List<V> mergeData(List<K> keys, Map<K, V> cachedDb, Map<K, V> dbData) {
        return keys.stream().map(key -> cachedDb.getOrDefault(key, dbData.get(key))).filter(Objects::nonNull).collect(Collectors.toList());
    }

    protected ObjStrCacheHandler(ObjStrCacheHandlerBuilder<K, V, ?, ?> b) {
        super(b);
    }

    public static <K, V> ObjStrCacheHandlerBuilder<K, V, ?, ?> builder() {
        return new ObjStrCacheHandlerBuilderImpl();
    }

    public ObjStrCacheHandlerBuilder<K, V, ?, ?> toBuilder() {
        return new ObjStrCacheHandlerBuilderImpl().$fillValuesFrom(this);
    }

    private static final class ObjStrCacheHandlerBuilderImpl<K, V>
    extends ObjStrCacheHandlerBuilder<K, V, ObjStrCacheHandler<K, V>, ObjStrCacheHandlerBuilderImpl<K, V>> {
        private ObjStrCacheHandlerBuilderImpl() {
        }

        @Override
        protected ObjStrCacheHandlerBuilderImpl<K, V> self() {
            return this;
        }

        @Override
        public ObjStrCacheHandler<K, V> build() {
            return new ObjStrCacheHandler(this);
        }
    }

    public static abstract class ObjStrCacheHandlerBuilder<K, V, C extends ObjStrCacheHandler<K, V>, B extends ObjStrCacheHandlerBuilder<K, V, C, B>>
    extends StrAbstractCacheHandler.StrAbstractCacheHandlerBuilder<K, V, V, C, B> {
        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ObjStrCacheHandlerBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static <K, V> void $fillValuesFromInstanceIntoBuilder(ObjStrCacheHandler<K, V> instance, ObjStrCacheHandlerBuilder<K, V, ?, ?> b) {
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "ObjStrCacheHandler.ObjStrCacheHandlerBuilder(super=" + super.toString() + ")";
        }
    }
}

