/*
 * Decompiled with CFR 0.152.
 */
package com.theokanning.openai.embedding;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import lombok.NonNull;

public class EmbeddingRequest {
    String model;
    @NonNull
    List<String> input;
    @JsonProperty(value="encoding_format")
    String encodingFormat;
    Integer dimensions;
    String user;

    public static EmbeddingRequestBuilder builder() {
        return new EmbeddingRequestBuilder();
    }

    public EmbeddingRequest() {
    }

    public EmbeddingRequest(String model, @NonNull List<String> input, String encodingFormat, Integer dimensions, String user) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        this.model = model;
        this.input = input;
        this.encodingFormat = encodingFormat;
        this.dimensions = dimensions;
        this.user = user;
    }

    public String getModel() {
        return this.model;
    }

    @NonNull
    public List<String> getInput() {
        return this.input;
    }

    public String getEncodingFormat() {
        return this.encodingFormat;
    }

    public Integer getDimensions() {
        return this.dimensions;
    }

    public String getUser() {
        return this.user;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public void setInput(@NonNull List<String> input) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        this.input = input;
    }

    @JsonProperty(value="encoding_format")
    public void setEncodingFormat(String encodingFormat) {
        this.encodingFormat = encodingFormat;
    }

    public void setDimensions(Integer dimensions) {
        this.dimensions = dimensions;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EmbeddingRequest)) {
            return false;
        }
        EmbeddingRequest other = (EmbeddingRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$dimensions = this.getDimensions();
        Integer other$dimensions = other.getDimensions();
        if (this$dimensions == null ? other$dimensions != null : !((Object)this$dimensions).equals(other$dimensions)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        List<String> this$input = this.getInput();
        List<String> other$input = other.getInput();
        if (this$input == null ? other$input != null : !((Object)this$input).equals(other$input)) {
            return false;
        }
        String this$encodingFormat = this.getEncodingFormat();
        String other$encodingFormat = other.getEncodingFormat();
        if (this$encodingFormat == null ? other$encodingFormat != null : !this$encodingFormat.equals(other$encodingFormat)) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        return !(this$user == null ? other$user != null : !this$user.equals(other$user));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EmbeddingRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $dimensions = this.getDimensions();
        result = result * 59 + ($dimensions == null ? 43 : ((Object)$dimensions).hashCode());
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        List<String> $input = this.getInput();
        result = result * 59 + ($input == null ? 43 : ((Object)$input).hashCode());
        String $encodingFormat = this.getEncodingFormat();
        result = result * 59 + ($encodingFormat == null ? 43 : $encodingFormat.hashCode());
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        return result;
    }

    public String toString() {
        return "EmbeddingRequest(model=" + this.getModel() + ", input=" + this.getInput() + ", encodingFormat=" + this.getEncodingFormat() + ", dimensions=" + this.getDimensions() + ", user=" + this.getUser() + ")";
    }

    public static class EmbeddingRequestBuilder {
        private String model;
        private List<String> input;
        private String encodingFormat;
        private Integer dimensions;
        private String user;

        EmbeddingRequestBuilder() {
        }

        public EmbeddingRequestBuilder model(String model) {
            this.model = model;
            return this;
        }

        public EmbeddingRequestBuilder input(@NonNull List<String> input) {
            if (input == null) {
                throw new NullPointerException("input is marked non-null but is null");
            }
            this.input = input;
            return this;
        }

        @JsonProperty(value="encoding_format")
        public EmbeddingRequestBuilder encodingFormat(String encodingFormat) {
            this.encodingFormat = encodingFormat;
            return this;
        }

        public EmbeddingRequestBuilder dimensions(Integer dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        public EmbeddingRequestBuilder user(String user) {
            this.user = user;
            return this;
        }

        public EmbeddingRequest build() {
            return new EmbeddingRequest(this.model, this.input, this.encodingFormat, this.dimensions, this.user);
        }

        public String toString() {
            return "EmbeddingRequest.EmbeddingRequestBuilder(model=" + this.model + ", input=" + this.input + ", encodingFormat=" + this.encodingFormat + ", dimensions=" + this.dimensions + ", user=" + this.user + ")";
        }
    }
}

