/*
 * Decompiled with CFR 0.152.
 */
package com.theokanning.openai.completion.chat;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.theokanning.openai.completion.chat.ChatMessage;
import com.theokanning.openai.completion.chat.ChatMessageRole;
import com.theokanning.openai.completion.chat.ContentDeserializer;
import com.theokanning.openai.completion.chat.ContentSerializer;
import com.theokanning.openai.completion.chat.ImageContent;
import com.theokanning.openai.completion.chat.ImageUrl;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class UserMessage
implements ChatMessage {
    private final String role = ChatMessageRole.USER.value();
    @JsonDeserialize(using=ContentDeserializer.class)
    @JsonSerialize(using=ContentSerializer.class)
    private Object content;
    private String name;

    public UserMessage(Object content) {
        this.content = content;
        this.contentTypeCheck();
    }

    public void setContent(Object content) {
        this.content = content;
        this.contentTypeCheck();
    }

    private void contentTypeCheck() {
        if (this.content instanceof String) {
            return;
        }
        if (this.content instanceof Collection) {
            Collection collection = (Collection)this.content;
            collection.forEach(item -> {
                if (!(item instanceof ImageContent)) {
                    throw new IllegalArgumentException("content must be a string or a collection of ImageContent");
                }
            });
            return;
        }
        throw new IllegalArgumentException("content must be a string or a collection of ImageContent");
    }

    @Override
    @JsonIgnore
    public String getTextContent() {
        Collection collection;
        Optional<Object> text;
        if (this.content instanceof String) {
            return (String)this.content;
        }
        if (this.content instanceof Collection && (text = (collection = (Collection)this.content).stream().filter(item -> item instanceof ImageContent).filter(imageContent -> ((ImageContent)imageContent).getType().equals("text")).findFirst().map(imageContent -> ((ImageContent)imageContent).getText())).isPresent()) {
            return (String)text.get();
        }
        return null;
    }

    public static UserMessage buildImageMessage(String text, String ... imageUrls) {
        List imageContents = Arrays.stream(imageUrls).map(url -> new ImageContent(new ImageUrl((String)url))).collect(Collectors.toList());
        imageContents.add(0, new ImageContent(text));
        return new UserMessage(imageContents);
    }

    @Override
    public String getRole() {
        return this.role;
    }

    public Object getContent() {
        return this.content;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserMessage)) {
            return false;
        }
        UserMessage other = (UserMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$role = this.getRole();
        String other$role = other.getRole();
        if (this$role == null ? other$role != null : !this$role.equals(other$role)) {
            return false;
        }
        Object this$content = this.getContent();
        Object other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UserMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $role = this.getRole();
        result = result * 59 + ($role == null ? 43 : $role.hashCode());
        Object $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public String toString() {
        return "UserMessage(role=" + this.getRole() + ", content=" + this.getContent() + ", name=" + this.getName() + ")";
    }

    public UserMessage() {
    }

    public UserMessage(Object content, String name) {
        this.content = content;
        this.name = name;
    }
}

