/*
 * Decompiled with CFR 0.152.
 */
package com.theokanning.openai.completion.chat;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.theokanning.openai.completion.chat.ImageContent;
import com.theokanning.openai.completion.chat.ImageUrl;
import java.io.IOException;
import java.util.ArrayList;

public class ContentDeserializer
extends JsonDeserializer<Object> {
    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JacksonException {
        if (jsonParser.getCurrentToken() == JsonToken.VALUE_STRING) {
            return jsonParser.getText();
        }
        if (jsonParser.getCurrentToken() == JsonToken.START_ARRAY) {
            ArrayList<ImageContent> contents = new ArrayList<ImageContent>();
            while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                ImageContent content = this.parseContent(jsonParser);
                if (content == null) continue;
                contents.add(content);
            }
            return contents;
        }
        return null;
    }

    ImageContent parseContent(JsonParser jsonParser) throws IOException {
        ImageContent content = new ImageContent();
        while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
            String fieldName = jsonParser.getCurrentName();
            jsonParser.nextToken();
            if ("type".equals(fieldName)) {
                content.setType(jsonParser.getText());
                continue;
            }
            if ("text".equals(fieldName)) {
                content.setText(jsonParser.getText());
                continue;
            }
            if (!"image_url".equals(fieldName)) continue;
            jsonParser.nextToken();
            if (!"url".equals(jsonParser.getCurrentName())) continue;
            jsonParser.nextToken();
            content.setImageUrl(new ImageUrl(jsonParser.getText()));
            jsonParser.nextToken();
        }
        return content;
    }
}

