/*
 * Decompiled with CFR 0.152.
 */
package com.theokanning.openai.completion.chat;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import java.io.IOException;

public class ChatResponseFormat {
    private String type;
    public static final ChatResponseFormat AUTO = new ChatResponseFormat("auto");
    public static final ChatResponseFormat TEXT = new ChatResponseFormat("text");
    public static final ChatResponseFormat JSON_OBJECT = new ChatResponseFormat("json_object");

    private ChatResponseFormat(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChatResponseFormat)) {
            return false;
        }
        ChatResponseFormat other = (ChatResponseFormat)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChatResponseFormat;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    public String toString() {
        return "ChatResponseFormat(type=" + this.getType() + ")";
    }

    public static class ChatResponseFormatDeserializer
    extends JsonDeserializer<ChatResponseFormat> {
        public ChatResponseFormat deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JacksonException {
            if (jsonParser.getCurrentToken() == JsonToken.VALUE_STRING) {
                String text = jsonParser.getText();
                if (!"auto".equals(text)) {
                    throw new InvalidFormatException(jsonParser, "Invalid response format", (Object)jsonParser.getCurrentToken().toString(), ChatResponseFormat.class);
                }
                return new ChatResponseFormat(text);
            }
            if (jsonParser.getCurrentToken() == JsonToken.START_OBJECT) {
                while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
                    if (!jsonParser.getCurrentName().equals("type")) continue;
                    jsonParser.nextToken();
                    switch (jsonParser.getText()) {
                        case "auto": {
                            return AUTO;
                        }
                        case "text": {
                            return TEXT;
                        }
                        case "json_object": {
                            return JSON_OBJECT;
                        }
                    }
                    throw new InvalidFormatException(jsonParser, "Invalid response format", (Object)jsonParser.getCurrentToken().toString(), ChatResponseFormat.class);
                }
            }
            throw new InvalidFormatException(jsonParser, "Invalid response format", (Object)jsonParser.getCurrentToken().toString(), ChatResponseFormat.class);
        }
    }

    public static class ChatResponseFormatSerializer
    extends JsonSerializer<ChatResponseFormat> {
        public void serialize(ChatResponseFormat value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            if (value.getType().equals("auto")) {
                gen.writeString(value.getType());
            } else {
                gen.writeStartObject();
                gen.writeObjectField("type", (Object)value.getType());
                gen.writeEndObject();
            }
        }
    }
}

