/*
 * Decompiled with CFR 0.152.
 */
package com.theokanning.openai.completion.chat;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;

public class ChatFunctionCallArgumentsSerializerAndDeserializer {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    private ChatFunctionCallArgumentsSerializerAndDeserializer() {
    }

    public static class Deserializer
    extends JsonDeserializer<JsonNode> {
        private Deserializer() {
        }

        public JsonNode deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            String json = p.getValueAsString();
            if (json == null || p.currentToken() == JsonToken.VALUE_NULL) {
                return null;
            }
            if (!this.isValidJson(json)) {
                json = MAPPER.writeValueAsString((Object)json);
            }
            try {
                JsonNode node = null;
                try {
                    node = MAPPER.readTree(json);
                }
                catch (JsonParseException jsonParseException) {
                    // empty catch block
                }
                if (node == null || node.getNodeType() == JsonNodeType.MISSING) {
                    node = (JsonNode)MAPPER.readTree(p);
                }
                return node;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }

        private boolean isValidJson(String jsonString) {
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                JsonNode tree = objectMapper.readTree(jsonString);
                return tree != null && (tree.isObject() || tree.isArray());
            }
            catch (JsonProcessingException e) {
                return false;
            }
        }
    }

    public static class Serializer
    extends JsonSerializer<JsonNode> {
        private Serializer() {
        }

        public void serialize(JsonNode value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            if (value == null) {
                gen.writeNull();
            } else {
                gen.writeString(value instanceof TextNode ? value.asText() : value.toString());
            }
        }
    }
}

