/*
 * Decompiled with CFR 0.152.
 */
package com.theokanning.openai.completion.chat;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.theokanning.openai.assistants.run.ToolChoice;
import com.theokanning.openai.completion.chat.ChatCompletionRequestFunctionCall;
import com.theokanning.openai.completion.chat.ChatMessage;
import com.theokanning.openai.completion.chat.ChatResponseFormat;
import com.theokanning.openai.completion.chat.ChatTool;
import java.util.List;
import java.util.Map;

public class ChatCompletionRequest {
    String model;
    List<ChatMessage> messages;
    @JsonProperty(value="response_format")
    ChatResponseFormat responseFormat;
    Double temperature;
    @JsonProperty(value="top_p")
    Double topP;
    Integer n;
    Boolean stream;
    List<String> stop;
    @JsonProperty(value="max_tokens")
    Integer maxTokens;
    @JsonProperty(value="presence_penalty")
    Double presencePenalty;
    @JsonProperty(value="frequency_penalty")
    Double frequencyPenalty;
    @JsonProperty(value="logit_bias")
    Map<String, Integer> logitBias;
    String user;
    @Deprecated
    List<?> functions;
    @JsonProperty(value="function_call")
    @Deprecated
    @JsonSerialize(using=ChatCompletionRequestFunctionCall.Serializer.class)
    @JsonDeserialize(using=ChatCompletionRequestFunctionCall.Deserializer.class)
    Object functionCall;
    Integer seed;
    Boolean logprobs;
    @JsonProperty(value="top_logprobs")
    Integer topLogprobs;
    List<ChatTool> tools;
    @JsonProperty(value="tool_choice")
    @JsonSerialize(using=ToolChoice.Serializer.class)
    @JsonDeserialize(using=ToolChoice.Deserializer.class)
    ToolChoice toolChoice;

    public static ChatCompletionRequestBuilder builder() {
        return new InternalBuilder();
    }

    private void functionCallParamCheck() {
        if (this.functionCall == null) {
            return;
        }
        if (!(this.functionCall instanceof ChatCompletionRequestFunctionCall) && !(this.functionCall instanceof String)) {
            throw new IllegalArgumentException("functionCall must be a ChatCompletionRequestFunctionCall or a String type");
        }
    }

    public void setFunctionCall(Object functionCall) {
        this.functionCall = functionCall;
        this.functionCallParamCheck();
    }

    public String getModel() {
        return this.model;
    }

    public List<ChatMessage> getMessages() {
        return this.messages;
    }

    public ChatResponseFormat getResponseFormat() {
        return this.responseFormat;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public Double getTopP() {
        return this.topP;
    }

    public Integer getN() {
        return this.n;
    }

    public Boolean getStream() {
        return this.stream;
    }

    public List<String> getStop() {
        return this.stop;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public Double getPresencePenalty() {
        return this.presencePenalty;
    }

    public Double getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    public Map<String, Integer> getLogitBias() {
        return this.logitBias;
    }

    public String getUser() {
        return this.user;
    }

    @Deprecated
    public List<?> getFunctions() {
        return this.functions;
    }

    @Deprecated
    public Object getFunctionCall() {
        return this.functionCall;
    }

    public Integer getSeed() {
        return this.seed;
    }

    public Boolean getLogprobs() {
        return this.logprobs;
    }

    public Integer getTopLogprobs() {
        return this.topLogprobs;
    }

    public List<ChatTool> getTools() {
        return this.tools;
    }

    public ToolChoice getToolChoice() {
        return this.toolChoice;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public void setMessages(List<ChatMessage> messages) {
        this.messages = messages;
    }

    @JsonProperty(value="response_format")
    public void setResponseFormat(ChatResponseFormat responseFormat) {
        this.responseFormat = responseFormat;
    }

    public void setTemperature(Double temperature) {
        this.temperature = temperature;
    }

    @JsonProperty(value="top_p")
    public void setTopP(Double topP) {
        this.topP = topP;
    }

    public void setN(Integer n) {
        this.n = n;
    }

    public void setStream(Boolean stream) {
        this.stream = stream;
    }

    public void setStop(List<String> stop) {
        this.stop = stop;
    }

    @JsonProperty(value="max_tokens")
    public void setMaxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
    }

    @JsonProperty(value="presence_penalty")
    public void setPresencePenalty(Double presencePenalty) {
        this.presencePenalty = presencePenalty;
    }

    @JsonProperty(value="frequency_penalty")
    public void setFrequencyPenalty(Double frequencyPenalty) {
        this.frequencyPenalty = frequencyPenalty;
    }

    @JsonProperty(value="logit_bias")
    public void setLogitBias(Map<String, Integer> logitBias) {
        this.logitBias = logitBias;
    }

    public void setUser(String user) {
        this.user = user;
    }

    @Deprecated
    public void setFunctions(List<?> functions) {
        this.functions = functions;
    }

    public void setSeed(Integer seed) {
        this.seed = seed;
    }

    public void setLogprobs(Boolean logprobs) {
        this.logprobs = logprobs;
    }

    @JsonProperty(value="top_logprobs")
    public void setTopLogprobs(Integer topLogprobs) {
        this.topLogprobs = topLogprobs;
    }

    public void setTools(List<ChatTool> tools) {
        this.tools = tools;
    }

    @JsonProperty(value="tool_choice")
    @JsonDeserialize(using=ToolChoice.Deserializer.class)
    public void setToolChoice(ToolChoice toolChoice) {
        this.toolChoice = toolChoice;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChatCompletionRequest)) {
            return false;
        }
        ChatCompletionRequest other = (ChatCompletionRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Double this$temperature = this.getTemperature();
        Double other$temperature = other.getTemperature();
        if (this$temperature == null ? other$temperature != null : !((Object)this$temperature).equals(other$temperature)) {
            return false;
        }
        Double this$topP = this.getTopP();
        Double other$topP = other.getTopP();
        if (this$topP == null ? other$topP != null : !((Object)this$topP).equals(other$topP)) {
            return false;
        }
        Integer this$n = this.getN();
        Integer other$n = other.getN();
        if (this$n == null ? other$n != null : !((Object)this$n).equals(other$n)) {
            return false;
        }
        Boolean this$stream = this.getStream();
        Boolean other$stream = other.getStream();
        if (this$stream == null ? other$stream != null : !((Object)this$stream).equals(other$stream)) {
            return false;
        }
        Integer this$maxTokens = this.getMaxTokens();
        Integer other$maxTokens = other.getMaxTokens();
        if (this$maxTokens == null ? other$maxTokens != null : !((Object)this$maxTokens).equals(other$maxTokens)) {
            return false;
        }
        Double this$presencePenalty = this.getPresencePenalty();
        Double other$presencePenalty = other.getPresencePenalty();
        if (this$presencePenalty == null ? other$presencePenalty != null : !((Object)this$presencePenalty).equals(other$presencePenalty)) {
            return false;
        }
        Double this$frequencyPenalty = this.getFrequencyPenalty();
        Double other$frequencyPenalty = other.getFrequencyPenalty();
        if (this$frequencyPenalty == null ? other$frequencyPenalty != null : !((Object)this$frequencyPenalty).equals(other$frequencyPenalty)) {
            return false;
        }
        Integer this$seed = this.getSeed();
        Integer other$seed = other.getSeed();
        if (this$seed == null ? other$seed != null : !((Object)this$seed).equals(other$seed)) {
            return false;
        }
        Boolean this$logprobs = this.getLogprobs();
        Boolean other$logprobs = other.getLogprobs();
        if (this$logprobs == null ? other$logprobs != null : !((Object)this$logprobs).equals(other$logprobs)) {
            return false;
        }
        Integer this$topLogprobs = this.getTopLogprobs();
        Integer other$topLogprobs = other.getTopLogprobs();
        if (this$topLogprobs == null ? other$topLogprobs != null : !((Object)this$topLogprobs).equals(other$topLogprobs)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        List<ChatMessage> this$messages = this.getMessages();
        List<ChatMessage> other$messages = other.getMessages();
        if (this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages)) {
            return false;
        }
        ChatResponseFormat this$responseFormat = this.getResponseFormat();
        ChatResponseFormat other$responseFormat = other.getResponseFormat();
        if (this$responseFormat == null ? other$responseFormat != null : !((Object)this$responseFormat).equals(other$responseFormat)) {
            return false;
        }
        List<String> this$stop = this.getStop();
        List<String> other$stop = other.getStop();
        if (this$stop == null ? other$stop != null : !((Object)this$stop).equals(other$stop)) {
            return false;
        }
        Map<String, Integer> this$logitBias = this.getLogitBias();
        Map<String, Integer> other$logitBias = other.getLogitBias();
        if (this$logitBias == null ? other$logitBias != null : !((Object)this$logitBias).equals(other$logitBias)) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        List<?> this$functions = this.getFunctions();
        List<?> other$functions = other.getFunctions();
        if (this$functions == null ? other$functions != null : !((Object)this$functions).equals(other$functions)) {
            return false;
        }
        Object this$functionCall = this.getFunctionCall();
        Object other$functionCall = other.getFunctionCall();
        if (this$functionCall == null ? other$functionCall != null : !this$functionCall.equals(other$functionCall)) {
            return false;
        }
        List<ChatTool> this$tools = this.getTools();
        List<ChatTool> other$tools = other.getTools();
        if (this$tools == null ? other$tools != null : !((Object)this$tools).equals(other$tools)) {
            return false;
        }
        ToolChoice this$toolChoice = this.getToolChoice();
        ToolChoice other$toolChoice = other.getToolChoice();
        return !(this$toolChoice == null ? other$toolChoice != null : !((Object)this$toolChoice).equals(other$toolChoice));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChatCompletionRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Double $temperature = this.getTemperature();
        result = result * 59 + ($temperature == null ? 43 : ((Object)$temperature).hashCode());
        Double $topP = this.getTopP();
        result = result * 59 + ($topP == null ? 43 : ((Object)$topP).hashCode());
        Integer $n = this.getN();
        result = result * 59 + ($n == null ? 43 : ((Object)$n).hashCode());
        Boolean $stream = this.getStream();
        result = result * 59 + ($stream == null ? 43 : ((Object)$stream).hashCode());
        Integer $maxTokens = this.getMaxTokens();
        result = result * 59 + ($maxTokens == null ? 43 : ((Object)$maxTokens).hashCode());
        Double $presencePenalty = this.getPresencePenalty();
        result = result * 59 + ($presencePenalty == null ? 43 : ((Object)$presencePenalty).hashCode());
        Double $frequencyPenalty = this.getFrequencyPenalty();
        result = result * 59 + ($frequencyPenalty == null ? 43 : ((Object)$frequencyPenalty).hashCode());
        Integer $seed = this.getSeed();
        result = result * 59 + ($seed == null ? 43 : ((Object)$seed).hashCode());
        Boolean $logprobs = this.getLogprobs();
        result = result * 59 + ($logprobs == null ? 43 : ((Object)$logprobs).hashCode());
        Integer $topLogprobs = this.getTopLogprobs();
        result = result * 59 + ($topLogprobs == null ? 43 : ((Object)$topLogprobs).hashCode());
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        List<ChatMessage> $messages = this.getMessages();
        result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
        ChatResponseFormat $responseFormat = this.getResponseFormat();
        result = result * 59 + ($responseFormat == null ? 43 : ((Object)$responseFormat).hashCode());
        List<String> $stop = this.getStop();
        result = result * 59 + ($stop == null ? 43 : ((Object)$stop).hashCode());
        Map<String, Integer> $logitBias = this.getLogitBias();
        result = result * 59 + ($logitBias == null ? 43 : ((Object)$logitBias).hashCode());
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        List<?> $functions = this.getFunctions();
        result = result * 59 + ($functions == null ? 43 : ((Object)$functions).hashCode());
        Object $functionCall = this.getFunctionCall();
        result = result * 59 + ($functionCall == null ? 43 : $functionCall.hashCode());
        List<ChatTool> $tools = this.getTools();
        result = result * 59 + ($tools == null ? 43 : ((Object)$tools).hashCode());
        ToolChoice $toolChoice = this.getToolChoice();
        result = result * 59 + ($toolChoice == null ? 43 : ((Object)$toolChoice).hashCode());
        return result;
    }

    public String toString() {
        return "ChatCompletionRequest(model=" + this.getModel() + ", messages=" + this.getMessages() + ", responseFormat=" + this.getResponseFormat() + ", temperature=" + this.getTemperature() + ", topP=" + this.getTopP() + ", n=" + this.getN() + ", stream=" + this.getStream() + ", stop=" + this.getStop() + ", maxTokens=" + this.getMaxTokens() + ", presencePenalty=" + this.getPresencePenalty() + ", frequencyPenalty=" + this.getFrequencyPenalty() + ", logitBias=" + this.getLogitBias() + ", user=" + this.getUser() + ", functions=" + this.getFunctions() + ", functionCall=" + this.getFunctionCall() + ", seed=" + this.getSeed() + ", logprobs=" + this.getLogprobs() + ", topLogprobs=" + this.getTopLogprobs() + ", tools=" + this.getTools() + ", toolChoice=" + this.getToolChoice() + ")";
    }

    public ChatCompletionRequest(String model, List<ChatMessage> messages, ChatResponseFormat responseFormat, Double temperature, Double topP, Integer n, Boolean stream, List<String> stop, Integer maxTokens, Double presencePenalty, Double frequencyPenalty, Map<String, Integer> logitBias, String user, List<?> functions, Object functionCall, Integer seed, Boolean logprobs, Integer topLogprobs, List<ChatTool> tools, ToolChoice toolChoice) {
        this.model = model;
        this.messages = messages;
        this.responseFormat = responseFormat;
        this.temperature = temperature;
        this.topP = topP;
        this.n = n;
        this.stream = stream;
        this.stop = stop;
        this.maxTokens = maxTokens;
        this.presencePenalty = presencePenalty;
        this.frequencyPenalty = frequencyPenalty;
        this.logitBias = logitBias;
        this.user = user;
        this.functions = functions;
        this.functionCall = functionCall;
        this.seed = seed;
        this.logprobs = logprobs;
        this.topLogprobs = topLogprobs;
        this.tools = tools;
        this.toolChoice = toolChoice;
    }

    public ChatCompletionRequest() {
    }

    public static class ChatCompletionRequestBuilder {
        private String model;
        private List<ChatMessage> messages;
        private ChatResponseFormat responseFormat;
        private Double temperature;
        private Double topP;
        private Integer n;
        private Boolean stream;
        private List<String> stop;
        private Integer maxTokens;
        private Double presencePenalty;
        private Double frequencyPenalty;
        private Map<String, Integer> logitBias;
        private String user;
        private List<?> functions;
        private Object functionCall;
        private Integer seed;
        private Boolean logprobs;
        private Integer topLogprobs;
        private List<ChatTool> tools;
        private ToolChoice toolChoice;

        ChatCompletionRequestBuilder() {
        }

        public ChatCompletionRequestBuilder model(String model) {
            this.model = model;
            return this;
        }

        public ChatCompletionRequestBuilder messages(List<ChatMessage> messages) {
            this.messages = messages;
            return this;
        }

        @JsonProperty(value="response_format")
        public ChatCompletionRequestBuilder responseFormat(ChatResponseFormat responseFormat) {
            this.responseFormat = responseFormat;
            return this;
        }

        public ChatCompletionRequestBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        @JsonProperty(value="top_p")
        public ChatCompletionRequestBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public ChatCompletionRequestBuilder n(Integer n) {
            this.n = n;
            return this;
        }

        public ChatCompletionRequestBuilder stream(Boolean stream) {
            this.stream = stream;
            return this;
        }

        public ChatCompletionRequestBuilder stop(List<String> stop) {
            this.stop = stop;
            return this;
        }

        @JsonProperty(value="max_tokens")
        public ChatCompletionRequestBuilder maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        @JsonProperty(value="presence_penalty")
        public ChatCompletionRequestBuilder presencePenalty(Double presencePenalty) {
            this.presencePenalty = presencePenalty;
            return this;
        }

        @JsonProperty(value="frequency_penalty")
        public ChatCompletionRequestBuilder frequencyPenalty(Double frequencyPenalty) {
            this.frequencyPenalty = frequencyPenalty;
            return this;
        }

        @JsonProperty(value="logit_bias")
        public ChatCompletionRequestBuilder logitBias(Map<String, Integer> logitBias) {
            this.logitBias = logitBias;
            return this;
        }

        public ChatCompletionRequestBuilder user(String user) {
            this.user = user;
            return this;
        }

        @Deprecated
        public ChatCompletionRequestBuilder functions(List<?> functions) {
            this.functions = functions;
            return this;
        }

        @Deprecated
        @JsonProperty(value="function_call")
        @JsonDeserialize(using=ChatCompletionRequestFunctionCall.Deserializer.class)
        public ChatCompletionRequestBuilder functionCall(Object functionCall) {
            this.functionCall = functionCall;
            return this;
        }

        public ChatCompletionRequestBuilder seed(Integer seed) {
            this.seed = seed;
            return this;
        }

        public ChatCompletionRequestBuilder logprobs(Boolean logprobs) {
            this.logprobs = logprobs;
            return this;
        }

        @JsonProperty(value="top_logprobs")
        public ChatCompletionRequestBuilder topLogprobs(Integer topLogprobs) {
            this.topLogprobs = topLogprobs;
            return this;
        }

        public ChatCompletionRequestBuilder tools(List<ChatTool> tools) {
            this.tools = tools;
            return this;
        }

        @JsonProperty(value="tool_choice")
        @JsonDeserialize(using=ToolChoice.Deserializer.class)
        public ChatCompletionRequestBuilder toolChoice(ToolChoice toolChoice) {
            this.toolChoice = toolChoice;
            return this;
        }

        public ChatCompletionRequest build() {
            return new ChatCompletionRequest(this.model, this.messages, this.responseFormat, this.temperature, this.topP, this.n, this.stream, this.stop, this.maxTokens, this.presencePenalty, this.frequencyPenalty, this.logitBias, this.user, this.functions, this.functionCall, this.seed, this.logprobs, this.topLogprobs, this.tools, this.toolChoice);
        }

        public String toString() {
            return "ChatCompletionRequest.ChatCompletionRequestBuilder(model=" + this.model + ", messages=" + this.messages + ", responseFormat=" + this.responseFormat + ", temperature=" + this.temperature + ", topP=" + this.topP + ", n=" + this.n + ", stream=" + this.stream + ", stop=" + this.stop + ", maxTokens=" + this.maxTokens + ", presencePenalty=" + this.presencePenalty + ", frequencyPenalty=" + this.frequencyPenalty + ", logitBias=" + this.logitBias + ", user=" + this.user + ", functions=" + this.functions + ", functionCall=" + this.functionCall + ", seed=" + this.seed + ", logprobs=" + this.logprobs + ", topLogprobs=" + this.topLogprobs + ", tools=" + this.tools + ", toolChoice=" + this.toolChoice + ")";
        }
    }

    private static class InternalBuilder
    extends ChatCompletionRequestBuilder {
        @Override
        public ChatCompletionRequest build() {
            ChatCompletionRequest request = super.build();
            request.functionCallParamCheck();
            return request;
        }
    }
}

