/*
 * Decompiled with CFR 0.152.
 */
package com.theokanning.openai.assistants.run;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.theokanning.openai.assistants.run.Function;
import java.io.IOException;

public class ToolChoice {
    String type;
    Function function;
    public static final ToolChoice NONE = new ToolChoice("none");
    public static final ToolChoice AUTO = new ToolChoice("auto");

    private ToolChoice(String type) {
        this.type = type;
    }

    public ToolChoice(Function function) {
        this.type = "function";
        if (function == null) {
            throw new IllegalArgumentException("Function must not be null");
        }
        this.function = function;
    }

    public String getType() {
        return this.type;
    }

    public Function getFunction() {
        return this.function;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setFunction(Function function) {
        this.function = function;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ToolChoice)) {
            return false;
        }
        ToolChoice other = (ToolChoice)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Function this$function = this.getFunction();
        Function other$function = other.getFunction();
        return !(this$function == null ? other$function != null : !((Object)this$function).equals(other$function));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ToolChoice;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Function $function = this.getFunction();
        result = result * 59 + ($function == null ? 43 : ((Object)$function).hashCode());
        return result;
    }

    public String toString() {
        return "ToolChoice(type=" + this.getType() + ", function=" + this.getFunction() + ")";
    }

    public static class Serializer
    extends JsonSerializer<ToolChoice> {
        public void serialize(ToolChoice toolChoice, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            String type;
            switch (type = toolChoice.getType()) {
                case "none": {
                    jsonGenerator.writeString(type);
                    break;
                }
                case "auto": {
                    jsonGenerator.writeString(type);
                    break;
                }
                default: {
                    jsonGenerator.writeStartObject();
                    jsonGenerator.writeStringField("type", type);
                    if (toolChoice.getType().equals("function")) {
                        jsonGenerator.writeObjectField("function", (Object)toolChoice.getFunction());
                    }
                    jsonGenerator.writeEndObject();
                }
            }
        }
    }

    public static class Deserializer
    extends JsonDeserializer<ToolChoice> {
        public ToolChoice deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            if (jsonParser.getCurrentToken() == JsonToken.VALUE_STRING) {
                String type;
                switch (type = jsonParser.getText()) {
                    case "none": {
                        return NONE;
                    }
                    case "auto": {
                        return AUTO;
                    }
                }
                return new ToolChoice(type);
            }
            if (jsonParser.getCurrentToken() == JsonToken.START_OBJECT) {
                while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
                    if (!jsonParser.getCurrentName().equals("function")) continue;
                    jsonParser.nextToken();
                    return new ToolChoice(this.parseFunction(jsonParser));
                }
            }
            throw new IllegalArgumentException("Invalid ToolChoice");
        }

        private Function parseFunction(JsonParser jsonParser) throws IOException {
            if (jsonParser.getCurrentToken() == JsonToken.START_OBJECT) {
                Function function = new Function();
                while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
                    if (!jsonParser.getCurrentName().equals("name")) continue;
                    function.setName(jsonParser.nextTextValue());
                }
                jsonParser.nextToken();
                return function;
            }
            throw new IllegalArgumentException("Invalid Function");
        }
    }
}

