/*
 * Decompiled with CFR 0.152.
 */
package com.theokanning.openai.assistants.assistant;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.theokanning.openai.assistants.assistant.Tool;
import com.theokanning.openai.assistants.assistant.ToolResources;
import com.theokanning.openai.completion.chat.ChatResponseFormat;
import java.util.List;
import java.util.Map;
import lombok.NonNull;

public class Assistant {
    String id;
    String object;
    @JsonProperty(value="created_at")
    Integer createdAt;
    String name;
    String description;
    @NonNull
    String model;
    String instructions;
    List<Tool> tools;
    @JsonProperty(value="tool_resources")
    ToolResources toolResources;
    private Map<String, String> metadata;
    Double temperature;
    @JsonProperty(value="top_p")
    Double topP;
    @JsonProperty(value="response_format")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=ChatResponseFormat.ChatResponseFormatSerializer.class)
    @JsonDeserialize(using=ChatResponseFormat.ChatResponseFormatDeserializer.class)
    ChatResponseFormat responseFormat;

    public static AssistantBuilder builder() {
        return new AssistantBuilder();
    }

    public Assistant() {
    }

    public Assistant(String id, String object, Integer createdAt, String name, String description, @NonNull String model, String instructions, List<Tool> tools, ToolResources toolResources, Map<String, String> metadata, Double temperature, Double topP, ChatResponseFormat responseFormat) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        this.id = id;
        this.object = object;
        this.createdAt = createdAt;
        this.name = name;
        this.description = description;
        this.model = model;
        this.instructions = instructions;
        this.tools = tools;
        this.toolResources = toolResources;
        this.metadata = metadata;
        this.temperature = temperature;
        this.topP = topP;
        this.responseFormat = responseFormat;
    }

    public String getId() {
        return this.id;
    }

    public String getObject() {
        return this.object;
    }

    public Integer getCreatedAt() {
        return this.createdAt;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    @NonNull
    public String getModel() {
        return this.model;
    }

    public String getInstructions() {
        return this.instructions;
    }

    public List<Tool> getTools() {
        return this.tools;
    }

    public ToolResources getToolResources() {
        return this.toolResources;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public Double getTopP() {
        return this.topP;
    }

    public ChatResponseFormat getResponseFormat() {
        return this.responseFormat;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setObject(String object) {
        this.object = object;
    }

    @JsonProperty(value="created_at")
    public void setCreatedAt(Integer createdAt) {
        this.createdAt = createdAt;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setModel(@NonNull String model) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        this.model = model;
    }

    public void setInstructions(String instructions) {
        this.instructions = instructions;
    }

    public void setTools(List<Tool> tools) {
        this.tools = tools;
    }

    @JsonProperty(value="tool_resources")
    public void setToolResources(ToolResources toolResources) {
        this.toolResources = toolResources;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public void setTemperature(Double temperature) {
        this.temperature = temperature;
    }

    @JsonProperty(value="top_p")
    public void setTopP(Double topP) {
        this.topP = topP;
    }

    @JsonProperty(value="response_format")
    @JsonDeserialize(using=ChatResponseFormat.ChatResponseFormatDeserializer.class)
    public void setResponseFormat(ChatResponseFormat responseFormat) {
        this.responseFormat = responseFormat;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Assistant)) {
            return false;
        }
        Assistant other = (Assistant)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$createdAt = this.getCreatedAt();
        Integer other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        Double this$temperature = this.getTemperature();
        Double other$temperature = other.getTemperature();
        if (this$temperature == null ? other$temperature != null : !((Object)this$temperature).equals(other$temperature)) {
            return false;
        }
        Double this$topP = this.getTopP();
        Double other$topP = other.getTopP();
        if (this$topP == null ? other$topP != null : !((Object)this$topP).equals(other$topP)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        String this$instructions = this.getInstructions();
        String other$instructions = other.getInstructions();
        if (this$instructions == null ? other$instructions != null : !this$instructions.equals(other$instructions)) {
            return false;
        }
        List<Tool> this$tools = this.getTools();
        List<Tool> other$tools = other.getTools();
        if (this$tools == null ? other$tools != null : !((Object)this$tools).equals(other$tools)) {
            return false;
        }
        ToolResources this$toolResources = this.getToolResources();
        ToolResources other$toolResources = other.getToolResources();
        if (this$toolResources == null ? other$toolResources != null : !((Object)this$toolResources).equals(other$toolResources)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        ChatResponseFormat this$responseFormat = this.getResponseFormat();
        ChatResponseFormat other$responseFormat = other.getResponseFormat();
        return !(this$responseFormat == null ? other$responseFormat != null : !((Object)this$responseFormat).equals(other$responseFormat));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Assistant;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        Double $temperature = this.getTemperature();
        result = result * 59 + ($temperature == null ? 43 : ((Object)$temperature).hashCode());
        Double $topP = this.getTopP();
        result = result * 59 + ($topP == null ? 43 : ((Object)$topP).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        String $instructions = this.getInstructions();
        result = result * 59 + ($instructions == null ? 43 : $instructions.hashCode());
        List<Tool> $tools = this.getTools();
        result = result * 59 + ($tools == null ? 43 : ((Object)$tools).hashCode());
        ToolResources $toolResources = this.getToolResources();
        result = result * 59 + ($toolResources == null ? 43 : ((Object)$toolResources).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        ChatResponseFormat $responseFormat = this.getResponseFormat();
        result = result * 59 + ($responseFormat == null ? 43 : ((Object)$responseFormat).hashCode());
        return result;
    }

    public String toString() {
        return "Assistant(id=" + this.getId() + ", object=" + this.getObject() + ", createdAt=" + this.getCreatedAt() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", model=" + this.getModel() + ", instructions=" + this.getInstructions() + ", tools=" + this.getTools() + ", toolResources=" + this.getToolResources() + ", metadata=" + this.getMetadata() + ", temperature=" + this.getTemperature() + ", topP=" + this.getTopP() + ", responseFormat=" + this.getResponseFormat() + ")";
    }

    public static class AssistantBuilder {
        private String id;
        private String object;
        private Integer createdAt;
        private String name;
        private String description;
        private String model;
        private String instructions;
        private List<Tool> tools;
        private ToolResources toolResources;
        private Map<String, String> metadata;
        private Double temperature;
        private Double topP;
        private ChatResponseFormat responseFormat;

        AssistantBuilder() {
        }

        public AssistantBuilder id(String id) {
            this.id = id;
            return this;
        }

        public AssistantBuilder object(String object) {
            this.object = object;
            return this;
        }

        @JsonProperty(value="created_at")
        public AssistantBuilder createdAt(Integer createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public AssistantBuilder name(String name) {
            this.name = name;
            return this;
        }

        public AssistantBuilder description(String description) {
            this.description = description;
            return this;
        }

        public AssistantBuilder model(@NonNull String model) {
            if (model == null) {
                throw new NullPointerException("model is marked non-null but is null");
            }
            this.model = model;
            return this;
        }

        public AssistantBuilder instructions(String instructions) {
            this.instructions = instructions;
            return this;
        }

        public AssistantBuilder tools(List<Tool> tools) {
            this.tools = tools;
            return this;
        }

        @JsonProperty(value="tool_resources")
        public AssistantBuilder toolResources(ToolResources toolResources) {
            this.toolResources = toolResources;
            return this;
        }

        public AssistantBuilder metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public AssistantBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        @JsonProperty(value="top_p")
        public AssistantBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        @JsonProperty(value="response_format")
        @JsonDeserialize(using=ChatResponseFormat.ChatResponseFormatDeserializer.class)
        public AssistantBuilder responseFormat(ChatResponseFormat responseFormat) {
            this.responseFormat = responseFormat;
            return this;
        }

        public Assistant build() {
            return new Assistant(this.id, this.object, this.createdAt, this.name, this.description, this.model, this.instructions, this.tools, this.toolResources, this.metadata, this.temperature, this.topP, this.responseFormat);
        }

        public String toString() {
            return "Assistant.AssistantBuilder(id=" + this.id + ", object=" + this.object + ", createdAt=" + this.createdAt + ", name=" + this.name + ", description=" + this.description + ", model=" + this.model + ", instructions=" + this.instructions + ", tools=" + this.tools + ", toolResources=" + this.toolResources + ", metadata=" + this.metadata + ", temperature=" + this.temperature + ", topP=" + this.topP + ", responseFormat=" + this.responseFormat + ")";
        }
    }
}

