/*
 * Decompiled with CFR 0.152.
 */
package com.theokanning.openai.assistants;

import com.theokanning.openai.OpenAiError;
import com.theokanning.openai.assistants.message.Message;
import com.theokanning.openai.assistants.message.content.MessageDelta;
import com.theokanning.openai.assistants.run.Run;
import com.theokanning.openai.assistants.run_step.RunStep;
import com.theokanning.openai.assistants.run_step.RunStepDelta;
import com.theokanning.openai.assistants.thread.Thread;

public enum StreamEvent {
    THREAD_CREATED("thread.created", Thread.class),
    THREAD_RUN_CREATED("thread.run.created", Run.class),
    THREAD_RUN_QUEUED("thread.run.queued", Run.class),
    THREAD_RUN_IN_PROGRESS("thread.run.in_progress", Run.class),
    THREAD_RUN_REQUIRES_ACTION("thread.run.requires_action", Run.class),
    THREAD_RUN_COMPLETED("thread.run.completed", Run.class),
    THREAD_RUN_FAILED("thread.run.failed", Run.class),
    THREAD_RUN_CANCELLING("thread.run.cancelling", Run.class),
    THREAD_RUN_CANCELLED("thread.run.cancelled", Run.class),
    THREAD_RUN_EXPIRED("thread.run.expired", Run.class),
    THREAD_RUN_STEP_CREATED("thread.run.step.created", RunStep.class),
    THREAD_RUN_STEP_IN_PROGRESS("thread.run.step.in_progress", RunStep.class),
    THREAD_RUN_STEP_DELTA("thread.run.step.delta", RunStepDelta.class),
    THREAD_RUN_STEP_COMPLETED("thread.run.step.completed", RunStep.class),
    THREAD_RUN_STEP_FAILED("thread.run.step.failed", RunStep.class),
    THREAD_RUN_STEP_CANCELLED("thread.run.step.cancelled", RunStep.class),
    THREAD_RUN_STEP_EXPIRED("thread.run.step.expired", RunStep.class),
    THREAD_MESSAGE_CREATED("thread.message.created", Message.class),
    THREAD_MESSAGE_IN_PROGRESS("thread.message.in_progress", Message.class),
    THREAD_MESSAGE_DELTA("thread.message.delta", MessageDelta.class),
    THREAD_MESSAGE_COMPLETED("thread.message.completed", Message.class),
    THREAD_MESSAGE_INCOMPLETE("thread.message.incomplete", Message.class),
    ERROR("error", OpenAiError.class),
    DONE("done", Void.class);

    public String eventName;
    public Class<?> dataClass;

    public static StreamEvent valueByName(String eventName) {
        for (StreamEvent value : StreamEvent.values()) {
            if (!value.eventName.equals(eventName)) continue;
            return value;
        }
        throw new IllegalArgumentException("Unknown event name: " + eventName);
    }

    private StreamEvent(String eventName, Class<?> dataClass) {
        this.eventName = eventName;
        this.dataClass = dataClass;
    }
}

